/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.FileSystems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.core.archive.FileArchiveReader;
import org.eclipse.birt.core.archive.FileArchiveWriter;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class ReportDocumentTest
extends EngineCase {
    protected IReportRunnable reportRunnable;
    private String path = this.getInputResourceFolder() + File.separator + this.getFullQualifiedClassName() + File.separator;

    public ReportDocumentTest(String name) {
        super(name);
    }

    public static Test Suite() {
        return new TestSuite(ReportDocumentTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("report_document.rptdesign", "report_document.rptdesign");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public void testReportDocument() {
        String report_design = this.path + "input" + FileSystems.getDefault().getSeparator() + "report_document.rptdesign";
        String report_document = this.genOutputFile("report_document");
        try {
            this.createReportDocument_param(report_design, report_document);
            FileArchiveReader archive = new FileArchiveReader(report_document);
            IReportDocument reportDoc = this.engine.openReportDocument(report_document);
            ITOCTree tree = reportDoc.getTOCTree(null, ULocale.ENGLISH);
            TOCNode root = tree.findTOC("/");
            ReportDocumentTest.assertNotNull((String)"get root toc", (Object)root);
            ReportDocumentTest.assertNotNull((String)"root contain no children toc", (Object)root.getChildren());
            TOCNode tableNode = (TOCNode)root.getChildren().get(0);
            ReportDocumentTest.assertNotNull((String)"table toc doesn't exist.", (Object)tableNode);
            ReportDocumentTest.assertEquals((String)"table toc expression isn't TableSection", (String)"TableSection", (String)tableNode.getDisplayString());
            ReportDocumentTest.assertNotNull((String)"table toc doesn't contain nodes", (Object)tableNode.getChildren());
            ReportDocumentTest.assertEquals((String)"table toc doesn't contain 6 nodes", (int)6, (int)tableNode.getChildren().size());
            TOCNode headerNode = (TOCNode)tableNode.getChildren().get(0);
            TOCNode groupNode = (TOCNode)((TOCNode)tableNode.getChildren().get(1)).getChildren().get(0);
            TOCNode footerNode = (TOCNode)tableNode.getChildren().get(5);
            ReportDocumentTest.assertNotNull((String)"table header toc doesn't exist", (Object)headerNode);
            ReportDocumentTest.assertNotNull((String)"table group toc doesn't exist", (Object)groupNode);
            ReportDocumentTest.assertNotNull((String)"table footer toc doesn't exist", (Object)footerNode);
            ReportDocumentTest.assertEquals((String)"header toc expression isn't HeaderSection", (String)"HeaderSection", (String)headerNode.getDisplayString());
            ReportDocumentTest.assertEquals((String)"group toc expression isn't GroupSection", (String)"GroupSection", (String)groupNode.getDisplayString());
            ReportDocumentTest.assertEquals((String)"footer toc expression isn't FooterSection", (String)"FooterSection", (String)footerNode.getDisplayString());
            ReportDocumentTest.assertNotNull((String)"table group toc doesn't contain nodes", (Object)groupNode.getChildren());
            TOCNode detailNode = (TOCNode)((TOCNode)tableNode.getChildren().get(1)).getChildren().get(1);
            ReportDocumentTest.assertEquals((String)"detail toc expression isn't DetailSection", (String)"DetailSection", (String)detailNode.getDisplayString());
            IDocArchiveReader arch = reportDoc.getArchive();
            ReportDocumentTest.assertNotNull((String)"get null document archive", (Object)arch);
            ReportDocumentTest.assertEquals((String)"get incorrect document archive", (String)archive.getName(), (String)arch.getName());
            ArrayList bookmarks = (ArrayList)reportDoc.getBookmarks();
            String hMark = "TableHeaderMark";
            String gMark = "TableGroupMark";
            String dMark = "TableDetailMark";
            String fMark = "TableFooterMark";
            String pMark = "ParameterMark";
            ReportDocumentTest.assertNotNull((String)"get no bookmarks", (Object)bookmarks);
            ReportDocumentTest.assertTrue((String)("bookmarks doesn't contain " + hMark), (boolean)bookmarks.contains(hMark));
            ReportDocumentTest.assertTrue((String)("bookmarks doesn't contain " + gMark), (boolean)bookmarks.contains(gMark));
            ReportDocumentTest.assertTrue((String)("bookmarks doesn't contain " + dMark), (boolean)bookmarks.contains(dMark));
            ReportDocumentTest.assertTrue((String)("bookmarks doesn't contain " + fMark), (boolean)bookmarks.contains(fMark));
            ReportDocumentTest.assertTrue((String)("bookmarks doesn't contain " + pMark), (boolean)bookmarks.contains(pMark));
            List root_children = reportDoc.getChildren("/");
            ReportDocumentTest.assertNotNull((String)"cannot get root toc's children", (Object)root_children);
            ReportDocumentTest.assertNotNull((String)"cannot get table toc", root_children.get(0));
            TOCNode table_toc = (TOCNode)root_children.get(0);
            List table_children = reportDoc.getChildren(table_toc.getNodeID());
            ReportDocumentTest.assertNotNull((String)"table toc's children is null", (Object)table_children);
            ReportDocumentTest.assertEquals((String)"table toc contains 6 children", (int)6, (int)table_children.size());
            InputStream designStream = reportDoc.getDesignStream();
            FileInputStream designFile = new FileInputStream(report_design);
            ReportDocumentTest.assertNotNull((Object)designStream);
            int length = designStream.available();
            ReportDocumentTest.assertTrue((length > 0 ? 1 : 0) != 0);
            designStream.close();
            designFile.close();
            ReportDocumentTest.assertEquals((String)"return wrong page count", (long)2L, (long)reportDoc.getPageCount());
            ReportDocumentTest.assertEquals((String)"return wrong page number which contains bookmark", (long)2L, (long)reportDoc.getPageNumber(pMark));
            HashMap params = (HashMap)reportDoc.getParameterValues();
            ReportDocumentTest.assertNotNull((String)"return no parameters", (Object)params);
            ReportDocumentTest.assertEquals((String)"parameter amount isn't 2", (int)2, (int)params.size());
            ReportDocumentTest.assertNotNull((String)"p1 parameter returned null", params.get("p1"));
            ReportDocumentTest.assertNotNull((String)"p2 parameter returned null", params.get("p2"));
            ReportDocumentTest.assertEquals((String)"p1 parameter returned wrong value", (Object)"p1string", params.get("p1"));
            ReportDocumentTest.assertEquals((String)"p1 parameter returned wrong value", (Object)new Integer(2), params.get("p2"));
            String name = report_document.substring(report_document.indexOf("org"));
            name = name.replace('/', '\\');
            ReportDocumentTest.assertEquals((String)"return wrong report document name", (String)name.replace('\\', '/'), (String)reportDoc.getName().substring(reportDoc.getName().indexOf("org"), reportDoc.getName().length()).replace('\\', '/'));
            IReportRunnable report = reportDoc.getReportRunnable();
            ReportDocumentTest.assertNotNull((String)"return null reportRunnable", (Object)report);
            ReportDocumentTest.assertEquals((String)"return wrong reportRunnable", (Object)this.reportRunnable.getReportEngine(), (Object)report.getReportEngine());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testReportDocument_abnormal() {
        String report_design = this.path + "input" + FileSystems.getDefault().getSeparator() + "report_document.rptdesign";
        String report_document = this.genOutputFile("report_document");
        try {
            this.createReportDocument(report_design, report_document);
            IReportDocument reportDoc = this.engine.openReportDocument(report_document);
            TOCNode tocNode = reportDoc.findTOC(null);
            ReportDocumentTest.assertEquals((String)"findToc should return null", null, (String)tocNode.getDisplayString());
            tocNode = reportDoc.findTOC("");
            ReportDocumentTest.assertNull((String)"1.findToc should return null toc node", (Object)tocNode);
            tocNode = reportDoc.findTOC("1");
            ReportDocumentTest.assertNull((String)"2.findToc should return null toc node", (Object)tocNode);
            tocNode = reportDoc.findTOC("\":)_+^&*%$#@!~<>");
            ReportDocumentTest.assertNull((String)"3.findToc should return null toc node", (Object)tocNode);
            List children = reportDoc.getChildren(null);
            ReportDocumentTest.assertNotNull((Object)children);
            ReportDocumentTest.assertEquals((String)"getChildren should return root node's children", (int)1, (int)children.size());
            children = reportDoc.getChildren("");
            ReportDocumentTest.assertNull((String)"1.getChildren should return null", (Object)children);
            children = reportDoc.getChildren("1");
            ReportDocumentTest.assertNull((String)"2.getChildren should return null", (Object)children);
            children = reportDoc.getChildren("\":)_+^&*%$#@!~<>??");
            ReportDocumentTest.assertNull((String)"3.getChildren should return null", (Object)children);
            String bookmark = null;
            long pageNum = reportDoc.getPageNumber(bookmark);
            ReportDocumentTest.assertEquals((String)"1.getPageNumber should return -1", (long)-1L, (long)pageNum);
            bookmark = "";
            pageNum = reportDoc.getPageNumber(bookmark);
            ReportDocumentTest.assertEquals((String)"2.getPageNumber should return -1", (long)-1L, (long)pageNum);
            bookmark = "\":)_+^&*%$#@!~<>??";
            pageNum = reportDoc.getPageNumber(bookmark);
            ReportDocumentTest.assertEquals((String)"3.getPageNumber should return -1", (long)-1L, (long)pageNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void createReportDocument(String reportdesign, String reportdocument) throws Exception {
        IReportRunnable report;
        FileArchiveWriter archive = new FileArchiveWriter(reportdocument);
        this.reportRunnable = report = this.engine.openReportDesign(reportdesign);
        IRunTask task = this.engine.createRunTask(report);
        task.run((IDocArchiveWriter)archive);
        task.close();
    }

    protected void createReportDocument_param(String reportdesign, String reportdocument) throws Exception {
        IReportRunnable report;
        FileArchiveWriter archive = new FileArchiveWriter(reportdocument);
        this.reportRunnable = report = this.engine.openReportDesign(reportdesign);
        IRunTask task = this.engine.createRunTask(report);
        HashMap<String, Object> inputParam = new HashMap<String, Object>();
        inputParam.put("p1", "p1string");
        inputParam.put("p2", new Integer(2));
        task.setParameterValues(inputParam);
        task.run((IDocArchiveWriter)archive);
        task.close();
    }
}

