/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.validators.GroupNameValidator;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class GroupNameValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testGroupNameValidator() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem("table1");
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        TableGroupHandle groupHandle1 = tableHandle.getElementFactory().newTableGroup();
        TableGroupHandle groupHandle2 = tableHandle.getElementFactory().newTableGroup();
        groupHandle1.setName("group1");
        GroupNameValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, GroupNameValidator.getInstance().getName(), "Error.SemanticError.DUPLICATE_GROUP_NAME"));
        groupHandle2.setName("group1");
        GroupNameValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, GroupNameValidator.getInstance().getName(), "Error.SemanticError.DUPLICATE_GROUP_NAME"));
        tableHandle.getGroups().add((DesignElementHandle)groupHandle1);
        GroupNameValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)tableHandle, GroupNameValidator.getInstance().getName(), "Error.SemanticError.DUPLICATE_GROUP_NAME"));
    }
}

