/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.List;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IClassInfo;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.metadata.IPropertyType;
import org.eclipse.birt.report.model.metadata.AbstractMetaTest;
import org.eclipse.birt.report.model.metadata.Choice;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetadataTestUtil;
import org.eclipse.birt.report.model.metadata.ObjectDefn;
import org.eclipse.birt.report.model.metadata.PredefinedStyle;
import org.eclipse.birt.report.model.metadata.SystemPropertyDefn;
import org.eclipse.birt.report.model.metadata.validators.IValueValidator;
import org.eclipse.birt.report.model.metadata.validators.PositiveValueValidator;

public class MetaDataDictionaryTest
extends AbstractMetaTest {
    private MetaDataDictionary dict = null;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.dict = MetaDataDictionary.getInstance();
    }

    public void testChoiceSet() {
        MetaDataDictionaryTest.assertNotNull((Object)this.dict.getPropertyType(5));
        MetaDataDictionaryTest.assertNotNull((Object)this.dict.getChoiceSet("fontWeight"));
        MetaDataDictionaryTest.assertNotNull((Object)this.dict.getChoiceSet("fontSize"));
        IChoice[] choices = this.dict.getChoiceSet("fontSize").getChoices();
        MetaDataDictionaryTest.assertTrue((choices.length == 9 ? 1 : 0) != 0);
        Choice extendedChoice = (Choice)choices[0];
        MetaDataDictionaryTest.assertEquals((String)extendedChoice.getDisplayNameKey(), (String)"Choices.fontSize.xx-small");
        MetaDataDictionaryTest.assertEquals((String)extendedChoice.getName(), (String)"xx-small");
        extendedChoice = (Choice)choices[1];
        MetaDataDictionaryTest.assertEquals((String)extendedChoice.getDisplayNameKey(), (String)"Choices.fontSize.x-small");
        MetaDataDictionaryTest.assertEquals((String)extendedChoice.getName(), (String)"x-small");
        IElementDefn defn = this.dict.getElement("Style");
        MetaDataDictionaryTest.assertNotNull((Object)defn);
        SystemPropertyDefn fontSizeDefn = (SystemPropertyDefn)defn.getProperty("fontSize");
        MetaDataDictionaryTest.assertNotNull((Object)fontSizeDefn);
        MetaDataDictionaryTest.assertEquals((int)fontSizeDefn.getTypeCode(), (int)3);
    }

    public void testGetElement() {
        MetaDataDictionaryTest.assertNull((Object)this.dict.getElement(null));
        MetaDataDictionaryTest.assertNull((Object)this.dict.getElement(""));
        MetaDataDictionaryTest.assertNull((Object)this.dict.getElement("NotExisting"));
        MetaDataDictionaryTest.assertNull((Object)this.dict.getElement(new String()));
        MetaDataDictionaryTest.assertEquals((String)"Label", (String)this.dict.getElement("Label").getName());
    }

    public void testResetAndIsEmpty() throws Exception {
        MetaDataDictionary.reset();
        MetaDataDictionaryTest.assertNotSame((Object)MetaDataDictionary.getInstance(), (Object)this.dict);
        MetaDataDictionaryTest.assertTrue((boolean)MetaDataDictionary.getInstance().isEmpty());
    }

    public void testAddInvalidElement() {
        ElementDefn element = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)element, null);
        try {
            MetadataTestUtil.addElementDefn((MetaDataDictionary)this.dict, (ElementDefn)element);
            MetaDataDictionaryTest.fail();
        }
        catch (MetaDataException metaDataException) {
            // empty catch block
        }
    }

    public void testAddOneElement() throws MetaDataException {
        ElementDefn element = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)element, (String)"TestItem");
        MetadataTestUtil.addElementDefn((MetaDataDictionary)this.dict, (ElementDefn)element);
        MetaDataDictionaryTest.assertEquals((String)element.getName(), (String)this.dict.getElement("TestItem").getName());
    }

    public void testSameElement() {
        ElementDefn element = new ElementDefn();
        MetadataTestUtil.setName((ObjectDefn)element, (String)"Label");
        try {
            MetadataTestUtil.addElementDefn((MetaDataDictionary)this.dict, (ElementDefn)element);
            MetadataTestUtil.addElementDefn((MetaDataDictionary)this.dict, (ElementDefn)element);
            MetaDataDictionaryTest.fail();
        }
        catch (MetaDataException metaDataException) {
            // empty catch block
        }
    }

    public void testAddInvalidPredefinedStyle() {
        PredefinedStyle style = new PredefinedStyle();
        MetadataTestUtil.setPredefinedStyleName((PredefinedStyle)style, null);
        try {
            MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)this.dict, (PredefinedStyle)style);
            MetaDataDictionaryTest.fail();
        }
        catch (MetaDataException metaDataException) {
            // empty catch block
        }
        style = new PredefinedStyle();
        MetadataTestUtil.setPredefinedStyleName((PredefinedStyle)style, (String)"");
        try {
            MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)this.dict, (PredefinedStyle)style);
            MetaDataDictionaryTest.fail();
        }
        catch (MetaDataException metaDataException) {
            // empty catch block
        }
    }

    public void testAddOnePredefinedStyle() throws MetaDataException {
        PredefinedStyle style = new PredefinedStyle();
        MetadataTestUtil.setPredefinedStyleName((PredefinedStyle)style, (String)"test");
        MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)this.dict, (PredefinedStyle)style);
        MetaDataDictionaryTest.assertNotNull((Object)this.dict.getPredefinedStyle("test"));
    }

    public void testAddSamePredefinedtyle() throws MetaDataException {
        PredefinedStyle style = new PredefinedStyle();
        MetadataTestUtil.setPredefinedStyleName((PredefinedStyle)style, (String)"test");
        MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)this.dict, (PredefinedStyle)style);
        MetaDataDictionaryTest.assertNotNull((Object)this.dict.getPredefinedStyle("test"));
        style = new PredefinedStyle();
        MetadataTestUtil.setPredefinedStyleName((PredefinedStyle)style, (String)"test");
        try {
            MetadataTestUtil.addPredefinedStyle((MetaDataDictionary)this.dict, (PredefinedStyle)style);
            MetaDataDictionaryTest.fail();
        }
        catch (MetaDataException metaDataException) {
            // empty catch block
        }
    }

    public void testGetValidator() {
        IValueValidator positiveValidator = this.dict.getValueValidator("PositiveValueValidator");
        MetaDataDictionaryTest.assertNotNull((Object)positiveValidator);
        MetaDataDictionaryTest.assertTrue((boolean)(positiveValidator instanceof PositiveValueValidator));
    }

    public void testGetClass() {
        IClassInfo total = this.dict.getClass("Total");
        List methods = total.getMethods();
        int count = 0;
        int i = 0;
        while (i < methods.size()) {
            String method = ((IMethodInfo)methods.get(i)).getName();
            if ("count-distinct".equalsIgnoreCase(method)) {
                ++count;
            }
            ++i;
        }
        MetaDataDictionaryTest.assertTrue((count == 1 ? 1 : 0) != 0);
    }

    public void testGetPropertyTypes() {
        List propTypes = this.dict.getPropertyTypes();
        MetaDataDictionaryTest.assertNotNull((Object)propTypes);
        int i = 0;
        while (i < propTypes.size()) {
            IPropertyType propType = (IPropertyType)propTypes.get(i);
            MetaDataDictionaryTest.assertEquals((int)i, (int)propType.getTypeCode());
            ++i;
        }
        MetaDataDictionaryTest.assertEquals((int)i, (int)26);
    }

    public void testGetFunctions() {
        List methods = this.dict.getFunctions();
        MetaDataDictionaryTest.assertEquals((int)25, (int)methods.size());
        IMethodInfo method = (IMethodInfo)methods.get(0);
        MetaDataDictionaryTest.assertEquals((String)"sum", (String)method.getName());
        MetaDataDictionaryTest.assertEquals((String)"Class.Total.sum", (String)method.getDisplayNameKey());
    }
}

