/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ParameterNameTest
extends BaseTestCase {
    private static final String fileName = "ParameterNameTest.xml";

    public void testCompatibility() throws Exception {
        this.openDesign(fileName);
        this.save();
        ParameterNameTest.assertTrue((boolean)this.compareFile("ParameterNameTest_golden.xml"));
    }

    public void testParser() throws Exception {
        try {
            this.openDesign("ParameterNameTest_1.xml");
        }
        catch (DesignFileException e) {
            List errors = e.getErrorList();
            ParameterNameTest.assertEquals((String)"Error.NameException.DUPLICATE", (String)((ErrorDetail)errors.get(0)).getErrorCode());
        }
        this.openDesign(fileName);
        ElementFactory factory = this.designHandle.getElementFactory();
        ScalarParameterHandle paramHandle = factory.newScalarParameter("PARAM1");
        ParameterNameTest.assertEquals((String)"PARAM12", (String)paramHandle.getName());
        paramHandle = factory.newParameterGroup("group");
        ParameterNameTest.assertEquals((String)"group", (String)paramHandle.getName());
        paramHandle = factory.newParameterGroup("Group");
        ParameterNameTest.assertEquals((String)"Group1", (String)paramHandle.getName());
    }
}

