/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import com.ibm.icu.util.ULocale;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.ConfigVariableHandle;
import org.eclipse.birt.report.model.api.CustomColorHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionConditionHandle;
import org.eclipse.birt.report.model.api.DimensionJoinConditionHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.IncludeScriptHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MapRuleHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.PropertyMaskHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SelectionChoiceHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.DimensionJoinCondition;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.IncludeScript;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.elements.structures.PropertyMask;
import org.eclipse.birt.report.model.api.elements.structures.SelectionChoice;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;
import org.eclipse.birt.report.model.api.olap.TabularCubeHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StructureHandleTest
extends BaseTestCase {
    public void testOperations() throws SemanticException {
        this.createDesign();
        PropertyHandle colorPaletteHandle = this.designHandle.getPropertyHandle("colorPalette");
        CustomColor red = StructureFactory.createCustomColor();
        red.setName("myred");
        red.setColor("0xFF0000");
        CustomColor green = StructureFactory.createCustomColor();
        green.setName("mygreen");
        green.setColor("0x00FF00");
        CustomColor blue = StructureFactory.createCustomColor();
        blue.setName("myblue");
        blue.setColor("0x0000FF");
        colorPaletteHandle.addItem((IStructure)red);
        colorPaletteHandle.addItem((IStructure)blue);
        colorPaletteHandle.insertItem((IStructure)green, 1);
        CustomColorHandle redHandle = (CustomColorHandle)red.getHandle((SimpleValueHandle)colorPaletteHandle);
        CustomColorHandle greenHandle = (CustomColorHandle)green.getHandle((SimpleValueHandle)colorPaletteHandle);
        CustomColorHandle blueHandle = (CustomColorHandle)blue.getHandle((SimpleValueHandle)colorPaletteHandle);
        ArrayList colorList = colorPaletteHandle.getListValue();
        StructureHandleTest.assertTrue((boolean)redHandle.getName().equals(((CustomColor)colorList.get(0)).getName()));
        StructureHandleTest.assertTrue((boolean)greenHandle.getName().equals(((CustomColor)colorList.get(1)).getName()));
        StructureHandleTest.assertTrue((boolean)blueHandle.getName().equals(((CustomColor)colorList.get(2)).getName()));
        redHandle.setDisplayName("Red");
        greenHandle.setDisplayName("Green");
        blueHandle.setDisplayName("Blue");
        colorPaletteHandle.moveItem(0, 3);
        colorList = colorPaletteHandle.getListValue();
        StructureHandleTest.assertEquals((int)3, (int)colorList.size());
        StructureHandleTest.assertTrue((boolean)greenHandle.getName().equals(((CustomColor)colorList.get(0)).getName()));
        StructureHandleTest.assertTrue((boolean)blueHandle.getName().equals(((CustomColor)colorList.get(1)).getName()));
        StructureHandleTest.assertTrue((boolean)redHandle.getName().equals(((CustomColor)colorList.get(2)).getName()));
        redHandle = (CustomColorHandle)red.getHandle((SimpleValueHandle)colorPaletteHandle);
        greenHandle = (CustomColorHandle)green.getHandle((SimpleValueHandle)colorPaletteHandle);
        blueHandle = (CustomColorHandle)blue.getHandle((SimpleValueHandle)colorPaletteHandle);
        StructureHandleTest.assertTrue((boolean)greenHandle.getName().equals(((CustomColor)colorList.get(0)).getName()));
        StructureHandleTest.assertTrue((boolean)blueHandle.getName().equals(((CustomColor)colorList.get(1)).getName()));
        StructureHandleTest.assertTrue((boolean)redHandle.getName().equals(((CustomColor)colorList.get(2)).getName()));
        CustomColor black = StructureFactory.createCustomColor();
        black.setName("myblack");
        black.setColor("000000");
        colorPaletteHandle.replaceItem((IStructure)blue, (IStructure)black);
        CustomColorHandle blackHandle = (CustomColorHandle)black.getHandle((SimpleValueHandle)colorPaletteHandle);
        colorList = colorPaletteHandle.getListValue();
        StructureHandleTest.assertEquals((int)3, (int)colorList.size());
        StructureHandleTest.assertTrue((boolean)greenHandle.getName().equals(((CustomColor)colorList.get(0)).getName()));
        StructureHandleTest.assertTrue((boolean)blackHandle.getName().equals(((CustomColor)colorList.get(1)).getName()));
        StructureHandleTest.assertTrue((boolean)redHandle.getName().equals(((CustomColor)colorList.get(2)).getName()));
        colorPaletteHandle.removeItem(0);
        colorList = colorPaletteHandle.getListValue();
        redHandle = (CustomColorHandle)red.getHandle((SimpleValueHandle)colorPaletteHandle);
        blackHandle = (CustomColorHandle)black.getHandle((SimpleValueHandle)colorPaletteHandle);
        StructureHandleTest.assertTrue((boolean)blackHandle.getName().equals(((CustomColor)colorList.get(0)).getName()));
        StructureHandleTest.assertTrue((boolean)redHandle.getName().equals(((CustomColor)colorList.get(1)).getName()));
    }

    public void testSortAndFilterHandle() throws SemanticException {
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        TableHandle tableHandle = factory.newTableItem("table 1");
        PropertyHandle propHandle = tableHandle.getPropertyHandle("sort");
        SortKey sortKey = StructureFactory.createSortKey();
        sortKey.setKey("expression");
        propHandle.addItem((IStructure)sortKey);
        Iterator iter = propHandle.iterator();
        SortKeyHandle sortHandle = (SortKeyHandle)iter.next();
        sortHandle.setKey("new column");
        sortHandle.setDirection("desc");
        sortHandle.setStrength(10);
        sortHandle.setLocale(ULocale.GERMAN);
        StructureHandleTest.assertEquals((String)"new column", (String)sortHandle.getKey());
        StructureHandleTest.assertEquals((String)"desc", (String)sortHandle.getDirection());
        StructureHandleTest.assertEquals((int)10, (int)sortHandle.getStrength());
        StructureHandleTest.assertEquals((Object)ULocale.GERMAN, (Object)sortHandle.getLocale());
        propHandle = tableHandle.getPropertyHandle("filter");
        FilterCondition filter = StructureFactory.createFilterCond();
        filter.setExpr("expression");
        filter.setOperator("between");
        propHandle.addItem((IStructure)filter);
        iter = propHandle.iterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)iter.next();
        filterHandle.setExpr("new expression");
        filterHandle.setOperator("is-false");
        filterHandle.setValue1("new value 1");
        filterHandle.setValue2("new value 2");
        filterHandle.setOptional(true);
        StructureHandleTest.assertEquals((String)"new expression", (String)filterHandle.getExpr());
        StructureHandleTest.assertEquals((String)"is-false", (String)filterHandle.getOperator());
        StructureHandleTest.assertEquals((String)"new value 1", (String)filterHandle.getValue1());
        StructureHandleTest.assertEquals((String)"new value 2", (String)filterHandle.getValue2());
        StructureHandleTest.assertTrue((boolean)filterHandle.isOptional());
        filterHandle.setOperator("between");
        StructureHandleTest.assertEquals((String)"new value 1", (String)filterHandle.getValue1());
        StructureHandleTest.assertEquals((String)"new value 2", (String)filterHandle.getValue2());
        filterHandle.setOperator("eq");
        StructureHandleTest.assertEquals((String)"new value 1", (String)filterHandle.getValue1());
        StructureHandleTest.assertNull((Object)filterHandle.getValue2());
        filterHandle.setOperator("is-false");
        StructureHandleTest.assertNull((Object)filterHandle.getValue1());
        StructureHandleTest.assertNull((Object)filterHandle.getValue2());
    }

    public void testSelectionChoiceHandle() throws SemanticException {
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        ScalarParameterHandle paramHandle = factory.newScalarParameter("param 1");
        PropertyHandle propHandle = paramHandle.getPropertyHandle("selectionList");
        SelectionChoice structure = StructureFactory.createSelectionChoice();
        propHandle.addItem((IStructure)structure);
        Iterator iter = propHandle.iterator();
        SelectionChoiceHandle structureHandle = (SelectionChoiceHandle)iter.next();
        structureHandle.setLabel("new label");
        structureHandle.setLabelKey("new label key");
        structureHandle.setValue("new value");
        StructureHandleTest.assertEquals((String)"new label", (String)structureHandle.getLabel());
        StructureHandleTest.assertEquals((String)"new label key", (String)structureHandle.getLabelKey());
        StructureHandleTest.assertEquals((String)"new value", (String)structureHandle.getValue());
    }

    public void testPropertyMaskHandle() throws SemanticException {
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        ScriptDataSetHandle dataSetHandle = factory.newScriptDataSet("data set 1");
        PropertyHandle propHandle = dataSetHandle.getPropertyHandle("propertyMasks");
        PropertyMask structure = StructureFactory.createPropertyMask();
        structure.setName("comments");
        propHandle.addItem((IStructure)structure);
        Iterator iter = propHandle.iterator();
        PropertyMaskHandle structureHandle = (PropertyMaskHandle)iter.next();
        structureHandle.setMask("lock");
        structureHandle.setName("comments");
        StructureHandleTest.assertEquals((String)"lock", (String)structureHandle.getMask());
        StructureHandleTest.assertEquals((String)"comments", (String)structureHandle.getName());
    }

    public void testStructureHandleOnReportDesign() throws SemanticException, UnsupportedEncodingException {
        this.createDesign();
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("libraries");
        IncludedLibrary structure = StructureFactory.createIncludeLibrary();
        structure.setFileName("a.xml");
        structure.setNamespace("a");
        propHandle.addItem((IStructure)structure);
        Iterator iter = propHandle.iterator();
        propHandle = this.designHandle.getPropertyHandle("includeScripts");
        IncludeScript structure1 = StructureFactory.createIncludeScript();
        structure1.setFileName("script.js");
        propHandle.addItem((IStructure)structure1);
        iter = propHandle.iterator();
        IncludeScriptHandle structureHandle1 = (IncludeScriptHandle)iter.next();
        structureHandle1.setFileName("new script name");
        StructureHandleTest.assertEquals((String)"new script name", (String)structureHandle1.getFileName());
        propHandle = this.designHandle.getPropertyHandle("images");
        EmbeddedImage structure2 = StructureFactory.createEmbeddedImage();
        structure2.setName("myImage");
        structure2.setData("data".getBytes("8859_1"));
        try {
            structure2.setData(null);
        }
        catch (Throwable e) {
            StructureHandleTest.fail();
        }
        propHandle.addItem((IStructure)structure2);
        iter = propHandle.iterator();
        EmbeddedImageHandle structureHandle2 = (EmbeddedImageHandle)iter.next();
        structureHandle2.setName("new embedded image name");
        structureHandle2.setType("image/bmp");
        byte[] data = new byte[]{1, 2, 3, 4};
        structureHandle2.setData(data);
        StructureHandleTest.assertEquals((String)"new embedded image name", (String)structureHandle2.getName());
        StructureHandleTest.assertEquals((String)"image/bmp", (String)structureHandle2.getType());
        byte[] retData = structureHandle2.getData();
        StructureHandleTest.assertEquals((int)4, (int)retData.length);
        StructureHandleTest.assertEquals((int)1, (int)retData[0]);
        StructureHandleTest.assertEquals((int)2, (int)retData[1]);
        StructureHandleTest.assertEquals((int)3, (int)retData[2]);
        StructureHandleTest.assertEquals((int)4, (int)retData[3]);
        propHandle = this.designHandle.getPropertyHandle("configVars");
        ConfigVariable structure3 = StructureFactory.createConfigVar();
        structure3.setName("myvar");
        propHandle.addItem((IStructure)structure3);
        iter = propHandle.iterator();
        ConfigVariableHandle structureHandle3 = (ConfigVariableHandle)iter.next();
        structureHandle3.setName("new name");
        structureHandle3.setValue("new value");
        StructureHandleTest.assertEquals((String)"new name", (String)structureHandle3.getName());
        StructureHandleTest.assertEquals((String)"new value", (String)structureHandle3.getValue());
    }

    public void testHideHandle() throws SemanticException {
        this.createDesign();
        ElementFactory factory = new ElementFactory((Module)this.design);
        LabelHandle handle = factory.newLabel("label 1");
        PropertyHandle propHandle = handle.getPropertyHandle("visibility");
        HideRule structure = StructureFactory.createHideRule();
        propHandle.addItem((IStructure)structure);
        Iterator iter = propHandle.iterator();
        HideRuleHandle structureHandle = (HideRuleHandle)iter.next();
        structureHandle.setExpression("new expression");
        structureHandle.setFormat("pdf");
        StructureHandleTest.assertEquals((String)"pdf", (String)structureHandle.getFormat());
        StructureHandleTest.assertEquals((String)"new expression", (String)structureHandle.getExpression());
        structureHandle.setFormat("user_defined_format");
        StructureHandleTest.assertEquals((String)"user_defined_format", (String)structureHandle.getFormat());
    }

    public void testDrop() throws Exception {
        this.createDesign();
        PropertyHandle propHandle = this.designHandle.getPropertyHandle("libraries");
        IncludedLibrary structure1 = StructureFactory.createIncludeLibrary();
        structure1.setFileName("a.xml");
        structure1.setNamespace("a");
        StructureHandle sHandle1 = propHandle.addItem((IStructure)structure1);
        IncludedLibrary structure2 = StructureFactory.createIncludeLibrary();
        structure2.setFileName("b.xml");
        structure2.setNamespace("b");
        StructureHandle sHandle2 = propHandle.addItem((IStructure)structure2);
        IncludedLibrary structure3 = StructureFactory.createIncludeLibrary();
        structure3.setFileName("c.xml");
        structure3.setNamespace("c");
        StructureHandle sHandle3 = propHandle.addItem((IStructure)structure3);
        sHandle2.drop();
        ArrayList value = propHandle.getListValue();
        StructureHandleTest.assertEquals((int)2, (int)value.size());
        StructureHandleTest.assertEquals((Object)sHandle1.getStructure(), value.get(0));
        StructureHandleTest.assertNull((Object)sHandle2.getStructure());
        StructureHandleTest.assertEquals((Object)sHandle3.getStructure(), value.get(1));
        this.designHandle.close();
        this.openDesign("ActionHandleTest.xml");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image3");
        ActionHandle actionHandle = imageHandle.getActionHandle();
        MemberHandle memberHandle = actionHandle.getParamBindings();
        StructureHandleTest.assertEquals((int)2, (int)memberHandle.getListValue().size());
        sHandle1 = memberHandle.getAt(0);
        sHandle2 = memberHandle.getAt(1);
        sHandle1.drop();
        value = memberHandle.getListValue();
        StructureHandleTest.assertEquals((int)1, (int)value.size());
        StructureHandleTest.assertEquals((Object)sHandle2.getStructure(), value.get(0));
        this.createDesign();
        TabularCubeHandle cube = this.designHandle.getElementFactory().newTabularCube("cube1");
        this.designHandle.getCubes().add((DesignElementHandle)cube);
        DimensionConditionHandle condition = cube.addDimensionCondition(StructureFactory.createCubeJoinCondition());
        DimensionJoinCondition tmpJoin = StructureFactory.createDimensionJoinCondition();
        tmpJoin.setCubeKey("cube1 key");
        tmpJoin.setHierarchyKey("hierarchy 1 key");
        DimensionJoinConditionHandle joinCondition1 = condition.addJoinCondition(tmpJoin);
        condition = cube.addDimensionCondition(StructureFactory.createCubeJoinCondition());
        tmpJoin = StructureFactory.createDimensionJoinCondition();
        tmpJoin.setCubeKey("cube1 key");
        tmpJoin.setHierarchyKey("hierarchy 2 key");
        DimensionJoinConditionHandle joinCondition2 = condition.addJoinCondition(tmpJoin);
        joinCondition2.drop();
        condition.drop();
        condition = (DimensionConditionHandle)cube.joinConditionsIterator().next();
        joinCondition1.drop();
        condition.drop();
    }

    public void testGetExternalizedText() throws Exception {
        this.openDesign("StructureHandleTest.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.getBody().get(0);
        PropertyHandle propHandle = tableHandle.getPropertyHandle("mapRules");
        ModuleOption option = new ModuleOption();
        option.setLocale(new ULocale("en"));
        this.design.setOptions(option);
        MapRuleHandle structHandle = (MapRuleHandle)propHandle.get(0);
        String value = structHandle.getExternalizedValue("displayID", "display");
        StructureHandleTest.assertEquals((String)"en", (String)value);
        option.setLocale(new ULocale("en_US"));
        structHandle = (MapRuleHandle)propHandle.get(0);
        value = structHandle.getExternalizedValue("displayID", "display");
        StructureHandleTest.assertEquals((String)"en_US", (String)value);
    }

    public void testUpdateCachedStructureInMemberRef() throws Exception {
        this.openDesign("StructureHandleTest_1.xml");
        TableHandle tableHandle = (TableHandle)this.designHandle.findElement("table1");
        Iterator filters = tableHandle.filtersIterator();
        FilterConditionHandle filter = (FilterConditionHandle)filters.next();
        filter.setExpr("new design expr");
        PropertyHandle propHandle = tableHandle.getPropertyHandle("filter");
        StructureHandleTest.assertTrue((boolean)propHandle.isLocal());
        StructureHandleTest.assertEquals((String)"new design expr", (String)filter.getExpr());
    }

    public void testContextWhenCopingElements() throws Exception {
        this.createDesign();
        TableHandle tableHandle = this.designHandle.getElementFactory().newTableItem(null);
        HideRule rule = StructureFactory.createHideRule();
        rule.setExpression("value1");
        rule.setFormat("all");
        tableHandle.getPropertyHandle("visibility").addItem((IStructure)rule);
        TableHandle newTable = (TableHandle)tableHandle.copy().getHandle((Module)this.design);
        newTable.getPropertyHandle("visibility").removeItem(0);
    }

    public void testEmbeddedImageExtendsFromLib() throws Exception {
        this.openDesign("EmbeddedImageWithExtendsTest.xml", ULocale.ENGLISH);
        PropertyHandle images = this.designHandle.getPropertyHandle("images");
        EmbeddedImageHandle image = (EmbeddedImageHandle)images.getAt(0);
        StructureHandleTest.assertTrue((boolean)image.isLibReference());
        EmbeddedImageHandle image1 = (EmbeddedImageHandle)images.getAt(1);
        StructureHandleTest.assertFalse((boolean)image1.isLibReference());
        image = (EmbeddedImageHandle)images.getAt(2);
        StructureHandleTest.assertFalse((boolean)image.isLibReference());
    }
}

