/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.script.element;

import com.ibm.icu.util.ULocale;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.api.script.ScriptException;
import org.eclipse.birt.report.engine.api.script.element.IDataBinding;
import org.eclipse.birt.report.engine.api.script.element.IFilterCondition;
import org.eclipse.birt.report.engine.api.script.element.IHideRule;
import org.eclipse.birt.report.engine.api.script.element.IHighlightRule;
import org.eclipse.birt.report.engine.api.script.element.IReportElement;
import org.eclipse.birt.report.engine.api.script.element.IReportItem;
import org.eclipse.birt.report.engine.api.script.element.ISortCondition;
import org.eclipse.birt.report.engine.api.script.element.StructureScriptAPIFactory;
import org.eclipse.birt.report.engine.script.internal.element.ActionImpl;
import org.eclipse.birt.report.engine.script.internal.element.Cell;
import org.eclipse.birt.report.engine.script.internal.element.DataItem;
import org.eclipse.birt.report.engine.script.internal.element.DataSet;
import org.eclipse.birt.report.engine.script.internal.element.DataSource;
import org.eclipse.birt.report.engine.script.internal.element.DynamicText;
import org.eclipse.birt.report.engine.script.internal.element.Grid;
import org.eclipse.birt.report.engine.script.internal.element.Group;
import org.eclipse.birt.report.engine.script.internal.element.HideRuleImpl;
import org.eclipse.birt.report.engine.script.internal.element.HighlightRuleImpl;
import org.eclipse.birt.report.engine.script.internal.element.Image;
import org.eclipse.birt.report.engine.script.internal.element.Label;
import org.eclipse.birt.report.engine.script.internal.element.List;
import org.eclipse.birt.report.engine.script.internal.element.Listing;
import org.eclipse.birt.report.engine.script.internal.element.ReportItem;
import org.eclipse.birt.report.engine.script.internal.element.Row;
import org.eclipse.birt.report.engine.script.internal.element.StyleDesign;
import org.eclipse.birt.report.engine.script.internal.element.Table;
import org.eclipse.birt.report.engine.script.internal.element.TextItem;
import org.eclipse.birt.report.model.api.ActionHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.HideRuleHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TextDataHandle;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.elements.structures.HideRule;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.SortKey;

public class ElementTest
extends TestCase {
    private static final String TARGET_WINDOW = "targetWindow";
    private static final String REPORT_NAME = "reportName";
    private static final int Y1 = 40;
    private static final int X1 = 30;
    private static final int WIDTH1 = 20;
    private static final String IN = "in";
    private static final int HEIGHT1 = 10;
    private static final String GRID = "Grid";
    private static final String CONTENT_KEY = "contentKey";
    private static final String TEXT_CONTENT = "textContent";
    private static final String TEXT_ITEM = "TextItem";
    private static final String CAPTION_KEY = "captionKey";
    private static final String CAPTION = "caption";
    private static final String TABLE = "Table";
    private static final String WORD_SPACING = "21px";
    private static final String WINDOWS = "6";
    private static final String TEXT_INDENT = "20px";
    private static final String STRINGFORMAT = "stringformat";
    private static final String PADDING_TOP = "19pt";
    private static final String PADDING_RIGHT = "18pt";
    private static final String PADDING_LEFT = "17pt";
    private static final String PADDING_BOTTOM = "16pt";
    private static final String ORPHANS = "5";
    private static final String MASTER_PAGE = "masterPage";
    private static final String MARGIN_TOP = "15pt";
    private static final String MARGIN_RIGHT = "14pt";
    private static final String MARGIN_LEFT = "13pt";
    private static final String MARGIN_BOTTOM = "12pt";
    private static final String LINE_HEIGHT = "11pt";
    private static final String LETTER_SPACING = "10pt";
    private static final String FONT_SIZE = "20pt";
    private static final String YY_MM_DD = "YY-MM-DD";
    private static final String WHITE = "white";
    private static final String BORDER_TOP_WIDTH = "15px";
    private static final String GRAY = "gray";
    private static final String BORDER_RIGHT_WIDTH = "14px";
    private static final String YELLOW = "yellow";
    private static final String BORDER_LEFT_WIDTH = "13px";
    private static final String GREEN = "green";
    private static final String BORDER_BOTTOM_WIDTH = "12px";
    private static final String BLUE = "blue";
    private static final String BACKGROUND_POSITION_Y = "11px";
    private static final String BACKGROUND_POSITION_X = "10px";
    private static final String IMAGE_URL = "imageUrl";
    private static final String RED = "red";
    private static final String STYLE = "Style";
    private static final String LIST = "List";
    private static final String VALUE_EXPRESSION = "valueExpression";
    private static final String URI = "URI";
    private static final String IMAGE_NAME = "imageName";
    private static final String IMAGE = "Image";
    private static final double INTERVAL_RANGE = 11.5;
    private static final String INTERVAL_BASE = "2000";
    private static final String YEAR = "year";
    private static final String TEST = "test";
    private static final String TEXT_DATA = "TextData";
    private static final String DATA_SOURCE = "DataSource";
    private static final String QUERY = "query";
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String TEXT_KEY = "textKey";
    private static final String TEXT = "text";
    private static final String HELP_TEXT_KEY = "helpTextKey";
    private static final String HELP_TEXT = "helpText";
    private static final String LABEL = "Label";
    private static final String Y2 = "40cm";
    private static final String X2 = "30cm";
    private static final String TOC = "TOC";
    private static final String WIDTH2 = "20cm";
    private static final String HEIGHT2 = "10cm";
    private static final String BOOKMARK = "bookmark";
    private static final String USER_PROP = "userProp";
    private static final String USER_PROP2 = "userProp2";
    private static final String INTEGER = "integer";
    private static final String USER_PROP1 = "userProp1";
    private static final String EXPRESSION = "expression";
    private static final String NAMED_EXPRESSION = "namedExpression";
    private static final String NAME = "name";
    private static final String DISPLAY_NAME_KEY = "displayNameKey";
    private static final String DISPLAY_NAME = "displayName";
    private static final String XML = "<xml/>";
    private static final String COMMENTS = "comments";
    private static final String IMAGE_FILE = "imageFile";
    private ElementFactory factory;
    private ReportDesignHandle designHandle;

    public void setUp() {
        SessionHandle sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = sessionHandle.createDesign();
        this.factory = new ElementFactory(this.designHandle.getModule());
    }

    private void doTestAction(LabelHandle handle) throws SemanticException, ScriptException {
        ActionHandle actionHandle = handle.setAction(new Action());
        ActionImpl action = new ActionImpl(actionHandle, handle);
        action.setFormatType("html");
        ElementTest.assertEquals((String)"html", (String)action.getFormatType());
        action.setLinkType("drill-through");
        ElementTest.assertEquals((String)"drill-through", (String)action.getLinkType());
        action.setReportName(REPORT_NAME);
        ElementTest.assertEquals((String)REPORT_NAME, (String)action.getReportName());
        action.setTargetBookmark(BOOKMARK);
        ElementTest.assertEquals((String)BOOKMARK, (String)action.getTargetBookmark());
        action.setTargetWindow(TARGET_WINDOW);
        ElementTest.assertEquals((String)TARGET_WINDOW, (String)action.getTargetWindow());
        action.setLinkType("hyperlink");
        action.setURI(URI);
        ElementTest.assertEquals((String)URI, (String)action.getURI());
    }

    private void doTestReportElement(IReportElement element) throws ScriptException {
        element.setComments(COMMENTS);
        ElementTest.assertEquals((String)COMMENTS, (String)element.getComments());
        element.setCustomXml(XML);
        ElementTest.assertEquals((String)XML, (String)element.getCustomXml());
        element.setDisplayName(DISPLAY_NAME);
        ElementTest.assertEquals((String)DISPLAY_NAME, (String)element.getDisplayName());
        element.setDisplayNameKey(DISPLAY_NAME_KEY);
        ElementTest.assertEquals((String)DISPLAY_NAME_KEY, (String)element.getDisplayNameKey());
        element.setName(NAME);
        ElementTest.assertEquals((String)NAME, (String)element.getName());
        element.setNamedExpression(NAMED_EXPRESSION, EXPRESSION);
        ElementTest.assertEquals((String)EXPRESSION, (String)element.getNamedExpression(NAMED_EXPRESSION));
        element.setUserProperty(USER_PROP1, (Object)new Integer(1), INTEGER);
        ElementTest.assertEquals((Object)new Integer(1), (Object)element.getUserProperty(USER_PROP1));
        element.setUserProperty(USER_PROP2, USER_PROP);
        ElementTest.assertEquals((Object)USER_PROP, (Object)element.getUserProperty(USER_PROP2));
    }

    private void doTestReportItem(IReportItem item) throws ScriptException {
        item.setBookmark(BOOKMARK);
        ElementTest.assertEquals((String)BOOKMARK, (String)item.getBookmark());
        item.setHeight(10.0);
        ElementTest.assertEquals((String)"10in", (String)item.getHeight());
        item.setHeight(HEIGHT2);
        ElementTest.assertEquals((String)HEIGHT2, (String)item.getHeight());
        item.setWidth(20.0);
        ElementTest.assertEquals((String)"20in", (String)item.getWidth());
        item.setWidth(WIDTH2);
        ElementTest.assertEquals((String)WIDTH2, (String)item.getWidth());
        item.setTocExpression(TOC);
        ElementTest.assertEquals((String)TOC, (String)item.getTocExpression());
        item.setX(30.0);
        ElementTest.assertEquals((String)"30in", (String)item.getX());
        item.setX(X2);
        ElementTest.assertEquals((String)X2, (String)item.getX());
        item.setY(40.0);
        ElementTest.assertEquals((String)"40in", (String)item.getY());
        item.setY(Y2);
        ElementTest.assertEquals((String)Y2, (String)item.getY());
    }

    public void testLabel() throws ScriptException, SemanticException {
        LabelHandle labelHandle = this.factory.newLabel(LABEL);
        Label label = new Label(labelHandle);
        this.doTestReportElement((IReportElement)label);
        this.doTestReportItem((IReportItem)label);
        this.doTestAction(labelHandle);
        label.setHelpText(HELP_TEXT);
        ElementTest.assertEquals((String)HELP_TEXT, (String)label.getHelpText());
        label.setHelpTextKey(HELP_TEXT_KEY);
        ElementTest.assertEquals((String)HELP_TEXT_KEY, (String)label.getHelpTextKey());
        label.setText(TEXT);
        ElementTest.assertEquals((String)TEXT, (String)label.getText());
        label.setTextKey(TEXT_KEY);
        ElementTest.assertEquals((String)TEXT_KEY, (String)label.getTextKey());
    }

    public void testCell() throws ScriptException {
        CellHandle cellHandle = this.factory.newCell();
        Cell cell = new Cell(cellHandle);
        cell.setColumn(2);
        ElementTest.assertEquals((int)2, (int)cell.getColumn());
        ElementTest.assertEquals((int)1, (int)cell.getColumnSpan());
        cell.setDrop("all");
        ElementTest.assertEquals((String)"all", (String)cell.getDrop());
        ElementTest.assertEquals((int)1, (int)cell.getRowSpan());
    }

    public void testDataItem() throws ScriptException {
        DataItemHandle dataHandle = this.factory.newDataItem("DataItem");
        DataItem data = new DataItem(dataHandle);
        data.setHelpText(HELP_TEXT);
        ElementTest.assertEquals((String)HELP_TEXT, (String)data.getHelpText());
        data.setHelpTextKey(HELP_TEXT_KEY);
        ElementTest.assertEquals((String)HELP_TEXT_KEY, (String)data.getHelpTextKey());
    }

    public void testDataBinding() throws ScriptException, SemanticException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        ComputedColumn column = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)"column1");
        column.setExpression("row[\"123\"]");
        tableHandle.addColumnBinding(column, true);
        ComputedColumn column2 = StructureFactory.newComputedColumn((DesignElementHandle)tableHandle, (String)"column2");
        column2.setExpression("row[\"234\"]");
        tableHandle.addColumnBinding(column2, true);
        ReportItem item = new ReportItem((ReportItemHandle)tableHandle);
        IDataBinding[] bindings = item.getDataBindings();
        ElementTest.assertEquals((int)2, (int)bindings.length);
        IDataBinding binding = bindings[0];
        IDataBinding binding2 = bindings[1];
        ElementTest.assertEquals((String)"column1", (String)binding.getName());
        ElementTest.assertEquals((String)"column2", (String)binding2.getName());
        binding.setAggregateOn("11");
        ElementTest.assertEquals((String)"11", (String)binding.getAggregateOn());
        binding.setDataType("string");
        ElementTest.assertEquals((String)"string", (String)binding.getDataType());
        binding.setExpression("row[\"123\"]");
        ElementTest.assertEquals((String)"row[\"123\"]", (String)binding.getExpression());
        ElementTest.assertEquals((String)"column1", (String)binding.getName());
        ElementTest.assertEquals((String)"row[\"234\"]", (String)item.getDataBinding("column2"));
    }

    public void testAddFunction() throws SemanticException, ScriptException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        IDataBinding binding = StructureScriptAPIFactory.createDataBinding();
        binding.setExpression(EXPRESSION);
        binding.setName(NAME);
        Listing item = new Listing((ListingHandle)tableHandle);
        item.addDataBinding(binding);
        IDataBinding binding2 = StructureScriptAPIFactory.createDataBinding();
        try {
            item.addDataBinding(binding2);
            ElementTest.fail();
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        RowHandle rowHandle = (RowHandle)tableHandle.getFooter().getContents().get(0);
        Row row = new Row(rowHandle);
        IHighlightRule highlight = StructureScriptAPIFactory.createHighLightRule();
        row.addHighlightRule(highlight);
        IHideRule hideRule = StructureScriptAPIFactory.createHideRule();
        item.addHideRule(hideRule);
        IFilterCondition filter = StructureScriptAPIFactory.createFilterCondition();
        try {
            item.addFilterCondition(filter);
            ElementTest.fail();
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        filter.setExpr("expr");
        item.addFilterCondition(filter);
        ISortCondition sort = StructureScriptAPIFactory.createSortCondition();
        try {
            item.addSortCondition(sort);
            ElementTest.fail();
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        sort.setKey(KEY);
        item.addSortCondition(sort);
    }

    public void testHighLightRule() throws SemanticException, ScriptException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        HighlightRule rule = StructureFactory.createHighlightRule();
        SharedStyleHandle style = this.factory.newStyle(STYLE);
        style.getPropertyHandle("highlightRules").addItem((IStructure)rule);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        tableHandle.setStyle(style);
        RowHandle rowHandle = (RowHandle)tableHandle.getHeader().get(0);
        Row item = new Row(rowHandle);
        HighlightRuleImpl iRule = new HighlightRuleImpl(rule);
        item.addHighlightRule((IHighlightRule)iRule);
        IHighlightRule[] rules = item.getHighlightRules();
        ElementTest.assertEquals((int)1, (int)rules.length);
        iRule = rules[0];
        iRule.setColor(RED);
        ElementTest.assertEquals((String)RED, (String)iRule.getColor());
        iRule.setDateTimeFormat("mm dd, yyyy");
        ElementTest.assertEquals((String)"mm dd, yyyy", (String)iRule.getDateTimeFormat());
        iRule.setFontStyle("oblique");
        ElementTest.assertEquals((String)"oblique", (String)iRule.getFontStyle());
        iRule.setFontWeight("900");
        ElementTest.assertEquals((String)"900", (String)iRule.getFontWeight());
        iRule.setStringFormat("no format");
        ElementTest.assertEquals((String)"no format", (String)iRule.getStringFormat());
        iRule.setTestExpression(EXPRESSION);
        ElementTest.assertEquals((String)EXPRESSION, (String)iRule.getTestExpression());
        iRule.setColor("#FFFFFF");
        ElementTest.assertEquals((String)"#FFFFFF", (String)iRule.getColor());
        iRule.setOperator("between");
        ElementTest.assertEquals((String)"between", (String)iRule.getOperator());
        iRule.setValue1("100");
        ElementTest.assertEquals((String)"100", (String)iRule.getValue1());
        iRule.setValue2("300");
        ElementTest.assertEquals((String)"300", (String)iRule.getValue2());
        iRule.setBackGroundColor("#FF0000");
        ElementTest.assertEquals((String)"#FF0000", (String)iRule.getBackGroundColor());
        item.removeHighlightRules();
        rules = item.getHighlightRules();
        ElementTest.assertEquals((int)0, (int)rules.length);
    }

    public void testFilterCondition() throws SemanticException, ScriptException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        FilterCondition cond = StructureFactory.createFilterCond();
        cond.setExpr("inner join");
        tableHandle.getPropertyHandle("filter").addItem((IStructure)cond);
        Listing item = new Listing((ListingHandle)tableHandle);
        IFilterCondition[] conds = item.getFilterConditions();
        ElementTest.assertEquals((int)1, (int)conds.length);
        IFilterCondition iFilter = conds[0];
        ElementTest.assertEquals((String)"eq", (String)iFilter.getOperator());
        iFilter.setOperator("between");
        ElementTest.assertEquals((String)"between", (String)iFilter.getOperator());
        iFilter.setValue1("1");
        ElementTest.assertEquals((String)"1", (String)iFilter.getValue1());
        iFilter.setValue2("100");
        ElementTest.assertEquals((String)"100", (String)iFilter.getValue2());
    }

    public void testSortCondition() throws SemanticException, ScriptException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        SortKey sort = StructureFactory.createSortKey();
        sort.setKey(KEY);
        tableHandle.getPropertyHandle("sort").addItem((IStructure)sort);
        Listing item = new Listing((ListingHandle)tableHandle);
        ISortCondition[] sorts = item.getSortConditions();
        ElementTest.assertEquals((int)1, (int)sorts.length);
        ISortCondition iSort = sorts[0];
        ElementTest.assertEquals((String)KEY, (String)iSort.getKey());
        iSort.setDirection("desc");
        ElementTest.assertEquals((String)"desc", (String)iSort.getDirection());
        iSort.setKey("1");
        ElementTest.assertEquals((String)"1", (String)iSort.getKey());
    }

    public void testHideRule() throws SemanticException, ScriptException {
        TableHandle tableHandle = this.factory.newTableItem("table", 3);
        this.designHandle.getBody().add((DesignElementHandle)tableHandle);
        HideRule hide = StructureFactory.createHideRule();
        hide.setFormat("format");
        HideRuleHandle hideHandle = (HideRuleHandle)tableHandle.getPropertyHandle("visibility").addItem((IStructure)hide);
        HideRule hide2 = StructureFactory.createHideRule();
        hide2.setExpression("expr2");
        hide2.setFormat("format");
        tableHandle.getPropertyHandle("visibility").addItem((IStructure)hide2);
        ReportItem item = new ReportItem((ReportItemHandle)tableHandle);
        IHideRule[] rules = item.getHideRules();
        ElementTest.assertEquals((int)2, (int)rules.length);
        HideRuleImpl iHide = new HideRuleImpl(hideHandle);
        ElementTest.assertEquals((String)"format", (String)iHide.getFormat());
        iHide.setValueExpr("valueExpr");
        ElementTest.assertEquals((String)"valueExpr", (String)iHide.getValueExpr());
        item.removeHideRule((IHideRule)iHide);
        rules = item.getHideRules();
        ElementTest.assertEquals((int)1, (int)rules.length);
    }

    public void testDataSet() throws ScriptException {
        OdaDataSetHandle dataSetHandle = this.factory.newOdaDataSet("DataSet", null);
        DataSet dataSet = new DataSet((DataSetHandle)dataSetHandle);
        dataSet.setPrivateDriverProperty(KEY, VALUE);
        ElementTest.assertEquals((String)VALUE, (String)dataSet.getPrivateDriverProperty(KEY));
        dataSet.setQueryText(QUERY);
        ElementTest.assertEquals((String)QUERY, (String)dataSet.getQueryText());
    }

    public void testDataSource() throws ScriptException {
        OdaDataSourceHandle dataSourceHandle = this.factory.newOdaDataSource(DATA_SOURCE, null);
        DataSource dataSource = new DataSource((DataSourceHandle)dataSourceHandle);
        dataSource.setPrivateDriverProperty(KEY, VALUE);
        ElementTest.assertEquals((String)VALUE, (String)dataSource.getPrivateDriverProperty(KEY));
    }

    public void testDynamicText() throws ScriptException {
        TextDataHandle textDataHandle = this.factory.newTextData(TEXT_DATA);
        DynamicText dynamicText = new DynamicText(textDataHandle);
        dynamicText.setContentType("html");
        ElementTest.assertEquals((String)"html", (String)dynamicText.getContentType());
        try {
            dynamicText.setContentType(TEST);
            ElementTest.fail((String)"\"test\" should not be a valid content type");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        dynamicText.setValueExpr(EXPRESSION);
        ElementTest.assertEquals((String)EXPRESSION, (String)dynamicText.getValueExpr());
    }

    public void testGrid() throws ScriptException {
        GridHandle gridHandle = this.factory.newGridItem(GRID);
        new Grid(gridHandle);
    }

    public void testGroup() throws ScriptException {
        TableGroupHandle groupHandle = this.factory.newTableGroup();
        Group group = new Group((GroupHandle)groupHandle);
        group.setInterval(YEAR);
        ElementTest.assertEquals((String)YEAR, (String)group.getInterval());
        group.setIntervalBase(INTERVAL_BASE);
        ElementTest.assertEquals((String)INTERVAL_BASE, (String)group.getIntervalBase());
        group.setIntervalRange(11.5);
        ElementTest.assertTrue((11.5 == group.getIntervalRange() ? 1 : 0) != 0);
        group.setKeyExpr(EXPRESSION);
        ElementTest.assertEquals((String)EXPRESSION, (String)group.getKeyExpr());
        group.setName(NAME);
        ElementTest.assertEquals((String)NAME, (String)group.getName());
        group.setSortDirection("desc");
        ElementTest.assertEquals((String)"desc", (String)group.getSortDirection());
        try {
            group.setSortDirection(TEST);
            ElementTest.fail((String)"\"test\" should not be a valid sort direction");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        group.setTocExpression(TOC);
        ElementTest.assertEquals((String)TOC, (String)group.getTocExpression());
        group.setHideDetail(true);
        ElementTest.assertTrue((boolean)group.getHideDetail());
    }

    public void testImage() throws ScriptException {
        ImageHandle imageHandle = this.factory.newImage(IMAGE);
        Image image = new Image(imageHandle);
        image.setHelpText(HELP_TEXT);
        ElementTest.assertEquals((String)HELP_TEXT, (String)image.getHelpText());
        image.setHelpTextKey(HELP_TEXT_KEY);
        ElementTest.assertEquals((String)HELP_TEXT_KEY, (String)image.getHelpTextKey());
        image.setImageName(IMAGE_NAME);
        ElementTest.assertEquals((String)IMAGE_NAME, (String)image.getImageName());
        image.setScale(50.5);
        ElementTest.assertTrue((50.5 == image.getScale() ? 1 : 0) != 0);
        image.setSize("scale-to-item");
        ElementTest.assertEquals((String)"scale-to-item", (String)image.getSize());
        try {
            image.setSize(TEST);
            ElementTest.fail((String)"\"test\" should not be a valid sizing method");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        image.setSource("url");
        ElementTest.assertEquals((String)"url", (String)image.getSource());
        try {
            image.setSource(TEST);
            ElementTest.fail((String)"\"test\" should not be a valid image source");
        }
        catch (ScriptException scriptException) {
            // empty catch block
        }
        image.setTypeExpression(EXPRESSION);
        ElementTest.assertEquals((String)EXPRESSION, (String)image.getTypeExpression());
        image.setValueExpression(VALUE_EXPRESSION);
        ElementTest.assertEquals((String)VALUE_EXPRESSION, (String)image.getValueExpression());
        image.setURL(IMAGE_URL);
        ElementTest.assertEquals((String)IMAGE_URL, (String)image.getURL());
        image.setFile(IMAGE_FILE);
        ElementTest.assertEquals((String)IMAGE_FILE, (String)image.getFile());
    }

    public void testList() throws ScriptException {
        ListHandle listHandle = this.factory.newList(LIST);
        new List(listHandle);
    }

    public void testRow() throws ScriptException {
        RowHandle rowHandle = this.factory.newTableRow();
        Row row = new Row(rowHandle);
        row.setBookmark(BOOKMARK);
        ElementTest.assertEquals((String)BOOKMARK, (String)row.getBookmark());
    }

    public void testStyle() throws ScriptException {
        SharedStyleHandle styleHandle = this.factory.newStyle(STYLE);
        StyleDesign style = new StyleDesign((StyleHandle)styleHandle);
        style.setBackgroundAttachment("scroll");
        ElementTest.assertEquals((String)"scroll", (String)style.getBackgroundAttachment());
        style.setBackgroundColor(RED);
        ElementTest.assertEquals((String)RED, (String)style.getBackgroundColor());
        style.setBackgroundImage(IMAGE_URL);
        ElementTest.assertEquals((String)IMAGE_URL, (String)style.getBackgroundImage());
        style.setBackGroundPositionX(BACKGROUND_POSITION_X);
        ElementTest.assertEquals((String)BACKGROUND_POSITION_X, (String)style.getBackGroundPositionX());
        style.setBackGroundPositionY(BACKGROUND_POSITION_Y);
        ElementTest.assertEquals((String)BACKGROUND_POSITION_Y, (String)style.getBackGroundPositionY());
        style.setBackgroundRepeat("repeat");
        ElementTest.assertEquals((String)"repeat", (String)style.getBackgroundRepeat());
        style.setBorderBottomColor(BLUE);
        ElementTest.assertEquals((String)BLUE, (String)style.getBorderBottomColor());
        style.setBorderBottomStyle("solid");
        ElementTest.assertEquals((String)"solid", (String)style.getBorderBottomStyle());
        style.setBorderBottomWidth(BORDER_BOTTOM_WIDTH);
        ElementTest.assertEquals((String)BORDER_BOTTOM_WIDTH, (String)style.getBorderBottomWidth());
        style.setBorderLeftColor(GREEN);
        ElementTest.assertEquals((String)GREEN, (String)style.getBorderLeftColor());
        style.setBorderLeftStyle("dotted");
        ElementTest.assertEquals((String)"dotted", (String)style.getBorderLeftStyle());
        style.setBorderLeftWidth(BORDER_LEFT_WIDTH);
        ElementTest.assertEquals((String)BORDER_LEFT_WIDTH, (String)style.getBorderLeftWidth());
        style.setBorderRightColor(YELLOW);
        ElementTest.assertEquals((String)YELLOW, (String)style.getBorderRightColor());
        style.setBorderRightStyle("dashed");
        ElementTest.assertEquals((String)"dashed", (String)style.getBorderRightStyle());
        style.setBorderRightWidth(BORDER_RIGHT_WIDTH);
        ElementTest.assertEquals((String)BORDER_RIGHT_WIDTH, (String)style.getBorderRightWidth());
        style.setBorderTopColor(GRAY);
        ElementTest.assertEquals((String)GRAY, (String)style.getBorderTopColor());
        style.setBorderTopStyle("double");
        ElementTest.assertEquals((String)"double", (String)style.getBorderTopStyle());
        style.setBorderTopWidth(BORDER_TOP_WIDTH);
        ElementTest.assertEquals((String)BORDER_TOP_WIDTH, (String)style.getBorderTopWidth());
        style.setCanShrink(true);
        ElementTest.assertTrue((boolean)style.canShrink());
        style.setColor(WHITE);
        ElementTest.assertEquals((String)WHITE, (String)style.getColor());
        style.setDateTimeFormat(YY_MM_DD);
        ElementTest.assertEquals((String)YY_MM_DD, (String)style.getDateTimeFormat());
        style.setDateTimeFormatCategory("Medium Date");
        ElementTest.assertEquals((String)"Medium Date", (String)style.getDateTimeFormatCategory());
        style.setDisplay("inline");
        ElementTest.assertEquals((String)"inline", (String)style.getDisplay());
        style.setFontFamily("sans-serif");
        ElementTest.assertEquals((String)"sans-serif", (String)style.getFontFamily());
        style.setFontSize(FONT_SIZE);
        ElementTest.assertEquals((String)FONT_SIZE, (String)style.getFontSize());
        style.setFontStyle("italic");
        ElementTest.assertEquals((String)"italic", (String)style.getFontStyle());
        style.setFontVariant("small-caps");
        ElementTest.assertEquals((String)"small-caps", (String)style.getFontVariant());
        style.setFontWeight("bold");
        ElementTest.assertEquals((String)"bold", (String)style.getFontWeight());
        style.setLetterSpacing(LETTER_SPACING);
        ElementTest.assertEquals((String)LETTER_SPACING, (String)style.getLetterSpacing());
        style.setLineHeight(LINE_HEIGHT);
        ElementTest.assertEquals((String)LINE_HEIGHT, (String)style.getLineHeight());
        style.setMarginBottom(MARGIN_BOTTOM);
        ElementTest.assertEquals((String)MARGIN_BOTTOM, (String)style.getMarginBottom());
        style.setMarginLeft(MARGIN_LEFT);
        ElementTest.assertEquals((String)MARGIN_LEFT, (String)style.getMarginLeft());
        style.setMarginRight(MARGIN_RIGHT);
        ElementTest.assertEquals((String)MARGIN_RIGHT, (String)style.getMarginRight());
        style.setMarginTop(MARGIN_TOP);
        ElementTest.assertEquals((String)MARGIN_TOP, (String)style.getMarginTop());
        style.setMasterPage(MASTER_PAGE);
        ElementTest.assertEquals((String)MASTER_PAGE, (String)style.getMasterPage());
        style.setNumberFormat("Currency");
        ElementTest.assertEquals((String)"Currency", (String)style.getNumberFormat());
        style.setNumberFormatCategory("Percent");
        ElementTest.assertEquals((String)"Percent", (String)style.getNumberFormatCategory());
        style.setOrphans(ORPHANS);
        ElementTest.assertEquals((String)ORPHANS, (String)style.getOrphans());
        style.setPaddingBottom(PADDING_BOTTOM);
        ElementTest.assertEquals((String)PADDING_BOTTOM, (String)style.getPaddingBottom());
        style.setPaddingLeft(PADDING_LEFT);
        ElementTest.assertEquals((String)PADDING_LEFT, (String)style.getPaddingLeft());
        style.setPaddingRight(PADDING_RIGHT);
        ElementTest.assertEquals((String)PADDING_RIGHT, (String)style.getPaddingRight());
        style.setPaddingTop(PADDING_TOP);
        ElementTest.assertEquals((String)PADDING_TOP, (String)style.getPaddingTop());
        style.setPageBreakAfter("always");
        ElementTest.assertEquals((String)"always", (String)style.getPageBreakAfter());
        style.setShowIfBlank(true);
        ElementTest.assertTrue((boolean)style.getShowIfBlank());
        style.setStringFormat(STRINGFORMAT);
        ElementTest.assertEquals((String)STRINGFORMAT, (String)style.getStringFormat());
        style.setStringFormatCategory("Phone Number");
        ElementTest.assertEquals((String)"Phone Number", (String)style.getStringFormatCategory());
        style.setTextAlign("right");
        ElementTest.assertEquals((String)"right", (String)style.getTextAlign());
        style.setTextIndent(TEXT_INDENT);
        ElementTest.assertEquals((String)TEXT_INDENT, (String)style.getTextIndent());
        style.setTextLineThrough("line-through");
        ElementTest.assertEquals((String)"line-through", (String)style.getTextLineThrough());
        style.setTextOverline("overline");
        ElementTest.assertEquals((String)"overline", (String)style.getTextOverline());
        style.setTextTransform("lowercase");
        ElementTest.assertEquals((String)"lowercase", (String)style.getTextTransform());
        style.setTextUnderline("underline");
        ElementTest.assertEquals((String)"underline", (String)style.getTextUnderline());
        style.setVerticalAlign("top");
        ElementTest.assertEquals((String)"top", (String)style.getVerticalAlign());
        style.setWhiteSpace("nowrap");
        ElementTest.assertEquals((String)"nowrap", (String)style.getWhiteSpace());
        style.setWidows(WINDOWS);
        ElementTest.assertEquals((String)WINDOWS, (String)style.getWidows());
        style.setWordSpacing(WORD_SPACING);
        ElementTest.assertEquals((String)WORD_SPACING, (String)style.getWordSpacing());
    }

    public void testTable() throws ScriptException {
        TableHandle tableHandle = this.factory.newTableItem(TABLE);
        Table table = new Table(tableHandle);
        table.setCaption(CAPTION);
        ElementTest.assertEquals((String)CAPTION, (String)table.getCaption());
        table.setCaptionKey(CAPTION_KEY);
        ElementTest.assertEquals((String)CAPTION_KEY, (String)table.getCaptionKey());
        table.setRepeatHeader(true);
        ElementTest.assertTrue((boolean)table.repeatHeader());
    }

    public void testTextItem() throws ScriptException {
        TextItemHandle textItemHandle = this.factory.newTextItem(TEXT_ITEM);
        TextItem text = new TextItem(textItemHandle);
        text.setContent(TEXT_CONTENT);
        ElementTest.assertEquals((String)TEXT_CONTENT, (String)text.getContent());
        text.setContentKey(CONTENT_KEY);
        ElementTest.assertEquals((String)CONTENT_KEY, (String)text.getContentKey());
        text.setContentType("html");
        ElementTest.assertEquals((String)"html", (String)text.getContentType());
    }
}

