/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.internal.rcp.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.editors.ReportEditorInput;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.internal.ui.views.ReportResourceChangeEvent;
import org.eclipse.birt.report.designer.internal.ui.wizards.WizardTemplateChoicePage;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.internal.rcp.wizards.WizardNewReportCreationPage;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.views.IReportResourceChangeEvent;
import org.eclipse.birt.report.designer.ui.views.IReportResourceSynchronizer;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.OpenCheatSheetAction;

public class NewReportWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    private static final String NEW = Messages.getString((String)"NewReportWizard.title.New");
    private static final String REPORT = Messages.getString((String)"NewReportWizard.title.Report");
    private static final String WIZARDPAGE = Messages.getString((String)"NewReportWizard.title.WizardPage");
    private static final String TEMPLATECHOICEPAGE = Messages.getString((String)"NewReportWizard.title.Template");
    private static final String CREATE_A_NEW_REPORT = Messages.getString((String)"NewReportWizard.text.CreateReport");
    private static final String SELECT_A_REPORT_TEMPLATE = Messages.getString((String)"NewReportWizard.text.SelectTemplate");
    private static final String CREATING = Messages.getString((String)"NewReportWizard.text.Creating");
    private static final String OPENING_FILE_FOR_EDITING = Messages.getString((String)"NewReportWizard.text.OpenFileForEditing");
    private static final String NEW_REPORT_FILE_NAME_PREFIX = Messages.getString((String)"NewReportWizard.displayName.NewReportFileNamePrefix");
    private String fileExtension = ".rptdesign";
    private WizardNewReportCreationPage newReportFileWizardPage;
    private WizardTemplateChoicePage templateChoicePage;

    public NewReportWizard() {
        this.setWindowTitle(NEW);
    }

    public Image getDefaultPageImage() {
        return ReportPlugin.getImage((String)"/icons/wizban/create_report_wizard.gif");
    }

    public void addPages() {
        this.newReportFileWizardPage = new WizardNewReportCreationPage(WIZARDPAGE);
        this.addPage((IWizardPage)this.newReportFileWizardPage);
        this.templateChoicePage = new WizardTemplateChoicePage(TEMPLATECHOICEPAGE);
        this.addPage((IWizardPage)this.templateChoicePage);
        this.newReportFileWizardPage.setTitle(REPORT);
        this.newReportFileWizardPage.setDescription(CREATE_A_NEW_REPORT);
        this.templateChoicePage.setTitle(REPORT);
        this.templateChoicePage.setDescription(SELECT_A_REPORT_TEMPLATE);
        this.newReportFileWizardPage.setInitialFileName(this.getNewFileFullName(NEW_REPORT_FILE_NAME_PREFIX));
        this.newReportFileWizardPage.setInitialFileLocation(this.getDefaultLocation());
    }

    private String getDefaultLocation() {
        IPath defaultPath = Platform.getLocation();
        return defaultPath.toOSString();
    }

    private String getNewFileFullName(String defaultName) {
        String path = this.getDefaultLocation();
        String name = defaultName + this.fileExtension;
        int count = 0;
        File file = new File(path, name);
        while (file.exists()) {
            name = defaultName + "_" + ++count + this.fileExtension;
            file = null;
            file = new File(path, name);
        }
        file = null;
        return name;
    }

    public boolean performFinish() {
        final IPath locPath = this.newReportFileWizardPage.getFileLocationFullPath();
        String fn = this.newReportFileWizardPage.getFileName();
        Object fileName = !Platform.getOS().equals("win32") ? (!fn.endsWith(this.fileExtension) ? fn + this.fileExtension : fn) : (!fn.toLowerCase(Locale.getDefault()).endsWith(this.fileExtension) ? fn + this.fileExtension : fn);
        ReportDesignHandle selTemplate = this.templateChoicePage.getTemplate();
        String templateFileName = selTemplate.getFileName();
        String cheatSheetIdFromPage = selTemplate.getCheatSheet();
        if (cheatSheetIdFromPage == null) {
            cheatSheetIdFromPage = "";
        }
        boolean showCheatSheetFromPage = this.templateChoicePage.getShowCheatSheet();
        String cheatSheetId = cheatSheetIdFromPage;
        boolean showCheatSheet = showCheatSheetFromPage;
        boolean isUseDefaultLibray = this.templateChoicePage.isUseDefaultLibrary();
        LibraryHandle libraryName = this.templateChoicePage.getDefaultLibraryHandle();
        IRunnableWithProgress op = new IRunnableWithProgress((String)fileName, templateFileName, selTemplate, cheatSheetId, showCheatSheet, isUseDefaultLibray, libraryName){
            private final /* synthetic */ String val$fileName;
            private final /* synthetic */ String val$templateFileName;
            private final /* synthetic */ ReportDesignHandle val$selTemplate;
            private final /* synthetic */ String val$cheatSheetId;
            private final /* synthetic */ boolean val$showCheatSheet;
            private final /* synthetic */ boolean val$isUseDefaultLibray;
            private final /* synthetic */ LibraryHandle val$libraryName;
            {
                this.val$fileName = string;
                this.val$templateFileName = string2;
                this.val$selTemplate = reportDesignHandle;
                this.val$cheatSheetId = string3;
                this.val$showCheatSheet = bl;
                this.val$isUseDefaultLibray = bl2;
                this.val$libraryName = libraryHandle;
            }

            public void run(IProgressMonitor monitor) {
                try {
                    NewReportWizard.this.doFinish(locPath, this.val$fileName, this.val$templateFileName, NewReportWizard.this.resolveRemoteStream(this.val$templateFileName, this.val$selTemplate), this.val$cheatSheetId, this.val$showCheatSheet, this.val$isUseDefaultLibray, this.val$libraryName, monitor);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExceptionUtil.handle((Throwable)realException);
            return false;
        }
        return true;
    }

    private InputStream resolveRemoteStream(String templateName, ReportDesignHandle handle) {
        if (templateName == null || handle == null) {
            return null;
        }
        File f = new File(templateName);
        if (!f.exists()) {
            try {
                new URL(templateName);
            }
            catch (Exception e) {
                try {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    handle.serialize((OutputStream)out);
                    byte[] bytes = out.toByteArray();
                    out.close();
                    return new ByteArrayInputStream(bytes);
                }
                catch (IOException ie) {
                    ExceptionHandler.handle((Throwable)ie, (boolean)true);
                }
            }
        }
        return null;
    }

    private void doFinish(IPath locationPath, String fileName, String templateFileName, InputStream templateStream, final String cheatSheetId, final boolean showCheatSheet, boolean isUseDefaultLibrary, LibraryHandle library, IProgressMonitor monitor) {
        monitor.beginTask(CREATING + fileName, 2);
        final File file = new File(locationPath.toString(), fileName);
        try {
            File container = new File(locationPath.toString());
            boolean conExists = container.exists();
            if (!conExists) {
                conExists = container.mkdirs();
            }
            if (!conExists) {
                ExceptionUtil.openError((String)Messages.getString((String)"NewReportWizard.title.Error"), (String)Messages.getString((String)"NewReportWizard.wizard.msgDirErr"));
                return;
            }
            ReportDesignHandle handle = templateStream == null ? SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(templateFileName) : SessionHandleAdapter.getInstance().getSessionHandle().createDesignFromTemplate(templateFileName, templateStream);
            if (ReportPlugin.getDefault().getEnableCommentPreference()) {
                handle.setStringProperty("comments", ReportPlugin.getDefault().getCommentPreference());
            }
            if (ReportPlugin.getDefault().getDefaultUnitPreference() != null) {
                handle.setStringProperty("units", ReportPlugin.getDefault().getDefaultUnitPreference());
            }
            if (this.isPredifinedTemplate(templateFileName)) {
                handle.setDisplayName(null);
                handle.setDescription(null);
            }
            UIUtil.addCreateBy((ModuleHandle)handle);
            UIUtil.setDPI((ReportDesignHandle)handle);
            String bidiOrientation = this.templateChoicePage.isLTRDirection() ? "ltr" : "rtl";
            handle.setBidiOrientation(bidiOrientation);
            if (isUseDefaultLibrary) {
                UIUtil.includeLibrary((ModuleHandle)handle, (String)"/ThemesReportItems31.rptlibrary", (boolean)true);
            }
            handle.saveAs(file.getAbsolutePath());
            handle.close();
        }
        catch (Exception e) {
            ExceptionUtil.handle((Throwable)e);
        }
        monitor.worked(1);
        monitor.setTaskName(OPENING_FILE_FOR_EDITING);
        this.getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    IReportResourceSynchronizer synchronizer;
                    if (page == null) {
                        throw new IllegalArgumentException();
                    }
                    page.openEditor((IEditorInput)new ReportEditorInput(file), "org.eclipse.birt.report.designer.ui.editors.ReportEditor", true);
                    if (showCheatSheet && !cheatSheetId.equals("")) {
                        Display.getCurrent().getActiveShell().setData((Object)page);
                        new OpenCheatSheetAction(cheatSheetId).run();
                    }
                    if ((synchronizer = ReportPlugin.getDefault().getResourceSynchronizerService()) != null) {
                        synchronizer.notifyResourceChanged((IReportResourceChangeEvent)new ReportResourceChangeEvent((Object)this, (Object)Path.fromOSString((String)file.getAbsolutePath()), 1));
                    }
                }
                catch (Exception e) {
                    ExceptionUtil.handle((Throwable)e);
                }
            }
        });
        monitor.worked(1);
    }

    public boolean canFinish() {
        return this.templateChoicePage.isPageComplete() && this.newReportFileWizardPage.isPageComplete();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
    }

    private boolean isPredifinedTemplate(String sourceFileName) {
        String predifinedDir = UIUtil.getFragmentDirectory();
        File predifinedFile = new File(predifinedDir);
        File sourceFile = new File(sourceFileName);
        return sourceFile.getAbsolutePath().startsWith(predifinedFile.getAbsolutePath());
    }
}

