/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.runtime;

import junit.framework.TestCase;
import org.eclipse.birt.report.designer.core.runtime.ErrorStatus;

public class ErrorStatusTest
extends TestCase {
    private ErrorStatus status;
    private static final String REASON = "TestReason";
    private static final Exception EXCEPTION = new Exception("TestReason");

    public void setUp() {
        this.status = new ErrorStatus("org.eclipse.birt.report.designer.ui", 1001, REASON, (Throwable)EXCEPTION);
    }

    public void testErrorStatus() {
        ErrorStatusTest.assertEquals((String)REASON, (String)this.status.getMessage());
        ErrorStatusTest.assertEquals((int)1001, (int)this.status.getErrorCode());
        ErrorStatusTest.assertEquals((Object)EXCEPTION, (Object)this.status.getException());
        ErrorStatusTest.assertEquals((String)"org.eclipse.birt.report.designer.ui", (String)this.status.getPlugin());
    }

    public void testAddStatus() {
        this.status.addStatus("TestReason1", 1);
        ErrorStatusTest.assertEquals((String)"TestReason1", (String)this.status.getChildren()[0].getMessage());
        ErrorStatusTest.assertEquals((int)1, (int)this.status.getSeverity());
        this.status.addStatus("TestReason2", 2);
        ErrorStatusTest.assertEquals((String)"TestReason2", (String)this.status.getChildren()[1].getMessage());
        ErrorStatusTest.assertEquals((int)2, (int)this.status.getSeverity());
        this.status.addStatus("TestReason4", 4);
        ErrorStatusTest.assertEquals((String)"TestReason4", (String)this.status.getChildren()[2].getMessage());
        ErrorStatusTest.assertEquals((int)4, (int)this.status.getSeverity());
    }

    public void testAddWarning() {
        this.status.addWarning(REASON);
        ErrorStatusTest.assertEquals((String)REASON, (String)this.status.getChildren()[0].getMessage());
        ErrorStatusTest.assertEquals((int)2, (int)this.status.getSeverity());
    }

    public void testAddError() {
        this.status.addError(REASON);
        ErrorStatusTest.assertEquals((String)REASON, (String)this.status.getChildren()[0].getMessage());
        ErrorStatusTest.assertEquals((int)4, (int)this.status.getSeverity());
    }

    public void testAddInformation() {
        this.status.addInformation(REASON);
        ErrorStatusTest.assertEquals((String)REASON, (String)this.status.getChildren()[0].getMessage());
        ErrorStatusTest.assertEquals((int)1, (int)this.status.getSeverity());
    }

    public void testAddChildren() {
        this.status.addWarning(REASON);
        ErrorStatusTest.assertEquals((int)1, (int)this.status.getChildren().length);
        ErrorStatusTest.assertEquals((int)2, (int)this.status.getSeverity());
        this.status.addError(REASON);
        ErrorStatusTest.assertEquals((int)2, (int)this.status.getChildren().length);
        ErrorStatusTest.assertEquals((int)4, (int)this.status.getSeverity());
        this.status.addInformation(REASON);
        ErrorStatusTest.assertEquals((int)3, (int)this.status.getChildren().length);
        ErrorStatusTest.assertEquals((int)4, (int)this.status.getSeverity());
    }
}

