/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testdriver;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

class TestResultSetMetaDataImpl
implements IResultSetMetaData {
    private ArrayList<TestColumnMetaData> m_columns = null;

    TestResultSetMetaDataImpl() {
        this.init(true);
    }

    TestResultSetMetaDataImpl(boolean includeLOBs) {
        this.init(includeLOBs);
    }

    public int getColumnCount() throws OdaException {
        return this.m_columns.size();
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return this.getCol(index).getDisplayLength();
    }

    public String getColumnLabel(int index) throws OdaException {
        return this.getCol(index).getLabel();
    }

    public String getColumnName(int index) throws OdaException {
        return this.getCol(index).getName();
    }

    public int getColumnType(int index) throws OdaException {
        return this.getCol(index).getType();
    }

    public String getColumnTypeName(int index) throws OdaException {
        return this.getCol(index).getTypeName();
    }

    public int getPrecision(int index) throws OdaException {
        return this.getCol(index).getPrecision();
    }

    public int getScale(int index) throws OdaException {
        return this.getCol(index).getScale();
    }

    public int isNullable(int index) throws OdaException {
        return this.getCol(index).isNullable();
    }

    private void init(boolean includeLOBs) {
        this.m_columns = new ArrayList();
        this.m_columns.add(new TestColumnMetaData(13, "BigDecimalLabel", "BigDecimalCol", 3, "BCD", 10, 2, 0));
        if (includeLOBs) {
            this.m_columns.add(new TestColumnMetaData(50, "BlobLabel1", "BlobCol1", 97, "BLOB", -1, -1, 0));
            this.m_columns.add(new TestColumnMetaData(50, "BlobLabel2", "BlobCol2", 97, "BLOB", -1, -1, 1));
            this.m_columns.add(new TestColumnMetaData(100, "ClobLabel1", "ClobCol1", 98, "CLOB", -1, -1, 0));
            this.m_columns.add(new TestColumnMetaData(100, "ClobLabel2", "ClobCol2", 98, "CLOB", -1, -1, 1));
        }
        this.m_columns.add(new TestColumnMetaData(10, "DateLabel", "DateCol", 91, "DATE", -1, -1, 0));
        this.m_columns.add(new TestColumnMetaData(10, "DoubleLabel", "DoubleCol", 8, "DOUBLE", -1, -1, 0));
        this.m_columns.add(new TestColumnMetaData(11, "IntLabel", "IntCol", 4, "INT", 10, -1, 0));
        this.m_columns.add(new TestColumnMetaData(20, "StringLabel", "StringCol", 12, "CHAR", -1, -1, 0));
        this.m_columns.add(new TestColumnMetaData(17, "TimeLabel", "TimeCol", 92, "TIME", -1, -1, 0));
        this.m_columns.add(new TestColumnMetaData(17, "TimestampLabel", "TimestampCol", 93, "TIMESTAMP", -1, -1, 0));
        this.m_columns.add(new TestColumnMetaData(5, "BooleanLabel", "BooleanCol", 16, "BOOLEAN", -1, -1, 0));
    }

    private TestColumnMetaData getCol(int index) throws OdaException {
        if (index < 1 || index > this.m_columns.size()) {
            throw new OdaException("Invalid column index : " + index);
        }
        return this.m_columns.get(index - 1);
    }

    private class TestColumnMetaData {
        private int m_displayLength = 0;
        private String m_label = null;
        private String m_name = null;
        private int m_type = 0;
        private String m_typeName = null;
        private int m_precision = 0;
        private int m_scale = 0;
        private int m_isNullable;

        TestColumnMetaData(int displayLength, String label, String name, int type, String typeName, int precision, int scale, int isNullable) {
            this.m_displayLength = displayLength;
            this.m_label = label;
            this.m_name = name;
            this.m_type = type;
            this.m_typeName = typeName;
            this.m_precision = precision;
            this.m_scale = scale;
            this.m_isNullable = isNullable;
        }

        int getDisplayLength() {
            return this.m_displayLength;
        }

        String getLabel() {
            return this.m_label;
        }

        String getName() {
            return this.m_name;
        }

        int getType() {
            return this.m_type;
        }

        String getTypeName() {
            return this.m_typeName;
        }

        int getPrecision() {
            return this.m_precision;
        }

        public int getScale() {
            return this.m_scale;
        }

        public int isNullable() throws OdaException {
            return this.m_isNullable;
        }
    }
}

