/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.ir.EngineIRReader;
import org.eclipse.birt.report.engine.ir.EngineIRWriter;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.EngineIRParserTest;
import org.eclipse.birt.report.engine.parser.ReportDesignWriter;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class EngineIRIOTest
extends EngineCase {
    public void testIO() throws Exception {
        String[] designStreams = new String[]{"action_test.rptdesign", "bookmark_test.rptdesign", "highlight_test.rptdesign", "image_test.rptdesign", "map_test.rptdesign", "report_item_test.rptdesign", "text_test.rptdesign", "toc_test.rptdesign", "user_property_test.rptdesign", "visibility_test.rptdesign"};
        int i = 0;
        while (i < designStreams.length) {
            this.doTestIO(designStreams[i], i);
            ++i;
        }
    }

    public void doTestIO(String designName, int i) throws Exception {
        Class clz = i == 0 ? ((Object)((Object)this)).getClass() : EngineIRParserTest.class;
        InputStream input = clz.getResourceAsStream(designName);
        if (input != null) {
            Report report = new ReportParser().parse(".", input);
            EngineIRIOTest.assertTrue((String)("EngineIRIOTest, doTestIO(report exists) - designName: " + designName), (report != null ? 1 : 0) != 0);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new EngineIRWriter().write((OutputStream)out, report);
            out.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            EngineIRReader reader = new EngineIRReader();
            Report report2 = reader.read((InputStream)in);
            reader.link(report2, report.getReportDesign());
            ByteArrayOutputStream out1 = new ByteArrayOutputStream();
            ByteArrayOutputStream out2 = new ByteArrayOutputStream();
            ReportDesignWriter writer = new ReportDesignWriter();
            writer.write((OutputStream)out1, report);
            writer.write((OutputStream)out2, report2);
            String golden = new String(out1.toByteArray());
            String value = new String(out2.toByteArray());
            EngineIRIOTest.assertEquals((String)("EngineIRIOTest, doTestIO(compare: golden, value) - designName: " + designName), (String)golden, (String)value);
        }
    }
}

