/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDynamicFilterParameterDefn;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.engine.api.impl.GetParameterDefinitionTaskUtil;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;

public class GetParameterDefinitionTaskTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/impl/TestGetParameterTask.xml";
    static final String DYNAMIC_FILTER_DESIGN = "org/eclipse/birt/report/engine/api/impl/DynamicFilterParameter.xml";
    static final String REPORT_DESIGN = "GetParameterTaskTest.rptdesign";

    public void setUp() throws Exception {
        super.setUp();
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
    }

    public void tearDown() throws Exception {
        this.removeFile(REPORT_DESIGN);
        super.tearDown();
    }

    public void testParameterWithDataSet() throws SemanticException, EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        ReportDesignHandle design = (ReportDesignHandle)report.getDesignHandle().getModuleHandle();
        ScalarParameterHandle parameter1 = (ScalarParameterHandle)design.findParameter("NewParameter2");
        parameter1.setDataSetName("Data Set1");
        ScalarParameterHandle parameter2 = (ScalarParameterHandle)design.findParameter("NewParameter3");
        parameter2.setDataSetName("Data Set");
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(report);
        task.setLocale(ULocale.US);
        IParameterDefnBase defn = task.getParameterDefn("ParamCountry");
        String name = defn.getName();
        GetParameterDefinitionTaskTest.assertEquals((String)name, (String)"ParamCountry");
        Collection list = task.getSelectionListForCascadingGroup("NewCascadingParameterGroup", new Object[0]);
        Object[] content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"1002", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[0]));
        list = task.getSelectionListForCascadingGroup("NewCascadingParameterGroup", new Object[]{"1002"});
        content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"Atelier graphique", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[0]));
    }

    public void testSortByOnDatasetColumn() throws EngineException, SemanticException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(report);
        Collection list = task.getSelectionListForCascadingGroup("SortBysOfSingleDataSet", new Object[0]);
        Object[] content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"USA", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[1]));
        list = task.getSelectionListForCascadingGroup("SortBysOfSingleDataSet", new Object[]{"USA"});
        content = list.toArray();
        GetParameterDefinitionTaskTest.assertEquals((Object)"MA", (Object)GetParameterDefinitionTaskUtil.SelectionChoiceUtil.getValue((Object)content[1]));
    }

    public void testParameterInfo() throws EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(report);
        IScalarParameterDefn param = (IScalarParameterDefn)task.getParameterDefn("NewParameter2");
        GetParameterDefinitionTaskTest.assertTrue((param.getSelectionListType() == 1 ? 1 : 0) != 0);
    }

    public void testDynamicFilterParameters() throws EngineException {
        this.copyResource(DYNAMIC_FILTER_DESIGN, REPORT_DESIGN);
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(runnable);
        IParameterDefnBase param = task.getParameterDefn("Param_1");
        if (param instanceof IDynamicFilterParameterDefn) {
            IDynamicFilterParameterDefn dynParam = (IDynamicFilterParameterDefn)param;
            GetParameterDefinitionTaskTest.assertNotNull((Object)dynParam.getColumn());
        } else {
            GetParameterDefinitionTaskTest.fail();
        }
    }

    public void testMultipleValues() throws EngineException {
        this.copyResource(REPORT_DESIGN_RESOURCE, REPORT_DESIGN);
        IReportRunnable runnable = this.engine.openReportDesign(REPORT_DESIGN);
        IGetParameterDefinitionTask task = this.engine.createGetParameterDefinitionTask(runnable);
        String cpg1 = "MultiValueSingleDatasetCPG";
        String[][] values = new String[][]{{"USA"}, {"NV", "PA"}};
        Collection col = task.getSelectionListForCascadingGroup(cpg1, (Object[])values);
        GetParameterDefinitionTaskTest.assertEquals((int)3, (int)col.size());
        values = new String[][]{{"USA", "Japan"}, {"NV", "NY", "PA", "Osaka", "Tokyo"}};
        col = task.getSelectionListForCascadingGroup(cpg1, (Object[])values);
        GetParameterDefinitionTaskTest.assertEquals((int)7, (int)col.size());
        values = new String[][]{{"USA", "Japan"}, {"PA"}};
        col = task.getSelectionListForCascadingGroup(cpg1, (Object[])values);
        GetParameterDefinitionTaskTest.assertEquals((int)2, (int)col.size());
    }
}

