/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.util;

import junit.framework.TestCase;
import org.eclipse.birt.report.model.adapter.oda.util.ParameterValueUtil;

public class ParameterValueUtilTest
extends TestCase {
    public void testParameterValueUtil() {
        this.assertQuoteConversion("'1'", "1");
        this.assertQuoteConversion("'normal value'", "normal value");
        this.assertQuoteConversion("'[0PROJECT].[P10000000]'", "[0PROJECT].[P10000000]");
        this.assertQuoteConversion("'It\\'s ok.'", "It's ok.");
        this.assertQuoteConversion("'It\\'s ok. Isn\\'t it?'", "It's ok. Isn't it?");
        this.assertQuoteConversion("'It\\'s ok. Isn\\'t it? Y\\'eah.'", "It's ok. Isn't it? Y'eah.");
        this.assertQuoteConversion("'It\\'\\'s ok.'", "It''s ok.");
        this.assertQuoteConversion("'\\'It\\'s ok.\\''", "'It's ok.'");
        this.assertQuoteConversion("'\\'\\''", "''");
        this.assertQuoteConversion("''", "");
        ParameterValueUtilTest.assertNull((Object)ParameterValueUtil.toJsExprValue(null, null));
        ParameterValueUtilTest.assertNull((Object)ParameterValueUtil.toLiteralValue(null));
        ParameterValueUtilTest.assertEquals((String)"'begin literal quote", (String)ParameterValueUtil.toLiteralValue((String)"'begin literal quote"));
        ParameterValueUtilTest.assertEquals((String)"end literal quote'", (String)ParameterValueUtil.toLiteralValue((String)"end literal quote'"));
        ParameterValueUtilTest.assertFalse((boolean)ParameterValueUtil.isQuoted((String)"\"a\"+\"b\""));
        ParameterValueUtilTest.assertTrue((boolean)ParameterValueUtil.isQuoted((String)"\"a+b\""));
    }

    private void assertQuoteConversion(String expectedQuotedValue, String literalValue) {
        String actualQuotedValue = ParameterValueUtil.toJsExprValue((String)literalValue, null);
        ParameterValueUtilTest.assertEquals((String)expectedQuotedValue, (String)actualQuotedValue);
        ParameterValueUtilTest.assertEquals((String)literalValue, (String)ParameterValueUtil.toLiteralValue((String)actualQuotedValue));
    }
}

