/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.metadata.ExtensionException;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.MetaDataParserException;
import org.eclipse.birt.report.model.metadata.MetaLogManager;

public abstract class ExtensionLoader {
    private static Logger logger = Logger.getLogger(ExtensionLoader.class.getName());
    private String extensionPointer = null;

    ExtensionLoader(String extensionPointer) {
        this.extensionPointer = extensionPointer;
    }

    protected abstract void loadExtension(IExtension var1);

    public final void load() {
        this.doLoad();
    }

    protected void handleError(MetaDataException e) {
        logger.log(Level.SEVERE, e.getMessage());
        MetaLogManager.log("Extension loading error", (Throwable)((Object)e));
    }

    protected void handleError(MetaDataParserException e) {
        logger.log(Level.SEVERE, e.getMessage());
        MetaLogManager.log("Delta Metadata parsing error", e);
    }

    protected final void handleError(String message) {
        logger.log(Level.SEVERE, message);
        MetaLogManager.log(message);
    }

    protected void doLoad() {
        IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
        if (pluginRegistry == null) {
            this.handleError(new ExtensionException(new String[]{this.extensionPointer}, "EXTENSION_POINT_NOT_FOUND"));
            return;
        }
        IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint(this.extensionPointer);
        if (extensionPoint == null) {
            this.handleError(new ExtensionException(new String[]{this.extensionPointer}, "EXTENSION_POINT_NOT_FOUND"));
            return;
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        if (extensions != null) {
            int i = 0;
            while (i < extensions.length) {
                this.loadExtension(extensions[i]);
                ++i;
            }
        }
    }

    abstract class ExtensionElementLoader {
        protected static final String EXTENSION_NAME_ATTRIB = "extensionName";
        protected static final String CLASS_ATTRIB = "class";

        ExtensionElementLoader() {
        }

        abstract void loadElement(IConfigurationElement var1);

        protected boolean checkRequiredAttribute(String name, String value) {
            if (StringUtil.isBlank(value)) {
                ExtensionLoader.this.handleError(new ExtensionException(new String[]{name}, "VALUE_REQUIRED"));
                return false;
            }
            return true;
        }

        protected boolean getBooleanAttrib(IConfigurationElement attrs, String attrName, boolean defaultValue) {
            String value = attrs.getAttribute(attrName);
            if (value == null) {
                return defaultValue;
            }
            if ("false".equalsIgnoreCase(value.trim())) {
                return false;
            }
            if ("true".equalsIgnoreCase(value.trim())) {
                return true;
            }
            return defaultValue;
        }
    }
}

