/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.util.Blob;
import org.eclipse.birt.data.oda.pojo.util.Clob;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class DataTypeUtil {
    private static ULocale locale = ULocale.getDefault();

    public static Float toFloatFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            return Float.valueOf(NumberFormat.getInstance((ULocale)locale).parse(s).floatValue());
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Character toCharFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return Character.valueOf(s.charAt(0));
        }
        throw new OdaException(Messages.getString("DataTypeUtil.FailToTransferType", s, Character.class.getName()));
    }

    public static Short toShortFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            return NumberFormat.getInstance((ULocale)locale).parse(s).shortValue();
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Byte toByteFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            return NumberFormat.getInstance((ULocale)locale).parse(s).byteValue();
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Integer toIntegerFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            return NumberFormat.getInstance((ULocale)locale).parse(s).intValue();
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Double toDoubleFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            return NumberFormat.getInstance((ULocale)locale).parse(s).doubleValue();
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static BigDecimal toBigDecimalFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            Number n = NumberFormat.getInstance((ULocale)locale).parse(s);
            return new BigDecimal(n.toString());
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Date toDateFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            java.util.Date date = DateFormat.getInstance().parse(s);
            return new Date(date.getTime());
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Time toTimeFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            java.util.Date date = DateFormat.getInstance().parse(s);
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static Timestamp toTimestampFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        try {
            java.util.Date date = DateFormat.getInstance().parse(s);
            return new Timestamp(date.getTime());
        }
        catch (ParseException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public static IBlob toBlobFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        throw new OdaException("Failed to conver " + s + "(" + String.valueOf(s.getClass()) + ") to Blob");
    }

    public static IClob toClobFromString(String s) throws OdaException {
        if (s == null) {
            return null;
        }
        throw new OdaException("Failed to conver " + s + "(" + String.valueOf(s.getClass()) + ") to Clob");
    }

    public static Boolean toBooleanFromString(String s) throws OdaException {
        if (s == null) {
            return false;
        }
        return !"false".equalsIgnoreCase(s);
    }

    public static int toInt(Object o) throws OdaException {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return DataTypeUtil.toIntegerFromString(o.toString());
    }

    public static double toDouble(Object o) throws OdaException {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        return DataTypeUtil.toDoubleFromString(o.toString());
    }

    public static BigDecimal toBigDecimal(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        return DataTypeUtil.toBigDecimalFromString(o.toString());
    }

    public static Date toDate(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        if (o instanceof java.util.Date) {
            return new Date(((java.util.Date)o).getTime());
        }
        return DataTypeUtil.toDateFromString(o.toString());
    }

    public static Time toTime(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof Time) {
            return (Time)o;
        }
        return DataTypeUtil.toTimeFromString(o.toString());
    }

    public static Timestamp toTimestamp(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof Timestamp) {
            return (Timestamp)o;
        }
        return DataTypeUtil.toTimestampFromString(o.toString());
    }

    public static IBlob toBlob(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof IBlob) {
            return (IBlob)o;
        }
        if (o instanceof java.sql.Blob) {
            return new Blob((java.sql.Blob)o);
        }
        return DataTypeUtil.toBlobFromString(o.toString());
    }

    public static IClob toClob(Object o) throws OdaException {
        if (o == null) {
            return null;
        }
        if (o instanceof IClob) {
            return (IClob)o;
        }
        if (o instanceof java.sql.Clob) {
            return new Clob((java.sql.Clob)o);
        }
        return DataTypeUtil.toClobFromString(o.toString());
    }

    public static boolean toBoolean(Object o) throws OdaException {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return DataTypeUtil.toBooleanFromString(o.toString());
        }
        if (o instanceof Integer) {
            return (Integer)o != 0;
        }
        return true;
    }

    public static String toString(Object o) {
        return o == null ? null : o.toString();
    }
}

