/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.querymodel;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.birt.data.oda.pojo.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.querymodel.Column;
import org.eclipse.birt.data.oda.pojo.querymodel.ColumnReferenceNode;
import org.eclipse.birt.data.oda.pojo.querymodel.IColumnsMapping;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.querymodel.ReferenceNode;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ReferenceGraph {
    private ReferenceNode[] roots;
    private ColumnReferenceNode[] columnReferences;
    private Map<String, Integer> columnNameIndexMap;

    public ReferenceGraph(ReferenceNode[] roots) {
        assert (roots != null);
        this.roots = roots;
    }

    public int getColumnCount() throws OdaException {
        return this.getColumnReferences().length;
    }

    public Column getColumn(int index) throws OdaException {
        return this.getColumnReferences()[index - 1].getColumn();
    }

    public ReferenceNode[] getRoots() {
        return this.roots;
    }

    private Map<String, Integer> getColumnNameIndexMap() throws OdaException {
        if (this.columnNameIndexMap == null) {
            this.columnNameIndexMap = new HashMap<String, Integer>();
            int i = 1;
            ColumnReferenceNode[] columnReferenceNodeArray = this.getColumnReferences();
            int n = columnReferenceNodeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ColumnReferenceNode crn = columnReferenceNodeArray[n2];
                String name = crn.getColumn().getName();
                if (this.columnNameIndexMap.containsKey(name)) {
                    throw new OdaException(Messages.getString("ReferenceGraph.DuplicateColumnName", name));
                }
                this.columnNameIndexMap.put(name, i++);
                ++n2;
            }
        }
        return this.columnNameIndexMap;
    }

    public int findColumn(String columnName) throws OdaException {
        Integer index = this.getColumnNameIndexMap().get(columnName);
        if (index != null) {
            return index;
        }
        throw new OdaException(Messages.getString("ReferenceGraph.InexistentColumnName", columnName));
    }

    public ColumnReferenceNode getColumnReferenceNode(int index) throws OdaException {
        return this.getColumnReferences()[index - 1];
    }

    public ColumnReferenceNode[] getColumnReferences() throws OdaException {
        if (this.columnReferences == null) {
            ArrayList<ColumnReferenceNode> result = new ArrayList<ColumnReferenceNode>();
            ReferenceNode[] referenceNodeArray = this.roots;
            int n = this.roots.length;
            int n2 = 0;
            while (n2 < n) {
                ReferenceNode rn = referenceNodeArray[n2];
                result.addAll(Arrays.asList(rn.getColumnReferenceNodes()));
                ++n2;
            }
            HashSet<Integer> indexes = new HashSet<Integer>();
            for (ColumnReferenceNode crn : result) {
                if (indexes.contains(crn.getColumn().getIndex())) {
                    throw new OdaException(Messages.getString("ReferenceGraph.DuplicateColumnIndex", crn.getColumn().getIndex()));
                }
                indexes.add(crn.getColumn().getIndex());
            }
            this.columnReferences = result.toArray(new ColumnReferenceNode[0]);
            Arrays.sort(this.columnReferences);
        }
        return this.columnReferences;
    }

    public static ReferenceGraph create(PojoQuery query) {
        ArrayList<ReferenceNode> roots = new ArrayList<ReferenceNode>();
        IColumnsMapping[] iColumnsMappingArray = query.getColumnsMappings();
        int n = iColumnsMappingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IColumnsMapping mapping = iColumnsMappingArray[n2];
            roots.add(mapping.createReferenceNode(null));
            ++n2;
        }
        return new ReferenceGraph(roots.toArray(new ReferenceNode[0]));
    }
}

