/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.List;

public class PageRangeIterator {
    private List pages;
    int curPageRange = -1;
    private long nextPage = -1L;

    public PageRangeIterator(List pages) {
        this.pages = pages;
        if (pages.size() > 0) {
            this.curPageRange = 0;
            long[] pageRange = (long[])pages.get(this.curPageRange);
            this.nextPage = pageRange[0];
        } else {
            this.nextPage = -1L;
        }
    }

    public boolean hasNext() {
        return this.nextPage != -1L;
    }

    public long next() {
        if (this.hasNext()) {
            long returnedPage = this.nextPage;
            if (this.curPageRange < this.pages.size()) {
                long pageNumber = this.nextPage + 1L;
                long[] pageRange = (long[])this.pages.get(this.curPageRange);
                if (pageRange[0] <= pageNumber && pageRange[1] >= pageNumber) {
                    this.nextPage = pageNumber;
                } else {
                    ++this.curPageRange;
                    if (this.curPageRange < this.pages.size()) {
                        pageRange = (long[])this.pages.get(this.curPageRange);
                        this.nextPage = pageRange[0];
                    } else {
                        this.nextPage = -1L;
                    }
                }
            }
            return returnedPage;
        }
        return -1L;
    }
}

