/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.internal.ui.editors.action;

import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabCellHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.AbstractCrosstabAction;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.ui.i18n.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.olap.CubeHandle;

public class SplitCrosstabHeadCellAction
extends AbstractCrosstabAction {
    public static final String ID = "org.eclipse.birt.report.item.crosstab.internal.ui.editors.action.SplitHeadCellAction";
    private static final String NAME = Messages.getString("SplitCrosstabHeadCellAction_name");
    private CrosstabCellHandle cellHandle;

    public SplitCrosstabHeadCellAction(DesignElementHandle handle) {
        super(handle);
        this.setId(ID);
        this.setText(NAME);
        ExtendedItemHandle extendedHandle = CrosstabAdaptUtil.getExtendedItemHandle(handle);
        this.setHandle((DesignElementHandle)extendedHandle);
        try {
            this.cellHandle = (CrosstabCellHandle)extendedHandle.getReportItem();
        }
        catch (ExtendedElementException e) {
            this.cellHandle = null;
        }
    }

    public void run() {
        this.transStar(NAME);
        CrosstabUtil.splitCrosstabHeaderCell((CrosstabReportItemHandle)this.cellHandle.getCrosstab());
        CrosstabUtil.addAllHeaderLabel((CrosstabReportItemHandle)this.cellHandle.getCrosstab());
        this.transEnd();
    }

    @Override
    public boolean isEnabled() {
        if (this.cellHandle == null) {
            return false;
        }
        CubeHandle cubeHandle = this.cellHandle.getCrosstab().getCube();
        if (cubeHandle == null || DEUtil.isReferenceElement((DesignElementHandle)this.cellHandle.getCrosstabHandle())) {
            return false;
        }
        return CrosstabUtil.canSplitCrosstabHeaderCell((CrosstabReportItemHandle)this.cellHandle.getCrosstab());
    }
}

