/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.dialogs.AbstractParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterDialog;
import org.eclipse.birt.report.designer.ui.dialogs.InputParameterSelectionChoice;
import org.eclipse.birt.report.designer.ui.dialogs.InternalParameterSelectionChoice;
import org.eclipse.birt.report.designer.ui.parameters.CascadingParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.ListingParameter;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;

abstract class SelectionParameterControlHelper
extends AbstractParameterControlHelper {
    private boolean performed = false;
    boolean isCascade = false;
    protected List<IParameterSelectionChoice> valueList = new ArrayList<IParameterSelectionChoice>();
    private boolean isCascadeGroup;
    private CascadingParameterGroup cascadeGroup;
    protected List<String> controlResetItems = new ArrayList<String>();

    public SelectionParameterControlHelper(InputParameterDialog dialog) {
        super(dialog);
    }

    abstract Control getControl();

    @Override
    protected void prepare() {
        super.prepare();
        this.prepareValueList();
        this.initCascadeGroup();
    }

    private void initCascadeGroup() {
        if (this.parameter.getParentGroup() instanceof CascadingParameterGroup) {
            this.isCascadeGroup = true;
            this.cascadeGroup = (CascadingParameterGroup)this.parameter.getParentGroup();
        }
    }

    protected void cascadingParamValueChanged(CascadingParameterGroup group, ScalarParameter listParam) {
        if (listParam == null) {
            return;
        }
        if (this.getPostParamList().containsKey(listParam)) {
            this.copeWithCurrentParameter(listParam);
            ScalarParameter postParam = this.copeWithNextParameter(group, listParam);
            this.cascadingParamValueChanged(group, postParam);
        }
    }

    private void copeWithCurrentParameter(ScalarParameter currentParam) {
        Object value = this.lastConfigValues.get(currentParam.getHandle().getName());
        currentParam.setSelectionValue(value);
    }

    private ScalarParameter copeWithNextParameter(CascadingParameterGroup group, ScalarParameter listParam) {
        ListingParameter postParam = (ListingParameter)group.getPostParameter(listParam);
        if (postParam == null) {
            return null;
        }
        SelectionParameterControlHelper helper = this.getPostParamList().get(listParam);
        helper.emptyControlItem();
        Control control = helper.getControl();
        int itemIndex = 0;
        for (IParameterSelectionChoice choice : ((ScalarParameter)postParam).getValueList()) {
            String label;
            if (choice.getValue() == null || (label = this.getFormatLabelString(choice, listParam)) == null) continue;
            itemIndex = this.addControlItem(control, label);
            if (control instanceof Combo) {
                control.setData(String.valueOf(itemIndex), choice.getValue());
                continue;
            }
            control.setData(label, choice.getValue());
        }
        this.processPostParator(postParam, control);
        return postParam;
    }

    private int addControlItem(Control control, String item) {
        int itemIndex = 0;
        if (control instanceof Combo) {
            ((Combo)control).add(item);
            itemIndex = ((Combo)control).getItemCount() - 1;
        }
        if (control instanceof org.eclipse.swt.widgets.List) {
            ((org.eclipse.swt.widgets.List)control).add(item);
            itemIndex = ((org.eclipse.swt.widgets.List)control).getItemCount() - 1;
        }
        return itemIndex;
    }

    private void processPostParator(ScalarParameter listParam, Control control) {
        Combo combo;
        Object value = this.lastConfigValues.get(listParam.getHandle().getName());
        boolean found = false;
        if (control instanceof Combo && !(found = this.dealWithValueInComboList(-1, value, combo = (Combo)control, listParam))) {
            try {
                Object obj = listParam.converToDataType(listParam.getDefaultObject());
                if (obj == null) {
                    listParam.setSelectionValue(null);
                    this.putConfigValue(listParam.getHandle().getName(), null);
                } else {
                    boolean isCascade = this.isCascadeParameter(listParam);
                    this.dealWithValueNotInComboList(obj, combo, listParam, isCascade, combo.getItems());
                }
            }
            catch (BirtException birtException) {
                // empty catch block
            }
        }
        if (control instanceof org.eclipse.swt.widgets.List) {
            org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)control;
            this.initListValue(value, list, listParam);
        }
    }

    private void dealWithValueNotInComboList(Object value, Combo combo, ScalarParameter listParam, boolean isCascade, Object comboData) {
        if (!isCascade || isCascade && this.isContainValue(listParam.getDefaultObject(), comboData)) {
            combo.setText(value == null ? NULL_VALUE_STR : value.toString());
            listParam.setSelectionValue(combo.getText());
            this.putConfigValue(listParam.getHandle().getName(), combo.getText());
        } else if (combo.getItemCount() > 0) {
            combo.select(0);
            listParam.setSelectionValue(combo.getText());
            this.putConfigValue(listParam.getHandle().getName(), combo.getData(String.valueOf(combo.getSelectionIndex())));
        } else {
            this.putConfigValue(listParam.getHandle().getName(), null);
        }
    }

    protected void setSelectValueAfterInitCombo(int selectIndex, Combo combo) {
        boolean found = this.dealWithValueInComboList(selectIndex, this.defaultValue, combo, this.parameter);
        if (!found) {
            this.dealWithValueNotInComboList(this.defaultValue, combo, this.parameter, this.isCascade, this.valueList);
        }
    }

    private boolean dealWithValueInComboList(int selectIndex, Object value, Combo combo, ScalarParameter listParam) {
        boolean found = false;
        if (selectIndex > 0) {
            combo.select(selectIndex);
            this.putConfigValue(listParam.getHandle().getName(), combo.getData(String.valueOf(combo.getSelectionIndex())));
            listParam.setSelectionValue(this.lastConfigValues.get(listParam.getHandle().getName()));
            found = true;
            return found;
        }
        int i = 0;
        while (i < combo.getItemCount()) {
            Object data = combo.getData(String.valueOf(i));
            if (value == data || value != null && value.equals(data)) {
                combo.select(i);
                this.putConfigValue(listParam.getHandle().getName(), combo.getData(String.valueOf(combo.getSelectionIndex())));
                listParam.setSelectionValue(this.lastConfigValues.get(listParam.getHandle().getName()));
                found = true;
                break;
            }
            ++i;
        }
        return found;
    }

    protected void initListValue(Object value, org.eclipse.swt.widgets.List list, ScalarParameter listParam) {
        ArrayList<Object> newValueList = new ArrayList<Object>();
        List<Object> oldvalueList = new ArrayList<Object>();
        if (value instanceof Object[]) {
            oldvalueList = Arrays.asList((Object[])value);
        } else {
            oldvalueList.add(value);
        }
        int i = 0;
        while (i < list.getItemCount()) {
            Object item = list.getData(list.getItem(i));
            if (oldvalueList.indexOf(item) >= 0) {
                list.select(i);
                newValueList.add(list.getData(list.getItem(i)));
            }
            ++i;
        }
        this.putConfigValue(listParam.getHandle().getName(), newValueList.toArray(new Object[newValueList.size()]));
    }

    protected void doWithCascadeGroup() {
        if (this.isCascadeGroup && this.cascadeGroup.getPostParameter(this.parameter) != null) {
            this.cascadingParamValueChanged(this.cascadeGroup, this.parameter);
        }
    }

    protected void prepareValueList() {
        boolean containsBlank = false;
        boolean containsNull = false;
        List localValueList = this.parameter.getValueList();
        for (Object o : localValueList) {
            Object choiceValue = ((IParameterSelectionChoice)o).getValue();
            if (InputParameterSelectionChoice.BLANKVALUECHOICE.getValue().equals(choiceValue)) {
                containsBlank = true;
            }
            if (choiceValue != null) continue;
            containsNull = true;
        }
        if (this.isStringType && !this.isRequired && !containsBlank) {
            this.valueList.add(InputParameterSelectionChoice.BLANKVALUECHOICE);
        }
        this.valueList.addAll(localValueList);
        this.dealCascade();
        if (!this.isRequired && !containsNull) {
            this.valueList.add(InputParameterSelectionChoice.NULLVALUECHOICE);
        }
    }

    private void dealCascade() {
        this.isCascade = this.isCascadeParameter(this.parameter);
        if (!this.isCascade) {
            this.addDefaultToValueList(this.formatString(this.parameter.getDefaultValue(), this.parameter), this.parameter.getDefaultObject(), this.valueList);
        }
    }

    private void addDefaultToValueList(String defaultValueLabel, Object defaultValue, List list) {
        if (this.performed) {
            return;
        }
        boolean contains = this.isContainValue(defaultValue, list);
        if (!contains && defaultValue != null) {
            InternalParameterSelectionChoice choice = new InternalParameterSelectionChoice(defaultValueLabel, defaultValue);
            list.add(choice);
        }
        this.performed = true;
    }

    private boolean isContainValue(Object defaultValue, List list) {
        boolean result = false;
        int i = 0;
        while (i < list.size()) {
            Object obj = ((IParameterSelectionChoice)list.get(i)).getValue();
            if (obj != null && obj.equals(defaultValue)) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private boolean isContainValue(Object defaultValue, String[] items) {
        int i = 0;
        while (i < items.length) {
            if (defaultValue == items[i] || defaultValue.equals(items[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isContainValue(Object value, Object data) {
        boolean result = false;
        if (data instanceof List) {
            result = this.isContainValue(value, (List)data);
        } else if (data instanceof String[]) {
            result = this.isContainValue(value, (String[])data);
        }
        return result;
    }

    private boolean isCascadeParameter(ScalarParameter param) {
        List child;
        boolean result = false;
        IParameterGroup group = param.getParentGroup();
        if (group instanceof CascadingParameterGroup && (child = param.getParentGroup().getChildren()) != null && child.size() > 1) {
            int i = 1;
            while (i < child.size()) {
                if (param.equals(child.get(i))) {
                    result = true;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    protected void addCascadeParamterRelation() {
        if (this.isCascadeGroup && this.cascadeGroup.getPreParameter(this.parameter) != null) {
            this.parameterDialog.addPostParamter(this.cascadeGroup.getPreParameter(this.parameter), this);
        }
    }

    private Map<IParameter, SelectionParameterControlHelper> getPostParamList() {
        return this.parameterDialog.getPostParamLists();
    }

    protected void addItemForControlReset(String data) {
        if ("".equals(data) || NULL_VALUE_STR.equals(data)) {
            this.controlResetItems.add(0, data);
        }
    }

    private void emptyControlItem() {
        if (this.getControl() instanceof Combo) {
            ((Combo)this.getControl()).setItems(this.controlResetItems.toArray(new String[this.controlResetItems.size()]));
        } else if (this.getControl() instanceof org.eclipse.swt.widgets.List) {
            ((org.eclipse.swt.widgets.List)this.getControl()).setItems(this.controlResetItems.toArray(new String[this.controlResetItems.size()]));
        }
    }
}

