/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.parameter;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.ui.preview.parameter.DataTypeConvertUtil;
import org.eclipse.birt.report.designer.ui.preview.parameter.FormatUtil;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParamGroup;
import org.eclipse.birt.report.designer.ui.preview.parameter.IParameter;
import org.eclipse.birt.report.engine.api.IEngineTask;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public abstract class ScalarParam
implements IParameter {
    protected IParamGroup group = null;
    private String selectionValue = null;
    protected ScalarParameterHandle handle;
    protected IEngineTask engineTask;

    @Override
    public String getSelectionValue() {
        return this.selectionValue;
    }

    @Override
    public void setSelectionValue(String value) {
        this.selectionValue = value;
    }

    @Override
    public void setParentGroup(IParamGroup group) {
        this.group = group;
    }

    @Override
    public IParamGroup getParentGroup() {
        return this.group;
    }

    public ScalarParam(ScalarParameterHandle handle, IEngineTask engineTask) {
        this.handle = handle;
        this.engineTask = engineTask;
    }

    @Override
    public abstract List getValueList();

    @Override
    public String getDefaultValue() {
        return this.handle.getDefaultValue();
    }

    public ScalarParameterHandle getHandle() {
        return this.handle;
    }

    @Override
    public String format(String input) throws BirtException {
        return FormatUtil.format((ParameterHandle)this.handle, input);
    }

    @Override
    public Object converToDataType(Object value) throws BirtException {
        return DataTypeConvertUtil.convert(value, this.handle.getDataType());
    }

    @Override
    public boolean isRequired() {
        return this.handle.isRequired();
    }
}

