/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import junit.framework.TestCase;
import org.eclipse.birt.core.script.CoreJavaScriptInitializer;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class NativeFinanceTest
extends TestCase {
    Context cx;
    Scriptable scope;
    boolean hasException;

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        new CoreJavaScriptInitializer().initialize(this.cx, this.scope);
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    protected double eval(String script) {
        try {
            this.hasException = false;
            Object value = this.cx.evaluateString(this.scope, script, "inline", 1, null);
            return (Double)value;
        }
        catch (Throwable ex) {
            this.hasException = true;
            return Double.NaN;
        }
    }

    @Test
    public void testDdb() {
        double value = this.eval("Finance.ddb(1400, '200', '10', '1')");
        NativeFinanceTest.assertEquals((double)280.0, (double)value, (double)Double.MIN_VALUE);
        value = this.eval("Finance.ddb( 1400, 200, 10, 1 )");
        NativeFinanceTest.assertEquals((double)280.0, (double)value, (double)Double.MIN_VALUE);
        this.eval("Finance.ddb( 1400, 200, -10, 1 )");
        NativeFinanceTest.assertTrue((boolean)this.hasException);
    }

    @Test
    public void testSln() {
        double value = this.eval("Finance.sln( 1400, 200, 10 )");
        NativeFinanceTest.assertEquals((double)120.0, (double)value, (double)Double.MIN_VALUE);
        value = this.eval("Finance.sln( 1400, 200, -10 )");
        NativeFinanceTest.assertEquals((double)-120.0, (double)value, (double)Double.MIN_VALUE);
    }

    @Test
    public void testSyd() {
        double value = this.eval("Finance.syd( 1400, 200, 2, 1 )");
        NativeFinanceTest.assertEquals((double)800.0, (double)value, (double)Double.MIN_VALUE);
        value = this.eval("Finance.syd( -1400, 200, 3, 1 )");
        NativeFinanceTest.assertEquals((double)-800.0, (double)value, (double)Double.MIN_VALUE);
    }

    @Test
    public void testFv() {
        String script1 = "Finance.fv( 0.057 / 365, 18 * 365, 0, -10000, 1 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)27896.6, (double)value1, (double)0.01);
        String script2 = "Finance.fv( 0.057 / 12, 18 * 12, -55, -10000, 1 )";
        double value2 = this.eval(script2);
        NativeFinanceTest.assertEquals((double)48575.82, (double)value2, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
        String script3 = "Finance.fv( 0.057 / 12, 18 * 12, -55, -10000, 3 )";
        this.eval(script3);
    }

    @Test
    public void testPmt() {
        String script1 = " Finance.pmt( 0.115 / 12, 36, -20000, 0, 1 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)653.26, (double)value1, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
        String script3 = "Finance.pmt( 0.115 / 12, 36, -20000, 0, -1 )";
        this.eval(script3);
    }

    @Test
    public void testIpmt() {
        String script1 = "Finance.ipmt( 0.115 / 12, 5, 36, -20000, 0, 1 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)171.82, (double)value1, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
        String script2 = "Finance.ipmt( 0.115 / 12, 37, 36, -20000, 0, 1 )";
        this.eval(script2);
        String script3 = "Finance.ipmt( 0.115 / 12, 3, 36, -20000, 0, 8 )";
        this.eval(script3);
    }

    @Test
    public void testPpmt() {
        String script1 = " Finance.ppmt( 0.115 / 12, 5, 36, -20000, 0, 1 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)481.43, (double)value1, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
        String script2 = "Finance.ppmt( 0.115 / 12, 66, 36, -20000, 0, 1 )";
        this.eval(script2);
        String script3 = "Finance.ppmt( 0.115 / 12, 5, 36, -20000, 0, 7 )";
        this.eval(script3);
    }

    @Test
    public void testNPer() {
        double value = this.eval("Finance.nper( 0.01, -2000, 20000, 0, 1 )");
        NativeFinanceTest.assertEquals((double)10.478, (double)value, (double)0.001);
        value = this.eval("Finance.nper( 0.01, -2000, 20000, 0, 0 )");
        NativeFinanceTest.assertEquals((double)10.588, (double)value, (double)0.001);
    }

    @Test
    public void testPv() {
        String script1 = "Finance.pv( 0.105 / 12, 3 * 12, -325, 11000, 1 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)2048.06, (double)value1, (double)0.01);
        String script3 = "Finance.nPer( 0.115 / 12, -4, 20000, 0, 1 )";
        this.eval(script3);
    }

    @Test
    public void testRate() {
        String script1 = "Finance.rate( 3 * 12, -653.26, 20000, 0, 1, 0.1 ) * 12";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)0.115, (double)value1, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
        String script2 = "Finance.rate( -3, -653.26, 20000, 0, 1, 0.1 )";
        this.eval(script2);
    }

    @Test
    public void testPercent() {
        String script1 = "Finance.percent( 20, 50 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)250.0, (double)value1, (double)Double.MIN_VALUE);
        String script2 = "Finance.percent( 50, 0 )";
        double value2 = this.eval(script2);
        NativeFinanceTest.assertEquals((double)0.0, (double)value2, (double)Double.MIN_VALUE);
        String script3 = "Finance.percent( '20', 50 )";
        double value3 = this.eval(script3);
        NativeFinanceTest.assertEquals((double)250.0, (double)value3, (double)Double.MIN_VALUE);
    }

    @Test
    public void testNpv() {
        String script1 = "var array=new Array(4);array[0]=-10000;array[1]=3000;array[2]=4200;array[3]=6800;Finance.npv( 0.1, array )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)1188.44, (double)value1, (double)0.01);
    }

    @Test
    public void testIrr() {
        double[] a = new double[]{-70000.0, 12000.0, 15000.0};
        Object jsNumber = Context.javaToJS((Object)a, (Scriptable)this.scope);
        ScriptableObject.putProperty((Scriptable)this.scope, (String)"array", (Object)jsNumber);
        String script4 = "Finance.irr( array, -0.6 )";
        double value4 = this.eval(script4);
        NativeFinanceTest.assertEquals((double)-0.44, (double)value4, (double)0.01);
        String script1 = "var array=new Array(6);array[0]=-70000;array[1]=12000;array[2]=15000;array[3]=18000;array[4]=21000;array[5]=26000;Finance.irr( array, 0.01)";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)0.0866, (double)value1, (double)1.0E-4);
        String script2 = "var array=new Array(5);array[0]=-70000;array[1]=12000;array[2]=15000;array[3]=18000;array[4]=21000;Finance.irr(array, -0.1 )";
        double value2 = this.eval(script2);
        NativeFinanceTest.assertEquals((double)-0.021244848273899997, (double)value2, (double)Double.MIN_VALUE);
        String script3 = "var array=new Array(3);array[0]=-70000;array[1]=12000;array[2]=15000;Finance.irr(array, -0.6 )";
        double value3 = this.eval(script3);
        NativeFinanceTest.assertEquals((double)-0.44, (double)value3, (double)0.01);
        NativeFinanceTest.assertFalse((boolean)this.hasException);
    }

    @Test
    public void testMirr() {
        String script1 = "var array=new Array(6);array[0]=-120000;array[1]=39000;array[2]=30000;array[3]=21000;array[4]=37000;array[5]=46000;Finance.mirr( array, 0.1, 0.12 )";
        double value1 = this.eval(script1);
        NativeFinanceTest.assertEquals((double)0.126, (double)value1, (double)0.001);
    }
}

