/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.content;

import junit.framework.TestCase;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.ContentFactory;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.content.ListContainerExecutor;

public class ListContainerExecutorTest
extends TestCase {
    public void testListStacking() throws BirtException {
        IReportContent report = ContentFactory.createReportContent();
        IListContent list = report.createListContent();
        IListBandContent listHeader = report.createListBandContent();
        list.getChildren().add(listHeader);
        ILabelContent headerLabel = this.createBlockLabel(report);
        listHeader.getChildren().add(headerLabel);
        IListGroupContent group1 = report.createListGroupContent();
        list.getChildren().add(group1);
        IListBandContent groupHeader = report.createListBandContent();
        group1.getChildren().add(groupHeader);
        ILabelContent groupHeaderLabel = this.createBlockLabel(report);
        groupHeader.getChildren().add(groupHeaderLabel);
        IListBandContent detail = report.createListBandContent();
        group1.getChildren().add(detail);
        ILabelContent detailLabel = this.createBlockLabel(report);
        detail.getChildren().add(detailLabel);
        IListBandContent listFooter = report.createListBandContent();
        list.getChildren().add(listFooter);
        ILabelContent footerLabel = this.createBlockLabel(report);
        listFooter.getChildren().add(footerLabel);
        DOMReportItemExecutor executor = new DOMReportItemExecutor((IContent)list);
        ListContainerExecutor listExecutor = new ListContainerExecutor(executor.execute(), (IReportItemExecutor)executor);
        ListContainerExecutorTest.assertTrue((boolean)listExecutor.hasNextChild());
        IReportItemExecutor child = listExecutor.getNextChild();
        ListContainerExecutorTest.assertTrue((child.execute() == headerLabel ? 1 : 0) != 0);
        ListContainerExecutorTest.assertTrue((boolean)listExecutor.hasNextChild());
        child = listExecutor.getNextChild();
        ListContainerExecutorTest.assertTrue((child.execute() == group1 ? 1 : 0) != 0);
        ListContainerExecutorTest.assertTrue((boolean)child.hasNextChild());
        child = new ListContainerExecutor((IContent)group1, child);
        ListContainerExecutorTest.assertTrue((boolean)child.hasNextChild());
        ListContainerExecutorTest.assertTrue((child.getNextChild().execute() == groupHeaderLabel ? 1 : 0) != 0);
        ListContainerExecutorTest.assertTrue((boolean)child.hasNextChild());
        ListContainerExecutorTest.assertTrue((child.getNextChild().execute() == detailLabel ? 1 : 0) != 0);
        ListContainerExecutorTest.assertFalse((boolean)child.hasNextChild());
        ListContainerExecutorTest.assertTrue((boolean)listExecutor.hasNextChild());
        child = listExecutor.getNextChild();
        ListContainerExecutorTest.assertTrue((child.execute() == footerLabel ? 1 : 0) != 0);
        ListContainerExecutorTest.assertFalse((boolean)listExecutor.hasNextChild());
    }

    protected ILabelContent createBlockLabel(IReportContent report) {
        ILabelContent label = report.createLabelContent();
        label.getStyle().setDisplay("block");
        return label;
    }

    protected ILabelContent createInlineLabel(IReportContent report) {
        ILabelContent label = report.createLabelContent();
        label.getStyle().setDisplay("inline");
        return label;
    }
}

