/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.util.PrimitiveDiskArray;
import org.junit.Assert;
import org.junit.Test;

public class PrimaryDiskArrayTest {
    @Test
    public void testInteger() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Integer(i));
            ++i;
        }
        Assert.assertEquals((long)array.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)array.get(i), (Object)new Integer(i));
            ++i;
        }
        array.close();
    }

    @Test
    public void testDouble() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Double(i));
            ++i;
        }
        Assert.assertEquals((long)array.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)array.get(i), (Object)new Double(i));
            ++i;
        }
        array.close();
    }

    @Test
    public void testBoolean() throws IOException {
        int objectNumber = 1001;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                array.add((Object)new Boolean(false));
            } else {
                array.add((Object)new Boolean(true));
            }
            ++i;
        }
        Assert.assertEquals((long)array.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            if (i % 2 == 0) {
                Assert.assertEquals((Object)array.get(i), (Object)new Boolean(false));
            } else {
                Assert.assertEquals((Object)array.get(i), (Object)new Boolean(true));
            }
            ++i;
        }
        array.close();
    }

    @Test
    public void testString() throws IOException {
        int objectNumber = 200;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)("string" + i));
            ++i;
        }
        Assert.assertEquals((long)array.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)array.get(i), (Object)("string" + i));
            ++i;
        }
        array.close();
    }

    @Test
    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        Assert.assertEquals((long)array.size(), (long)objectNumber);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)array.get(i), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        array.close();
    }

    @Test
    public void testDate() throws IOException {
        int objectNumber = 4101;
        PrimitiveDiskArray array = new PrimitiveDiskArray();
        int i = 0;
        while (i < objectNumber) {
            array.add((Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)array.get(i), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        array.close();
    }
}

