/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.dimension;

import java.io.IOException;
import java.sql.Date;
import java.sql.Time;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.DimLevel;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.ISelection;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.SelectionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset1;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset2;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dataset3;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Level;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IndexKey;
import org.junit.Assert;
import org.junit.Test;

public class DimensionTest2 {
    private DimLevel dimLevel12;
    private DimLevel dimLevel11;

    @Test
    public void testDimensionCreateAndFind() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind(documentManager);
        documentManager.close();
    }

    private void testDimensionCreateAndFind(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Member levelMember;
        IndexKey indexKey;
        Dimension dimension = this.createDimension(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        IDiskArray indexKeys = dimension.find((Level)level[0], new Object[]{new Integer(1)});
        Assert.assertEquals((long)indexKeys.size(), (long)1L);
        int i = 0;
        while (i < indexKeys.size()) {
            indexKey = (IndexKey)indexKeys.get(i);
            Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
            Assert.assertEquals((long)indexKey.getDimensionPos()[0], (long)i);
            levelMember = dimension.getRowByPosition(indexKey.getDimensionPos()[0]).getMembers()[0];
            Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[0];
            Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            ++i;
        }
        dimension = (Dimension)DimensionFactory.loadDimension((String)"student", (IDocumentManager)documentManager);
        indexKeys = dimension.find((Level)level[1], new Object[]{new Integer(1)});
        Assert.assertEquals((long)indexKeys.size(), (long)1L);
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        Assert.assertEquals((long)indexKey.getDimensionPos()[0], (long)0L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        Assert.assertEquals((long)indexKey.getDimensionPos()[1], (long)1L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        Assert.assertEquals((long)indexKey.getDimensionPos()[2], (long)4L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
        Assert.assertEquals((long)indexKey.getDimensionPos()[3], (long)5L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[3]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
    }

    private void testDimensionCreateAndFind2(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Member levelMember;
        IndexKey indexKey;
        Dimension dimension = this.createDimension2(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        IDiskArray indexKeys = dimension.find((Level)level[0], new Object[]{new Integer(1)});
        Assert.assertEquals((long)indexKeys.size(), (long)1L);
        int i = 0;
        while (i < indexKeys.size()) {
            indexKey = (IndexKey)indexKeys.get(i);
            Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Integer(1));
            Assert.assertEquals((long)indexKey.getDimensionPos()[0], (long)i);
            levelMember = dimension.getRowByPosition(indexKey.getDimensionPos()[0]).getMembers()[0];
            Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[0];
            Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Integer(1));
            ++i;
        }
        dimension = (Dimension)DimensionFactory.loadDimension((String)"dataset2", (IDocumentManager)documentManager);
        indexKeys = dimension.find((Level)level[1], new Object[]{new Date(1L)});
        Assert.assertEquals((long)indexKeys.size(), (long)1L);
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        Assert.assertEquals((long)indexKey.getDimensionPos()[0], (long)0L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        Assert.assertEquals((long)indexKey.getDimensionPos()[1], (long)1L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        Assert.assertEquals((long)indexKey.getDimensionPos()[2], (long)4L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[0]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        indexKey = (IndexKey)indexKeys.get(0);
        Assert.assertEquals((Object)indexKey.getKey()[0], (Object)new Date(1L));
        Assert.assertEquals((long)indexKey.getDimensionPos()[3], (long)5L);
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[3]).getMembers()[1];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Date(1L));
        levelMember = dimension.getDimensionRowByOffset(indexKey.getOffset()[3]).getMembers()[2];
        Assert.assertEquals((Object)levelMember.getKeyValues()[0], (Object)new Time(6L));
    }

    @Test
    public void testDimensionCreateAndFind2() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionCreateAndFind2(documentManager);
        documentManager.close();
    }

    @Test
    public void testDimensionCreateAndFind3() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        try {
            this.testDimensionCreateAndFind3(documentManager);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        documentManager.close();
    }

    private void testDimensionCreateAndFind3(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        this.createDimension3(documentManager);
    }

    @Test
    public void testDimensionIterator() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testDimensionIterator(documentManager);
        documentManager.close();
    }

    private void testDimensionIterator(IDocumentManager documentManager) throws IOException, BirtException, DataException {
        Dimension dimension = this.createDimension(documentManager);
        ILevel[] level = dimension.getHierarchy().getLevels();
        ISelection[][] filter = new ISelection[1][1];
        filter[0][0] = SelectionFactory.createRangeSelection((Object[])new Object[]{new Integer(1)}, (Object[])new Object[]{new Integer(2)}, (boolean)true, (boolean)false);
        Level[] findLevel = new Level[]{(Level)level[1]};
        IDiskArray positionArray = dimension.find(findLevel, filter);
        Assert.assertEquals((long)positionArray.size(), (long)4L);
        DimensionResultIterator dimesionResultSet = new DimensionResultIterator(dimension, positionArray, new StopSign());
        this.dimLevel11 = new DimLevel(dimension.getName(), "l1");
        this.dimLevel12 = new DimLevel(dimension.getName(), "l2");
        Assert.assertEquals((long)dimesionResultSet.getLevelIndex(this.dimLevel12.getLevelName()), (long)1L);
        Assert.assertEquals((long)dimesionResultSet.getLevelIndex(this.dimLevel11.getLevelName()), (long)0L);
        Assert.assertEquals((long)dimesionResultSet.getLevelKeyDataType(this.dimLevel12.getLevelName())[0], (long)2L);
        Assert.assertEquals((long)dimesionResultSet.getLevelKeyDataType(this.dimLevel11.getLevelName())[0], (long)2L);
        Assert.assertEquals((long)dimesionResultSet.length(), (long)4L);
        dimesionResultSet.seek(0);
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(1));
        dimesionResultSet.seek(1);
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(2));
        dimesionResultSet.seek(2);
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(5));
        dimesionResultSet.seek(3);
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(0)[0], (Object)new Integer(2));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(1)[0], (Object)new Integer(1));
        Assert.assertEquals((Object)dimesionResultSet.getLevelKeyValue(2)[0], (Object)new Integer(6));
    }

    private Dimension createDimension(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"student", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset1(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        Assert.assertEquals((Object)dimension.isTime(), (Object)false);
        IHierarchy hierarchy = dimension.getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"student");
        ILevel[] level = hierarchy.getLevels();
        Assert.assertEquals((Object)level[0].getName(), (Object)"l1");
        Assert.assertEquals((Object)level[1].getName(), (Object)"l2");
        Assert.assertEquals((Object)level[2].getName(), (Object)"l3");
        return (Dimension)dimension;
    }

    private Dimension createDimension2(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"dataset2", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset2(), (ILevelDefn[])levelDefs, (boolean)true, (StopSign)new StopSign());
        Assert.assertEquals((Object)dimension.isTime(), (Object)true);
        IHierarchy hierarchy = dimension.getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dataset2");
        ILevel[] level = hierarchy.getLevels();
        Assert.assertEquals((Object)level[0].getName(), (Object)"l1");
        Assert.assertEquals((Object)level[1].getName(), (Object)"l2");
        Assert.assertEquals((Object)level[2].getName(), (Object)"l3");
        return (Dimension)dimension;
    }

    private Dimension createDimension3(IDocumentManager documentManager) throws IOException, BirtException {
        ILevelDefn[] levelDefs = new ILevelDefn[]{new LevelDefinition("l1", new String[]{"l1"}, null), new LevelDefinition("l2", new String[]{"l2"}, null), new LevelDefinition("l3", new String[]{"l3"}, null)};
        IDimension dimension = DimensionFactory.createDimension((String)"dataset3", (IDocumentManager)documentManager, (IDatasetIterator)new Dataset3(), (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        Assert.assertEquals((Object)dimension.isTime(), (Object)false);
        IHierarchy hierarchy = dimension.getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dataset3");
        ILevel[] level = hierarchy.getLevels();
        Assert.assertEquals((Object)level[0].getName(), (Object)"l1");
        Assert.assertEquals((Object)level[1].getName(), (Object)"l2");
        Assert.assertEquals((Object)level[2].getName(), (Object)"l3");
        return (Dimension)dimension;
    }
}

