/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Set;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.birt.data.engine.impl.ICancellable;

public class CancelManager
extends TimerTask {
    private final Set<ICancellable> cancellables = ConcurrentHashMap.newKeySet();

    public void register(ICancellable cancellable) {
        this.cancellables.add(cancellable);
    }

    public void deregister(ICancellable cancellable) {
        this.cancellables.remove(cancellable);
    }

    @Override
    public void run() {
        this.doCancel();
    }

    public void doCancel() {
        ICancellable[] iCancellableArray = (ICancellable[])this.cancellables.toArray(ICancellable[]::new);
        int n = iCancellableArray.length;
        int n2 = 0;
        while (n2 < n) {
            ICancellable cancellable = iCancellableArray[n2];
            if (cancellable.doCancel()) {
                cancellable.cancel();
            }
            ++n2;
        }
    }
}

