/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.pdf;

import com.ibm.icu.util.ULocale;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfICCBased;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfStructureElement;
import com.lowagie.text.pdf.PdfStructureTreeRoot;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.xml.xmp.DublinCoreSchema;
import com.lowagie.text.xml.xmp.LangAlt;
import com.lowagie.text.xml.xmp.PdfA1Schema;
import com.lowagie.text.xml.xmp.PdfSchema;
import com.lowagie.text.xml.xmp.XmpBasicSchema;
import com.lowagie.text.xml.xmp.XmpSchema;
import com.lowagie.text.xml.xmp.XmpWriter;
import java.awt.Color;
import java.awt.color.ICC_Profile;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.ITOCTree;
import org.eclipse.birt.report.engine.api.TOCNode;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.emitter.pdf.PDFPage;
import org.eclipse.birt.report.engine.emitter.pdf.PdfNames;
import org.eclipse.birt.report.engine.emitter.pdf.TOCHandler;
import org.eclipse.birt.report.engine.i18n.EngineResourceHandle;
import org.eclipse.birt.report.engine.internal.util.BundleVersionUtil;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.layout.emitter.IPage;
import org.eclipse.birt.report.engine.layout.emitter.IPageDevice;
import org.eclipse.birt.report.engine.nLayout.area.IArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;

public class PDFPageDevice
implements IPageDevice {
    private static final String PDF_VERSION_1_3 = "1.3";
    private static final String PDF_VERSION_1_4 = "1.4";
    private static final String PDF_VERSION_1_5 = "1.5";
    private static final String PDF_VERSION_1_6 = "1.6";
    private static final String PDF_VERSION_1_7 = "1.7";
    private static final String PDF_VERSION_2_0 = "2.0";
    private static final String PDF_CONFORMANCE_STANDARD = "PDF.Standard";
    private static final String PDF_CONFORMANCE_X32002 = "PDF.X32002";
    private static final String PDF_CONFORMANCE_A1A = "PDF.A1A";
    private static final String PDF_CONFORMANCE_A1B = "PDF.A1B";
    private static final String PDF_CONFORMANCE_A2A = "PDF.A2A";
    private static final String PDF_CONFORMANCE_A2B = "PDF.A2B";
    private static final String PDF_CONFORMANCE_A3A = "PDF.A3A";
    private static final String PDF_CONFORMANCE_A3B = "PDF.A3B";
    private static final String PDF_CONFORMANCE_A3U = "PDF.A3U";
    private static final String PDF_CONFORMANCE_A4F = "PDF.A4F";
    private static final String PDF_UA_CONFORMANCE_1 = "PDF.UA-1";
    private static final String PDF_UA_CONFORMANCE_2 = "PDF.UA-2";
    private static final String PDF_UA_CONFORMANCE_NONE = "none";
    private static final String PDF_ICC_PROFILE_DEFAULT = "sRGB IEC61966-2.1";
    private static final String PDF_ICC_COLOR_RGB = "RGB";
    private static final String PDF_ICC_COLOR_CMYK = "CMYK";
    protected Document doc;
    protected PdfWriter writer;
    PdfStructureTreeRoot structureRoot;
    PdfStructureElement structureDocument;
    PdfStructureElement structureCurrentNode;
    protected IReportContext context;
    protected IReportContent report;
    protected static Logger logger = Logger.getLogger(PDFPageDevice.class.getName());
    protected PDFPage currentPage;
    protected HashMap<Float, PdfTemplate> templateMap;
    protected HashMap<String, PdfTemplate> imageCache;
    protected static String[] versionInfo = new String[]{BundleVersionUtil.getBundleVersion((String)"org.eclipse.birt.report.engine")};
    protected static final int MAX_PAGE_WIDTH = 14400000;
    protected static final int MAX_PAGE_HEIGHT = 14400000;
    private static final String PDF_PREPEND_DOCUMENTS = "PdfEmitter.PrependDocumentList";
    private static final String PREPEND_PROPERTY_NAME = "PrependList";
    private static final String PDF_APPEND_DOCUMENTS = "PdfEmitter.AppendDocumentList";
    private static final String APPEND_PROPERTY_NAME = "AppendList";
    private static final String PDF_VERSION = "PdfEmitter.Version";
    private static final String PDF_CONFORMANCE = "PdfEmitter.Conformance";
    private static final String PDF_UA_CONFORMANCE = "PdfEmitter.PDFUAConformance";
    private static final String PDF_ICC_PROFILE_EXTERNAL_FILE = "PdfEmitter.IccProfileFile";
    private static final String PDF_ICC_COLOR_TYPE = "PdfEmitter.IccColorType";
    private static final String PDFA_ADD_DOCUMENT_TITLE = "PdfEmitter.PDFA.AddDocumentTitle";
    private static final String PDFA_FALLBACK_FONT = "PdfEmitter.PDFA.FallbackFont";
    private static final String PDF_FONT_CID_SET = "PdfEmitter.IncludeCidSet";
    private static final String PDF_BACKGROUND_IMAGE_SVG_TO_RASTER = "PdfEmitter.BackGroundImageSvgToRaster";
    protected Map<String, Expression> userProperties;
    private char pdfVersion;
    private int pdfConformance;
    private int pdfUAConformance;
    private boolean isPdfAFormat;
    private boolean isPdfUAFormat;
    private boolean addPdfADocumentTitle;
    private String defaultFontPdfA;
    private boolean includeFontCidSet;
    private boolean useBackgroundImageSvg;
    private static final int PDFA2A = 5;
    private static final int PDFA2B = 6;
    private static final int PDFA3A = 7;
    private static final int PDFA3B = 8;
    private static final int PDFA3U = 9;
    private static final int PDFA4F = 10;

    public PDFPageDevice(OutputStream output, String title, String author, String subject, String description, IReportContext context, IReportContent report) {
        block22: {
            this.doc = null;
            this.writer = null;
            this.structureRoot = null;
            this.structureDocument = null;
            this.structureCurrentNode = null;
            this.currentPage = null;
            this.templateMap = new HashMap();
            this.imageCache = new HashMap();
            this.pdfVersion = (char)48;
            this.pdfConformance = 0;
            this.pdfUAConformance = 0;
            this.isPdfAFormat = false;
            this.isPdfUAFormat = false;
            this.addPdfADocumentTitle = false;
            this.defaultFontPdfA = null;
            this.includeFontCidSet = true;
            this.useBackgroundImageSvg = true;
            this.context = context;
            this.report = report;
            this.doc = new Document();
            try {
                String list;
                this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
                EngineResourceHandle handle = new EngineResourceHandle(ULocale.forLocale((Locale)context.getLocale()));
                this.userProperties = report.getDesign().getUserProperties();
                this.setPdfVersion();
                this.setPdfConformance();
                this.setPdfUAConformance();
                this.setDefaultFontPdfA();
                this.setIncludeCidSet();
                this.useBackgroundImageSvgToRasterImage();
                if (!this.isPdfAFormat) {
                    this.writer.setFullCompression();
                    this.writer.setRgbTransparencyBlending(true);
                }
                String creator = handle.getMessage("PDFCreator", (Object[])versionInfo);
                this.doc.addCreator(creator);
                if (author != null) {
                    this.doc.addAuthor(author);
                }
                if ((!this.isPdfAFormat || this.addPdfADocumentTitle) && title != null) {
                    this.doc.addTitle(title);
                }
                if (subject != null) {
                    this.doc.addSubject(subject);
                    this.doc.addKeywords(subject);
                }
                if (description != null) {
                    this.doc.addHeader("Description", description);
                }
                if (this.isPdfUAFormat) {
                    String localeString = report.getDesign().getLocale();
                    if (localeString == null || localeString.isEmpty()) {
                        throw new BirtException("The report needs a locale property for PDF/UA!");
                    }
                    Locale locale = new Locale(localeString);
                    String language = locale.toString();
                    language = language.replace('_', '-');
                    this.doc.setDocumentLanguage(language);
                    PdfDictionary extraCatalog = this.writer.getExtraCatalog();
                    extraCatalog.put(PdfName.LANG, (PdfObject)new PdfString(language, "UnicodeBig"));
                    this.writer.addViewerPreference(PdfName.DISPLAYDOCTITLE, (PdfObject)PdfBoolean.PDFTRUE);
                }
                ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
                Expression listObject = this.userProperties != null && this.userProperties.containsKey(PREPEND_PROPERTY_NAME) ? this.userProperties.get(PREPEND_PROPERTY_NAME) : (this.userProperties != null && this.userProperties.containsKey(PDF_PREPEND_DOCUMENTS) ? this.userProperties.get(PDF_PREPEND_DOCUMENTS) : Expression.newConstant((int)-1, (String)((String)this.getReportDesignConfiguration(this.report, PDF_PREPEND_DOCUMENTS))));
                if (listObject == null) break block22;
                Expression exp = listObject;
                Object result = context.evaluate(exp);
                if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                    String[] stringArray = list.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        try {
                            String fileName = s.trim().replace("\\", "\\\\");
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                            } else {
                                URL url = context.getResource(fileName);
                                BufferedInputStream is = new BufferedInputStream(url.openStream());
                                pdfs.add(is);
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                        ++n2;
                    }
                }
                if (result instanceof ArrayList) {
                    ArrayList pdfList = (ArrayList)result;
                    for (String fileName : pdfList) {
                        fileName = fileName.replace("\\", "\\\\");
                        try {
                            File f = new File(fileName);
                            if (f.exists()) {
                                FileInputStream fis = new FileInputStream(f);
                                pdfs.add(fis);
                                continue;
                            }
                            URL url = context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                if (pdfs.size() > 0) {
                    if (!this.doc.isOpen()) {
                        this.doc.open();
                    }
                    this.concatPDFs(pdfs, false);
                }
            }
            catch (DocumentException | BirtException be) {
                logger.log(Level.SEVERE, be.getMessage(), be);
            }
        }
    }

    public void initStructure() {
        this.structureRoot = this.writer.getStructureTreeRoot();
        this.structureCurrentNode = this.structureDocument = new PdfStructureElement(this.structureRoot, new PdfName("Document"));
    }

    public PDFPageDevice(OutputStream output) {
        this.doc = null;
        this.writer = null;
        this.structureRoot = null;
        this.structureDocument = null;
        this.structureCurrentNode = null;
        this.currentPage = null;
        this.templateMap = new HashMap();
        this.imageCache = new HashMap();
        this.pdfVersion = (char)48;
        this.pdfConformance = 0;
        this.pdfUAConformance = 0;
        this.isPdfAFormat = false;
        this.isPdfUAFormat = false;
        this.addPdfADocumentTitle = false;
        this.defaultFontPdfA = null;
        this.includeFontCidSet = true;
        this.useBackgroundImageSvg = true;
        this.doc = new Document();
        try {
            this.writer = PdfWriter.getInstance((Document)this.doc, (OutputStream)new BufferedOutputStream(output));
        }
        catch (DocumentException de) {
            logger.log(Level.SEVERE, de.getMessage(), de);
        }
    }

    public void setPDFTemplate(Float key, PdfTemplate totalPageTemplate) {
        this.templateMap.put(key, totalPageTemplate);
    }

    public HashMap<Float, PdfTemplate> getTemplateMap() {
        return this.templateMap;
    }

    public PdfTemplate getPDFTemplate(Float key) {
        return this.templateMap.get(key);
    }

    public boolean hasTemplate(Float key) {
        return this.templateMap.containsKey(key);
    }

    public HashMap<String, PdfTemplate> getImageCache() {
        return this.imageCache;
    }

    public void close() throws Exception {
        if (!this.doc.isOpen()) {
            this.doc.open();
        }
        ArrayList<InputStream> pdfs = new ArrayList<InputStream>();
        Map userProperties = this.report.getDesign().getUserProperties();
        Object listObject = userProperties != null && userProperties.containsKey(APPEND_PROPERTY_NAME) ? userProperties.get(APPEND_PROPERTY_NAME) : (userProperties != null && userProperties.containsKey(PDF_APPEND_DOCUMENTS) ? userProperties.get(PDF_APPEND_DOCUMENTS) : Expression.newConstant((int)-1, (String)((String)this.getReportDesignConfiguration(this.report, PDF_APPEND_DOCUMENTS))));
        if (listObject != null) {
            String list;
            Expression exp = (Expression)listObject;
            Object result = this.context.evaluate(exp);
            if (result instanceof String && (list = (String)result) != null && list.length() > 0) {
                String[] stringArray = list.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String s = stringArray[n2];
                    try {
                        String fileName = s.trim().replace("\\", "\\\\");
                        File f = new File(fileName);
                        if (f.exists()) {
                            FileInputStream fis = new FileInputStream(f);
                            pdfs.add(fis);
                        } else {
                            URL url = this.context.getResource(fileName);
                            BufferedInputStream is = new BufferedInputStream(url.openStream());
                            pdfs.add(is);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                    ++n2;
                }
            }
            if (result instanceof ArrayList) {
                ArrayList pdfList = (ArrayList)result;
                for (String fileName : pdfList) {
                    fileName = fileName.replace("\\", "\\\\");
                    try {
                        File f = new File(fileName);
                        if (f.exists()) {
                            FileInputStream fis = new FileInputStream(f);
                            pdfs.add(fis);
                            continue;
                        }
                        URL url = this.context.getResource(fileName);
                        BufferedInputStream is = new BufferedInputStream(url.openStream());
                        pdfs.add(is);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            if (pdfs.size() > 0) {
                this.concatPDFs(pdfs, false);
            }
        }
        if (this.isPdfAFormat || this.isPdfUAFormat) {
            this.setPdfIccXmp();
        }
        this.writer.setPageEmpty(false);
        if (this.isPdfUAFormat) {
            this.writer.setTabs(PdfName.S);
        }
        if (this.doc.isOpen()) {
            this.doc.close();
        }
    }

    public IPage newPage(int width, int height, Color backgroundColor) {
        int w = Math.min(width, 14400000);
        int h = Math.min(height, 14400000);
        this.currentPage = this.createPDFPage(w, h);
        this.currentPage.drawBackgroundColor(backgroundColor, 0, 0, w, h);
        return this.currentPage;
    }

    protected PDFPage createPDFPage(int pageWidth, int pageHeight) {
        return new PDFPage(pageWidth, pageHeight, this.doc, this.writer, this);
    }

    public void createTOC(Set<String> bookmarks) {
        if (!this.doc.isOpen()) {
            return;
        }
        if (bookmarks.isEmpty()) {
            this.writer.setViewerPreferences(64);
            return;
        }
        ULocale ulocale = null;
        Locale locale = this.context.getLocale();
        ulocale = locale == null ? ULocale.getDefault() : ULocale.forLocale((Locale)locale);
        ITOCTree tocTree = this.report.getTOCTree("pdf", ulocale);
        if (tocTree == null) {
            this.writer.setViewerPreferences(64);
        } else {
            TOCNode rootNode = tocTree.getRoot();
            if (rootNode == null || rootNode.getChildren().isEmpty()) {
                this.writer.setViewerPreferences(64);
            } else {
                this.writer.setViewerPreferences(128);
                TOCHandler tocHandler = new TOCHandler(rootNode, this.writer.getDirectContent().getRootOutline(), bookmarks);
                tocHandler.createTOC();
            }
        }
    }

    protected TOCHandler createTOCHandler(TOCNode root, PdfOutline outline, Set<String> bookmarks) {
        return new TOCHandler(root, outline, bookmarks);
    }

    public void concatPDFs(List<InputStream> streamOfPDFFiles, boolean paginate) {
        Document document = this.doc;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            int totalPages = 0;
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                int n = pdfReader.getNumberOfPages();
                totalPages += n;
            }
            PdfWriter writer = this.writer;
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)false);
            PdfContentByte cb = writer.getDirectContent();
            int currentPageNumber = 0;
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    ++currentPageNumber;
                    Rectangle sourcePageSize = pdfReader.getPageSize(++pageOfCurrentReaderPDF);
                    document.setPageSize(sourcePageSize);
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                    if (!paginate) continue;
                    cb.beginText();
                    cb.setFontAndSize(bf, 9.0f);
                    cb.showTextAligned(1, currentPageNumber + " of " + totalPages, 520.0f, 5.0f, 0.0f);
                    cb.endText();
                }
                pageOfCurrentReaderPDF = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setPdfVersion() throws BirtException {
        String userPdfVersion = this.userProperties != null && this.userProperties.containsKey(PDF_VERSION) ? this.userProperties.get(PDF_VERSION).toString() : (String)this.getReportDesignConfiguration(this.report, PDF_VERSION);
        this.setPdfVersion(userPdfVersion);
    }

    public void setPdfVersion(String version) throws BirtException {
        switch (version) {
            case "1.3": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.4": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.5": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.6": {
                this.pdfVersion = (char)51;
                break;
            }
            case "1.7": {
                this.pdfVersion = (char)55;
                break;
            }
            case "2.0": {
                throw new BirtException("OpenPDF does not yet support creation of PDF 2.0");
            }
        }
        if (this.pdfVersion != '0') {
            this.writer.setAtLeastPdfVersion(this.pdfVersion);
        }
    }

    private void setPdfUAConformance() {
        String userPdfUAConformance = this.userProperties != null && this.userProperties.containsKey(PDF_UA_CONFORMANCE) ? this.userProperties.get(PDF_UA_CONFORMANCE).toString().toUpperCase() : (String)this.getReportDesignConfiguration(this.report, PDF_UA_CONFORMANCE);
        this.setPdfUAConformance(userPdfUAConformance);
    }

    public void setPdfUAConformance(String conformance) {
        switch (conformance) {
            case "PDF.UA-1": {
                this.pdfUAConformance = 1;
                this.isPdfUAFormat = true;
                this.writer.setTagged();
                break;
            }
            case "PDF.UA-2": {
                this.pdfUAConformance = 2;
                this.isPdfUAFormat = true;
                this.writer.setTagged();
            }
        }
    }

    public String getPdfUAConformance() {
        switch (this.pdfUAConformance) {
            case 1: {
                return PDF_UA_CONFORMANCE_1;
            }
            case 2: {
                return PDF_UA_CONFORMANCE_2;
            }
        }
        return PDF_UA_CONFORMANCE_NONE;
    }

    public String getPdfVersion() {
        switch (this.pdfVersion) {
            case '3': {
                return PDF_VERSION_1_3;
            }
            case '4': {
                return PDF_VERSION_1_4;
            }
            case '5': {
                return PDF_VERSION_1_5;
            }
            case '6': {
                return PDF_VERSION_1_6;
            }
            case '7': {
                return PDF_VERSION_1_7;
            }
        }
        return PDF_VERSION_1_5;
    }

    private void setPdfConformance() {
        String userPdfConformance = this.userProperties != null && this.userProperties.containsKey(PDF_CONFORMANCE) ? this.userProperties.get(PDF_CONFORMANCE).toString().toUpperCase() : (String)this.getReportDesignConfiguration(this.report, PDF_CONFORMANCE);
        switch (userPdfConformance) {
            case "PDF.X32002": {
                this.pdfConformance = 2;
                this.isPdfAFormat = false;
                break;
            }
            case "PDF.A1A": {
                this.pdfConformance = 3;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A1B": {
                this.pdfConformance = 4;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A2A": {
                this.pdfConformance = 5;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A2B": {
                this.pdfConformance = 6;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A3A": {
                this.pdfConformance = 7;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A3B": {
                this.pdfConformance = 8;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A3U": {
                this.pdfConformance = 9;
                this.isPdfAFormat = true;
                break;
            }
            case "PDF.A4F": {
                this.pdfConformance = 10;
                this.isPdfAFormat = true;
                break;
            }
            default: {
                this.pdfConformance = 0;
                this.isPdfAFormat = false;
            }
        }
        this.setPdfConformance(this.pdfConformance);
        this.addPdfADocumentTitle = this.userProperties != null && this.userProperties.containsKey(PDFA_ADD_DOCUMENT_TITLE) ? Boolean.parseBoolean(this.userProperties.get(PDFA_ADD_DOCUMENT_TITLE).toString()) : Boolean.parseBoolean((String)this.getReportDesignConfiguration(this.report, PDFA_ADD_DOCUMENT_TITLE));
    }

    public void setPdfConformance(int pdfConformance) {
        this.writer.setPDFXConformance(pdfConformance);
        switch (pdfConformance) {
            case 3: 
            case 5: 
            case 7: {
                this.writer.setTagged();
            }
        }
    }

    public String getPdfConformance() {
        switch (this.pdfConformance) {
            case 2: {
                return PDF_CONFORMANCE_X32002;
            }
            case 3: {
                return PDF_CONFORMANCE_A1A;
            }
            case 4: {
                return PDF_CONFORMANCE_A1B;
            }
            case 5: {
                return PDF_CONFORMANCE_A2A;
            }
            case 6: {
                return PDF_CONFORMANCE_A2B;
            }
            case 7: {
                return PDF_CONFORMANCE_A3A;
            }
            case 8: {
                return PDF_CONFORMANCE_A3B;
            }
            case 9: {
                return PDF_CONFORMANCE_A3U;
            }
            case 10: {
                return PDF_CONFORMANCE_A4F;
            }
        }
        return PDF_CONFORMANCE_STANDARD;
    }

    public boolean isPdfAFormat() {
        return this.isPdfAFormat;
    }

    public boolean isPDFUAFormat() {
        return this.isPdfUAFormat;
    }

    private byte[] createXmpMetadataBytes() {
        PdfDictionary info = this.writer.getInfo();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int PdfXConformance = this.writer.getPDFXConformance();
            XmpWriter xmp = new XmpWriter((OutputStream)baos, "UTF-8", 4);
            DublinCoreSchema dc = new DublinCoreSchema();
            PdfSchema p = new PdfSchema();
            XmpBasicSchema basic = new XmpBasicSchema();
            for (PdfName pdfName : info.getKeys()) {
                PdfName key = pdfName;
                PdfObject obj = info.get(key);
                if (obj == null) continue;
                if (PdfName.TITLE.equals((Object)key)) {
                    LangAlt langAlt = new LangAlt(((PdfString)obj).toUnicodeString());
                    dc.setProperty("dc:title", langAlt);
                }
                if (PdfName.AUTHOR.equals((Object)key)) {
                    dc.addAuthor(((PdfString)obj).toUnicodeString());
                }
                if (PdfName.SUBJECT.equals((Object)key)) {
                    dc.addSubject(((PdfString)obj).toUnicodeString());
                    dc.addDescription(((PdfString)obj).toUnicodeString());
                }
                if (PdfName.KEYWORDS.equals((Object)key)) {
                    p.addKeywords(((PdfString)obj).toUnicodeString());
                }
                if (PdfName.CREATOR.equals((Object)key)) {
                    basic.addCreatorTool(((PdfString)obj).toUnicodeString());
                }
                if (PdfName.PRODUCER.equals((Object)key)) {
                    p.addProducer(((PdfString)obj).toUnicodeString());
                }
                if (PdfName.CREATIONDATE.equals((Object)key)) {
                    basic.addCreateDate(((PdfDate)obj).getW3CDate());
                }
                if (!PdfName.MODDATE.equals((Object)key)) continue;
                basic.addModDate(((PdfDate)obj).getW3CDate());
            }
            if (dc.size() > 0) {
                xmp.addRdfDescription((XmpSchema)dc);
            }
            if (p.size() > 0) {
                xmp.addRdfDescription((XmpSchema)p);
            }
            if (basic.size() > 0) {
                xmp.addRdfDescription((XmpSchema)basic);
            }
            if (this.isPDFUAFormat()) {
                PDFUASchema ua = new PDFUASchema();
                ua.addPdfUAId(this.pdfUAConformance);
                xmp.addRdfDescription((XmpSchema)ua);
            }
            if (this.isPdfAFormat) {
                if (this.isPDFUAFormat()) {
                    PDFAExtensionSchema pdfaext = new PDFAExtensionSchema();
                    xmp.addRdfDescription((XmpSchema)pdfaext);
                }
                PdfA1Schema a1 = new PdfA1Schema();
                switch (PdfXConformance) {
                    case 3: 
                    case 4: {
                        a1.addPart("1");
                        break;
                    }
                    case 5: 
                    case 6: {
                        a1.addPart("2");
                        break;
                    }
                    case 7: 
                    case 8: 
                    case 9: {
                        a1.addPart("3");
                        break;
                    }
                    case 10: {
                        a1.addPart("4");
                    }
                }
                switch (PdfXConformance) {
                    case 3: 
                    case 5: 
                    case 7: {
                        a1.addConformance("A");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 8: {
                        a1.addConformance("B");
                        break;
                    }
                    case 10: {
                        a1.addConformance("F");
                    }
                }
                xmp.addRdfDescription((XmpSchema)a1);
            }
            xmp.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return baos.toByteArray();
    }

    private void setPdfIccXmp() {
        try {
            PdfDictionary outi = new PdfDictionary(PdfName.OUTPUTINTENT);
            outi.put(PdfName.OUTPUTCONDITIONIDENTIFIER, (PdfObject)new PdfString(PDF_ICC_PROFILE_DEFAULT));
            outi.put(PdfName.INFO, (PdfObject)new PdfString(PDF_ICC_PROFILE_DEFAULT));
            outi.put(PdfName.S, (PdfObject)PdfName.GTS_PDFA1);
            boolean iccProfileExternal = false;
            ICC_Profile iccProfile = null;
            File iccFile = null;
            String fullFileNameIcc = "";
            fullFileNameIcc = this.userProperties != null && this.userProperties.containsKey(PDF_ICC_PROFILE_EXTERNAL_FILE) ? this.userProperties.get(PDF_ICC_PROFILE_EXTERNAL_FILE).toString() : (String)this.getReportDesignConfiguration(this.report, PDF_ICC_PROFILE_EXTERNAL_FILE);
            if (fullFileNameIcc != null) {
                fullFileNameIcc = fullFileNameIcc.trim();
            }
            if (fullFileNameIcc != null && fullFileNameIcc.length() > 0) {
                try {
                    iccFile = new File(fullFileNameIcc);
                    if (!iccFile.exists()) {
                        URL url = this.context.getResource(fullFileNameIcc);
                        iccFile = new File(url.toURI());
                    }
                    iccProfileExternal = true;
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            int colorSpace = 1000;
            String iccColorType = PDF_ICC_COLOR_RGB;
            iccColorType = this.userProperties != null && this.userProperties.containsKey(PDF_ICC_COLOR_TYPE) ? this.userProperties.get(PDF_ICC_COLOR_TYPE).toString().toUpperCase().trim() : (String)this.getReportDesignConfiguration(this.report, PDF_ICC_COLOR_TYPE);
            if (iccColorType.equals(PDF_ICC_COLOR_CMYK)) {
                colorSpace = 9;
            }
            iccProfile = iccProfileExternal ? ICC_Profile.getInstance(iccFile.getAbsolutePath()) : ICC_Profile.getInstance(colorSpace);
            PdfICCBased iccPdf = new PdfICCBased(iccProfile);
            iccPdf.remove(PdfName.ALTERNATE);
            outi.put(PdfName.DESTOUTPUTPROFILE, (PdfObject)this.writer.addToBody((PdfObject)iccPdf).getIndirectReference());
            this.writer.getExtraCatalog().put(PdfName.OUTPUTINTENTS, (PdfObject)new PdfArray((PdfObject)outi));
        }
        catch (Exception icce) {
            logger.log(Level.WARNING, icce.getMessage(), icce);
        }
        try {
            byte[] xmpMetadata = this.createXmpMetadataBytes();
            this.writer.setXmpMetadata(xmpMetadata);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void setDefaultFontPdfA() {
        this.defaultFontPdfA = this.userProperties != null && this.userProperties.containsKey(PDFA_FALLBACK_FONT) ? this.userProperties.get(PDFA_FALLBACK_FONT).toString() : (String)this.getReportDesignConfiguration(this.report, PDFA_FALLBACK_FONT);
    }

    public void setDefaultFontPdfA(String defaultFont) {
        this.defaultFontPdfA = defaultFont.replace("\\", "\\\\");
    }

    public String getDefaultFontPdfA() {
        return this.defaultFontPdfA;
    }

    private void setIncludeCidSet() {
        this.includeFontCidSet = this.userProperties != null && this.userProperties.containsKey(PDF_FONT_CID_SET) ? Boolean.parseBoolean(this.userProperties.get(PDF_FONT_CID_SET).toString()) : Boolean.parseBoolean((String)this.getReportDesignConfiguration(this.report, PDF_FONT_CID_SET));
    }

    private void useBackgroundImageSvgToRasterImage() {
        if (this.userProperties != null && this.userProperties.containsKey(PDF_BACKGROUND_IMAGE_SVG_TO_RASTER)) {
            this.useBackgroundImageSvg = !Boolean.parseBoolean(this.userProperties.get(PDF_BACKGROUND_IMAGE_SVG_TO_RASTER).toString());
        }
    }

    public boolean useBackgroundImageSvg() {
        return this.useBackgroundImageSvg;
    }

    public void setIncludeCidSet(boolean includeFontCidSet) {
        this.includeFontCidSet = includeFontCidSet;
    }

    public boolean isIncludeCidSet() {
        return this.includeFontCidSet;
    }

    private Object getReportDesignConfiguration(IReportContent reportContent, String name) {
        String value = null;
        if (name.equalsIgnoreCase(PDF_VERSION)) {
            value = reportContent.getDesign().getReportDesign().getPdfVersion();
        } else if (name.equalsIgnoreCase(PDF_CONFORMANCE)) {
            value = reportContent.getDesign().getReportDesign().getPdfConformance();
        } else if (name.equalsIgnoreCase(PDF_UA_CONFORMANCE)) {
            value = reportContent.getDesign().getReportDesign().getPdfUAConformance();
        } else if (name.equalsIgnoreCase(PDF_ICC_COLOR_TYPE)) {
            value = reportContent.getDesign().getReportDesign().getPdfIccColorType();
        } else if (name.equalsIgnoreCase(PDF_ICC_PROFILE_EXTERNAL_FILE)) {
            value = reportContent.getDesign().getReportDesign().getPdfIccColorProfileExternal();
        } else if (name.equalsIgnoreCase(PDF_PREPEND_DOCUMENTS)) {
            value = reportContent.getDesign().getReportDesign().getPdfDocumentsPrepend();
        } else if (name.equalsIgnoreCase(PDF_APPEND_DOCUMENTS)) {
            value = reportContent.getDesign().getReportDesign().getPdfDocumentsAppend();
        } else if (name.equalsIgnoreCase(PDFA_FALLBACK_FONT)) {
            value = reportContent.getDesign().getReportDesign().getPdfAFontFallback();
        } else if (name.equalsIgnoreCase(PDF_FONT_CID_SET)) {
            value = reportContent.getDesign().getReportDesign().getPdfFontCidEmbed();
        } else if (name.equalsIgnoreCase(PDFA_ADD_DOCUMENT_TITLE)) {
            value = reportContent.getDesign().getReportDesign().getPdfAEmbedTitle();
        }
        return value;
    }

    public void openTag(String tagType, IArea area) {
        if (!this.writer.isTagged() || tagType == null) {
            return;
        }
        PdfDictionary properties = null;
        switch (tagType) {
            case "auto": {
                System.err.println("TODO: auto TagType found for area: " + String.valueOf(area));
                break;
            }
            case "pageHeader": {
                properties = new PdfDictionary();
                properties.put(PdfNames.TYPE, (PdfObject)PdfNames.PAGINATION);
                properties.put(PdfNames.SUBTYPE, (PdfObject)PdfNames.HEADER);
                this.currentPage.beginArtifact(properties);
                break;
            }
            case "pageFooter": {
                properties = new PdfDictionary();
                properties.put(PdfNames.TYPE, (PdfObject)PdfNames.PAGINATION);
                properties.put(PdfNames.SUBTYPE, (PdfObject)PdfNames.FOOTER);
                this.currentPage.beginArtifact(properties);
                break;
            }
            default: {
                if (area instanceof ContainerArea && ((ContainerArea)area).isArtifact()) {
                    properties = new PdfDictionary();
                    properties.put(PdfNames.TYPE, (PdfObject)PdfNames.PAGINATION);
                    this.currentPage.beginArtifact(properties);
                    break;
                }
                if (this.currentPage.isInArtifact()) break;
                if (area instanceof ContainerArea) {
                    ContainerArea container = (ContainerArea)area;
                    if (container.isFirstPart()) {
                        if ("TR".equals(tagType)) {
                            this.beforeOpenTableSectionTag(container);
                        }
                        this.structureCurrentNode = new PdfStructureElement(this.structureCurrentNode, new PdfName(tagType));
                        try {
                            container.setStructureElement(this.structureCurrentNode);
                        }
                        catch (BirtException be) {
                            be.printStackTrace();
                            this.structureCurrentNode = new PdfStructureElement(this.structureCurrentNode, new PdfName(tagType));
                        }
                    } else {
                        PdfArray children;
                        this.structureCurrentNode = container.getFirstPart().getStructureElement();
                        PdfName restored = this.structureCurrentNode.getAsName(PdfName.S);
                        if (PdfName.TABLE.equals((Object)restored) && (children = this.structureCurrentNode.getAsArray(PdfName.K)) != null && children.size() > 0) {
                            this.structureCurrentNode = (PdfStructureElement)children.getAsDict(children.size() - 1);
                        }
                    }
                } else {
                    this.structureCurrentNode = new PdfStructureElement(this.structureCurrentNode, new PdfName(tagType));
                }
                if ("Figure".equals(tagType)) {
                    this.addFigureAttributes();
                }
                if (!"TD".equals(tagType) && !"TH".equals(tagType)) break;
                this.addTableCellAttributes(tagType, area);
            }
        }
    }

    private void beforeOpenTableSectionTag(ContainerArea row) {
        PdfName currentTag = this.structureCurrentNode.getAsName(PdfName.S);
        RowContent rowContent = (RowContent)row.getContent();
        PdfName inject = null;
        boolean closeSection = false;
        switch (rowContent.getBand().getBandType()) {
            case 1: {
                if (currentTag.equals((Object)PdfName.THEAD)) break;
                inject = PdfName.THEAD;
                break;
            }
            case 2: {
                if (currentTag.equals((Object)PdfName.TFOOT)) break;
                inject = PdfName.TFOOT;
                closeSection = !currentTag.equals((Object)PdfName.TABLE);
                break;
            }
            default: {
                if (currentTag.equals((Object)PdfName.TBODY)) break;
                inject = PdfName.TBODY;
                boolean bl = closeSection = !currentTag.equals((Object)PdfName.TABLE);
            }
        }
        if (closeSection) {
            this.structureCurrentNode = (PdfStructureElement)this.structureCurrentNode.getParent();
        }
        if (inject != null) {
            this.structureCurrentNode = new PdfStructureElement(this.structureCurrentNode, inject);
        }
    }

    private void addTableCellAttributes(String tagType, IArea area) {
        if (area instanceof CellArea) {
            CellArea cellArea = (CellArea)area;
            int rowspan = cellArea.getRowSpan();
            int colspan = cellArea.getColSpan();
            String scope = ((CellContent)cellArea.getContent()).getScope();
            String bookmark = cellArea.getBookmark();
            if (bookmark != null) {
                this.structureCurrentNode.put(PdfName.ID, (PdfObject)new PdfString(bookmark));
            }
            String headers = ((CellContent)cellArea.getContent()).getHeaders();
            if (rowspan != 1 || colspan != 1 || scope != null || headers != null) {
                PdfDictionary attributes = this.structureCurrentNode.getAsDict(PdfName.A);
                if (attributes == null) {
                    attributes = new PdfDictionary();
                    attributes.put(PdfName.O, (PdfObject)PdfName.TABLE);
                    this.structureCurrentNode.put(PdfName.A, (PdfObject)attributes);
                }
                if (rowspan != 1) {
                    attributes.put(PdfNames.ROWSPAN, (PdfObject)new PdfNumber(rowspan));
                }
                if (colspan != 1) {
                    attributes.put(PdfNames.COLSPAN, (PdfObject)new PdfNumber(colspan));
                }
                if (scope != null && "TH".equals(tagType)) {
                    attributes.put(PdfNames.SCOPE, (PdfObject)this.pdfScope(scope));
                }
                if (headers != null) {
                    attributes.put(PdfNames.HEADERS, (PdfObject)this.commaSeparatedToPdfByteStringArray(headers));
                }
            }
        }
    }

    private void addFigureAttributes() {
        if (PdfName.DOCUMENT.equals((Object)this.structureCurrentNode.getParent().get(PdfName.S))) {
            PdfDictionary attributes = this.structureCurrentNode.getAsDict(PdfName.A);
            if (attributes == null) {
                attributes = new PdfDictionary();
                this.structureCurrentNode.put(PdfName.A, (PdfObject)attributes);
            }
            attributes.put(PdfNames.PLACEMENT, (PdfObject)PdfNames.BLOCK);
            attributes.put(PdfName.O, (PdfObject)PdfNames.LAYOUT);
        }
    }

    private PdfArray commaSeparatedToPdfByteStringArray(String csv) {
        String[] arr = csv.split(",");
        PdfArray pdfArr = new PdfArray();
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            pdfArr.add((PdfObject)new PdfString(s));
            ++n2;
        }
        return pdfArr;
    }

    private PdfName pdfScope(String scope) {
        if (scope == null) {
            return null;
        }
        if ("col".equals(scope)) {
            return PdfNames.COLUMN;
        }
        if ("row".equals(scope)) {
            return PdfNames.ROW;
        }
        logger.warning("Unsupported scope: " + scope);
        return null;
    }

    public void closeTag(String tagType, IArea area) {
        if (!this.writer.isTagged() || tagType == null) {
            return;
        }
        if ("pageHeader".equals(tagType)) {
            this.currentPage.endArtifact();
        } else if ("pageFooter".equals(tagType)) {
            this.currentPage.endArtifact();
        } else if (area instanceof ContainerArea && ((ContainerArea)area).isArtifact()) {
            this.currentPage.endArtifact();
        } else if (!this.currentPage.isInArtifact()) {
            PdfName currentTag;
            if ("Table".equals(tagType) && !(currentTag = this.structureCurrentNode.getAsName(PdfName.S)).equals((Object)PdfNames.TR)) {
                this.structureCurrentNode = (PdfStructureElement)this.structureCurrentNode.getParent();
            }
            this.structureCurrentNode = (PdfStructureElement)this.structureCurrentNode.getParent();
        }
    }

    public boolean isTagged() {
        return this.writer.isTagged();
    }

    private static class PDFAExtensionSchema
    extends XmpSchema {
        private static final long serialVersionUID = 6654512771721220538L;

        public PDFAExtensionSchema() {
            super("xmlns:pdfaExtension=\"http://www.aiim.org/pdfa/ns/extension/\" xmlns:pdfaProperty=\"http://www.aiim.org/pdfa/ns/property#\" xmlns:pdfaSchema=\"http://www.aiim.org/pdfa/ns/schema#\"");
        }

        public String toString() {
            return "            <pdfaExtension:schemas>\r\n                <rdf:Bag>\r\n                    <rdf:li rdf:parseType=\"Resource\">\r\n                        <pdfaSchema:namespaceURI>http://www.aiim.org/pdfua/ns/id/</pdfaSchema:namespaceURI>\r\n                        <pdfaSchema:prefix>pdfuaid</pdfaSchema:prefix>\r\n                        <pdfaSchema:schema>PDF/UA identification schema</pdfaSchema:schema>\r\n                        <pdfaSchema:property>\r\n                            <rdf:Seq>\r\n                                <rdf:li rdf:parseType=\"Resource\">\r\n                                    <pdfaProperty:category>internal</pdfaProperty:category>\r\n                                    <pdfaProperty:description>PDF/UA version identifier</pdfaProperty:description>\r\n                                    <pdfaProperty:name>part</pdfaProperty:name>\r\n                                    <pdfaProperty:valueType>Integer</pdfaProperty:valueType>\r\n                                </rdf:li>\r\n                                <rdf:li rdf:parseType=\"Resource\">\r\n                                    <pdfaProperty:category>internal</pdfaProperty:category>\r\n                                    <pdfaProperty:description>PDF/UA amendment identifier</pdfaProperty:description>\r\n                                    <pdfaProperty:name>amd</pdfaProperty:name>\r\n                                    <pdfaProperty:valueType>Text</pdfaProperty:valueType>\r\n\r\n                                </rdf:li>\r\n                                <rdf:li rdf:parseType=\"Resource\">\r\n                                    <pdfaProperty:category>internal</pdfaProperty:category>\r\n                                    <pdfaProperty:description>PDF/UA corrigenda identifier</pdfaProperty:description>\r\n                                    <pdfaProperty:name>corr</pdfaProperty:name>\r\n                                    <pdfaProperty:valueType>Text</pdfaProperty:valueType>\r\n                                </rdf:li>\r\n                            </rdf:Seq>\r\n                        </pdfaSchema:property>\r\n                    </rdf:li>\r\n                </rdf:Bag>\r\n            </pdfaExtension:schemas>\r\n";
        }
    }

    private static class PDFUASchema
    extends XmpSchema {
        private static final long serialVersionUID = -6990512370284803429L;

        public PDFUASchema() {
            super("xmlns:pdfuaid=\"http://www.aiim.org/pdfua/ns/id/\"");
        }

        public void addPdfUAId(int version) {
            this.setProperty("pdfuaid:part", String.valueOf(version));
        }
    }
}

