/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.util.Map;
import org.eclipse.birt.report.engine.api.ITaskOption;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.ir.Expression;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import uk.co.spudsoft.birt.emitters.excel.framework.ExcelEmitterPlugin;

public class EmitterServices {
    public static boolean booleanOption(ITaskOption options, IContent birtContent, String name, boolean defaultValue) {
        Expression expression;
        Map userProperties;
        boolean result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value != null) {
            result = EmitterServices.booleanOption(value, defaultValue);
        }
        return result;
    }

    public static boolean booleanOption(ITaskOption options, IReportContent reportContent, String name, boolean defaultValue) {
        Expression expression;
        Map userProperties;
        boolean result = defaultValue;
        Object value = null;
        if (reportContent != null && (userProperties = reportContent.getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (reportContent != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(reportContent, name);
        }
        if (value != null) {
            result = EmitterServices.booleanOption(value, defaultValue);
        }
        return result;
    }

    public static String stringOption(ITaskOption options, IContent birtContent, String name, String defaultValue) {
        Expression expression;
        Map userProperties;
        String result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public static String stringOption(ITaskOption options, IReportContent reportContent, String name, String defaultValue) {
        Expression expression;
        Map userProperties;
        String result = defaultValue;
        Object value = null;
        if (reportContent != null && (userProperties = reportContent.getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (reportContent != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(reportContent, name);
        }
        if (value != null) {
            result = value.toString();
        }
        return result;
    }

    public static int integerOption(ITaskOption options, IContent birtContent, String name, int defaultValue) {
        Expression expression;
        Map userProperties;
        int result = defaultValue;
        Object value = null;
        IContent currentElement = birtContent;
        while (currentElement != null && value == null) {
            Expression expression2;
            Map userProperties2;
            Object designObject;
            if (currentElement instanceof IContent && (designObject = currentElement.getGenerateBy()) instanceof ReportElementDesign && (userProperties2 = ((ReportElementDesign)designObject).getUserProperties()) != null && (expression2 = (Expression)userProperties2.get(name)) instanceof Expression.Constant) {
                Expression.Constant constant = (Expression.Constant)expression2;
                value = constant.getValue();
            }
            if (value != null) continue;
            currentElement = currentElement.getParent();
        }
        if (value == null && birtContent != null && (userProperties = birtContent.getReportContent().getDesign().getUserProperties()) != null && (expression = (Expression)userProperties.get(name)) instanceof Expression.Constant) {
            Expression.Constant constant = (Expression.Constant)expression;
            value = constant.getValue();
        }
        if (value == null && options != null) {
            value = options.getOption(name);
        }
        if (birtContent != null && birtContent.getReportContent() != null && value == null) {
            value = EmitterServices.getReportDesignConfiguration(birtContent.getReportContent(), name);
        }
        if (value instanceof Number) {
            result = ((Number)value).intValue();
        } else if (value != null) {
            try {
                result = Integer.parseInt(value.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public static boolean booleanOption(Object value, boolean defaultValue) {
        if (value != null) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof Number) {
                return ((Number)value).doubleValue() != 0.0;
            }
            if (value != null) {
                return Boolean.parseBoolean(value.toString());
            }
        }
        return defaultValue;
    }

    public static String getPluginName() {
        if (ExcelEmitterPlugin.getDefault() != null && ExcelEmitterPlugin.getDefault().getBundle() != null) {
            return ExcelEmitterPlugin.getDefault().getBundle().getSymbolicName();
        }
        return "uk.co.spudsoft.birt.emitters.excel";
    }

    private static Object getReportDesignConfiguration(IReportContent reportContent, String name) {
        Object value = null;
        if (name.equalsIgnoreCase("ExcelEmitter.AutoFilter")) {
            value = reportContent.getDesign().getReportDesign().getExcelAutoFilter();
        } else if (name.equalsIgnoreCase("ExcelEmitter.DisableGrouping")) {
            value = reportContent.getDesign().getReportDesign().getExcelDisableGrouping();
        } else if (name.equalsIgnoreCase("ExcelEmitter.DisplayGridlines")) {
            value = reportContent.getDesign().getReportDesign().getExcelDisplayGridlines();
        } else if (name.equalsIgnoreCase("ExcelEmitter.ForceRecalculation")) {
            value = reportContent.getDesign().getReportDesign().getExcelForceRecalculation();
        } else if (name.equalsIgnoreCase("ExcelEmitter.ForceAutoColWidths")) {
            value = reportContent.getDesign().getReportDesign().getExcelForceAutoColWidths();
        } else if (name.equalsIgnoreCase("ExcelEmitter.AutoColWidthsIncludeTableHeader")) {
            value = reportContent.getDesign().getReportDesign().getExcelAutoColWidthsIncludeTableHeader();
        } else if (name.equalsIgnoreCase("ExcelEmitter.AutoColWidthsIncludeTableFooter")) {
            value = reportContent.getDesign().getReportDesign().getExcelAutoColWidthsIncludeTableFooter();
        } else if (name.equalsIgnoreCase("ExcelEmitter.ImageScalingToCellDimension")) {
            value = reportContent.getDesign().getReportDesign().getExcelImageScaling();
        } else if (name.equalsIgnoreCase("ExcelEmitter.PrintPagesHigh")) {
            value = reportContent.getDesign().getReportDesign().getExcelPrintPagesHigh();
        } else if (name.equalsIgnoreCase("ExcelEmitter.PrintPagesWide")) {
            value = reportContent.getDesign().getReportDesign().getExcelPrintPagesWide();
        } else if (name.equalsIgnoreCase("ExcelEmitter.PrintScale")) {
            value = reportContent.getDesign().getReportDesign().getExcelPrintScale();
        } else if (name.equalsIgnoreCase("ExcelEmitter.SingleSheet")) {
            value = reportContent.getDesign().getReportDesign().getExcelSingleSheet();
        } else if (name.equalsIgnoreCase("ExcelEmitter.SingleSheetWithPageBreaks")) {
            value = reportContent.getDesign().getReportDesign().getExcelSingleSheetPageBreak();
        } else if (name.equalsIgnoreCase("ExcelEmitter.StreamingXlsx")) {
            value = reportContent.getDesign().getReportDesign().getExcelStreamingXlsx();
        } else if (name.equalsIgnoreCase("ExcelEmitter.StructuredHeader")) {
            value = reportContent.getDesign().getReportDesign().getExcelStructuredHeader();
        } else if (name.equalsIgnoreCase("ExcelEmitter.TemplateFile")) {
            value = reportContent.getDesign().getReportDesign().getExcelTemplateFile();
        }
        return value;
    }
}

