/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.StringUtil;

public class DimensionType {
    private static Logger log = Logger.getLogger(DimensionType.class.getName());
    public static final int TYPE_DIMENSION = 1;
    public static final int TYPE_CHOICE = 0;
    public static final String UNITS_CM = "cm";
    public static final String UNITS_EM = "em";
    public static final String UNITS_EX = "ex";
    public static final String UNITS_IN = "in";
    public static final String UNITS_MM = "mm";
    public static final String UNITS_PC = "pc";
    public static final String UNITS_PERCENTAGE = "%";
    public static final String UNITS_PT = "pt";
    public static final String UNITS_PX = "px";
    protected int type = -1;
    protected String unitType;
    protected double measure = -1.0;
    protected String choice;
    protected static final int VERSION = 0;
    static final int FIELD_NONE = -1;
    static final int FIELD_TYPE = 0;
    static final int FIELD_UNITTYPE = 1;
    static final int FIELD_MEASURE = 2;
    static final int FIELD_CHOICE = 3;

    public DimensionType() {
    }

    public DimensionType(String choice) {
        this.type = 0;
        this.choice = choice;
        this.measure = 0.0;
        this.unitType = null;
    }

    public DimensionType(double value, String units) {
        this.type = 1;
        this.unitType = units;
        this.measure = value;
        this.choice = null;
    }

    public int getValueType() {
        return this.type;
    }

    public double getMeasure() {
        assert (this.type == 1);
        return this.measure;
    }

    public String getUnits() {
        assert (this.type == 1);
        return this.unitType;
    }

    public String getChoice() {
        return this.choice;
    }

    public String toString() {
        if (this.type == 1) {
            String value = Double.toString(this.measure);
            if (value.substring(value.length() - 2).equals(".0")) {
                value = value.substring(0, value.length() - 2);
            }
            return value + this.unitType;
        }
        return this.choice;
    }

    public double convertTo(String targetUnit) {
        assert (this.type == 1);
        DimensionValue value = DimensionUtil.convertTo(this.measure, this.unitType, targetUnit);
        if (value != null) {
            return value.getMeasure();
        }
        return 0.0;
    }

    public DimensionType subtract(DimensionType subtrahend) {
        assert (this.getValueType() == 1);
        assert (subtrahend != null && subtrahend.getValueType() == 1);
        double measure = this.convertTo(UNITS_CM);
        DimensionType ret = new DimensionType(measure -= subtrahend.convertTo(UNITS_CM), UNITS_CM);
        return ret;
    }

    public double compare(DimensionType subtrahend) {
        assert (this.getValueType() == 1);
        assert (subtrahend != null && subtrahend.getValueType() == 1);
        double measure = this.convertTo(UNITS_CM);
        return measure -= subtrahend.convertTo(UNITS_CM);
    }

    public static DimensionType parserUnit(String value) {
        if (value != null) {
            try {
                DimensionValue val = StringUtil.parse(value);
                return new DimensionType(val.getMeasure(), val.getUnits());
            }
            catch (PropertyValueException e) {
                log.log(Level.SEVERE, e.getMessage());
            }
        }
        return null;
    }

    public static DimensionType parserUnit(String value, String defaultUnits) {
        if (value != null) {
            try {
                DimensionValue val = StringUtil.parse(value);
                String units = val.getUnits();
                if (units == null || "".equals(units)) {
                    units = defaultUnits;
                }
                return new DimensionType(val.getMeasure(), units);
            }
            catch (PropertyValueException e) {
                log.log(Level.SEVERE, e.getMessage());
            }
        }
        return null;
    }

    protected void writeFields(DataOutputStream out) throws IOException {
        if (this.type != -1) {
            IOUtil.writeInt(out, 0);
            IOUtil.writeInt(out, this.type);
        }
        if (this.unitType != null) {
            IOUtil.writeInt(out, 1);
            IOUtil.writeString(out, this.unitType);
        }
        if (this.measure != -1.0) {
            IOUtil.writeInt(out, 2);
            IOUtil.writeDouble(out, this.measure);
        }
        if (this.choice != null) {
            IOUtil.writeInt(out, 3);
            IOUtil.writeString(out, this.choice);
        }
    }

    protected void readField(int version, int filedId, DataInputStream in) throws IOException {
        switch (filedId) {
            case 0: {
                this.type = IOUtil.readInt(in);
                break;
            }
            case 1: {
                this.unitType = IOUtil.readString(in);
                break;
            }
            case 2: {
                this.measure = IOUtil.readDouble(in);
                break;
            }
            case 3: {
                this.choice = IOUtil.readString(in);
            }
        }
    }

    public void readObject(DataInputStream in) throws IOException {
        int version = IOUtil.readInt(in);
        int filedId = IOUtil.readInt(in);
        while (filedId != -1) {
            this.readField(version, filedId, in);
            filedId = IOUtil.readInt(in);
        }
    }

    public void writeObject(DataOutputStream out) throws IOException {
        IOUtil.writeInt(out, 0);
        this.writeFields(out);
        IOUtil.writeInt(out, -1);
    }
}

