/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.nLayout;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.format.NumberFormatter;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.content.Dimension;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.ICellContent;
import org.eclipse.birt.report.engine.content.IContainerContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.IListBandContent;
import org.eclipse.birt.report.engine.content.IListContent;
import org.eclipse.birt.report.engine.content.IListGroupContent;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.content.IRowContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.content.ITableGroupContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.emitter.ContentEmitterUtil;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.emitter.IEmitterServices;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.html.HTMLLayoutContext;
import org.eclipse.birt.report.engine.layout.pdf.emitter.LayoutEmitterAdapter;
import org.eclipse.birt.report.engine.layout.pdf.font.FontInfo;
import org.eclipse.birt.report.engine.layout.pdf.text.Chunk;
import org.eclipse.birt.report.engine.layout.pdf.text.ChunkGenerator;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.eclipse.birt.report.engine.nLayout.LayoutContext;
import org.eclipse.birt.report.engine.nLayout.area.IContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AbstractArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.nLayout.area.impl.CellArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ForeignHTMLRegionLayout;
import org.eclipse.birt.report.engine.nLayout.area.impl.ListArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.ListGroupArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.PageArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.RepeatableArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextArea;
import org.eclipse.birt.report.engine.nLayout.area.impl.TextAreaLayout;
import org.eclipse.birt.report.engine.nLayout.area.style.TextStyle;
import org.eclipse.birt.report.engine.util.BidiAlignmentResolver;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class LayoutEngine
extends LayoutEmitterAdapter
implements IContentEmitter {
    protected IContentEmitter emitter;
    protected LayoutContext context;
    protected ContainerArea current;
    protected AreaFactory af = null;
    protected ILayoutPageHandler pageHandler;
    protected boolean isFirst = true;
    LinkedList<IContent> unfinishedContents = new LinkedList();
    protected IContent contentDisplayNone = null;

    public LayoutEngine(IContentEmitter emitter, IRenderOption renderOptions, ExecutionContext executionContext, long documentTotalPage) {
        this.emitter = emitter;
        this.context = new LayoutContext();
        this.af = new AreaFactory(this);
        this.setupLayoutOptions(renderOptions);
        String format = "pdf";
        if (renderOptions != null) {
            format = renderOptions.getOutputFormat();
        }
        this.context.setFormat(format);
        this.context.setLocale(executionContext.getLocale());
        this.context.setEngineTaskType(executionContext.getTaskType());
        long filteredTotalPage = executionContext.getFilteredTotalPage();
        this.context.totalPage = filteredTotalPage == 0L ? documentTotalPage : filteredTotalPage;
    }

    public LayoutEngine(HTMLLayoutContext htmlLayoutContext, IContentEmitter emitter, IRenderOption renderOptions, ExecutionContext executionContext, long totalPage) {
        this(emitter, renderOptions, executionContext, totalPage);
        this.context.setHtmlLayoutContext(htmlLayoutContext);
    }

    public LayoutEngine(LayoutContext context) {
        this.context = context;
        this.af = new AreaFactory(this);
    }

    @Override
    public void initialize(IEmitterServices service) throws BirtException {
        ReportDesignHandle designHandle;
        if (this.emitter != null) {
            this.emitter.initialize(service);
        }
        if ((designHandle = (ReportDesignHandle)service.getReportRunnable().getDesignHandle()) != null) {
            String reportLayoutPreference = designHandle.getLayoutPreference();
            this.context.setFixedLayout("fixed layout".equals(reportLayoutPreference));
        }
        if (this.context.getHtmlLayoutContext() != null && this.context.isFixedLayout()) {
            this.context.setAutoPageBreak(this.context.getHtmlLayoutContext().allowPageBreak());
        }
    }

    public void createPageHintGenerator() {
        this.context.createPageHintGenerator();
    }

    protected void setupLayoutOptions(IRenderOption renderOptions) {
        Map<String, Object> options = null;
        if (renderOptions != null) {
            options = renderOptions.getOptions();
        }
        if (options != null) {
            Object reserveDocumentPageNumbers;
            Object supportedImageFormats;
            Object dpi;
            Object wordbreak;
            Object bidiProcessing;
            Object fontSubstitution;
            int limit;
            Object pageLimit;
            Object pageOverflow;
            Object pageBreakOnly;
            Object fitToPage = options.get("pdfRenderOption.fitToPage");
            if (fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
                this.context.setFitToPage(true);
            }
            if ((pageBreakOnly = options.get("pdfRenderOption.pagebreakPaginationOnly")) instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
                this.context.setPagebreakPaginationOnly(true);
            }
            if ((pageOverflow = options.get("pdfRenderOption.pageOverflow")) instanceof Integer) {
                int pageOverflowType = (Integer)pageOverflow;
                this.context.setPageOverflow(pageOverflowType);
                if (pageOverflowType == 4) {
                    this.context.setPagebreakPaginationOnly(false);
                } else {
                    this.context.setPagebreakPaginationOnly(true);
                }
            } else if (this.context.fitToPage()) {
                this.context.setPageOverflow(2);
                this.context.setPagebreakPaginationOnly(true);
            }
            Object textWrapping = options.get("pdfRenderOption.textWrapping");
            if (textWrapping instanceof Boolean && !((Boolean)textWrapping).booleanValue()) {
                this.context.setTextWrapping(false);
            }
            if ((pageLimit = options.get("pdfRenderOption.pageLimit")) instanceof Integer && (limit = ((Integer)pageLimit).intValue()) > 0) {
                this.context.setPageLimit(limit);
            }
            if ((fontSubstitution = options.get("pdfRenderOption.fontSubstitution")) instanceof Boolean && !((Boolean)fontSubstitution).booleanValue()) {
                this.context.setFontSubstitution(false);
            }
            if ((bidiProcessing = options.get("pdfRenderOption.bidiProcessing")) instanceof Boolean && !((Boolean)bidiProcessing).booleanValue()) {
                this.context.setBidiProcessing(false);
            }
            if ((wordbreak = options.get("pdfRenderOption.wordBreak")) instanceof Boolean && ((Boolean)wordbreak).booleanValue()) {
                this.context.setEnableWordbreak(true);
            }
            if ((dpi = options.get("RenderDpi")) instanceof Integer) {
                int renderDpi = (Integer)dpi;
                this.context.setDpi(renderDpi);
            }
            if ((supportedImageFormats = options.get("supportedImageFormats")) instanceof String) {
                this.context.setSupportedImageFormats((String)supportedImageFormats);
            }
            if ((reserveDocumentPageNumbers = options.get("pdfRenderOption.reserveDocumentPageNumbers")) instanceof Boolean) {
                if (((Boolean)reserveDocumentPageNumbers).booleanValue()) {
                    this.context.setReserveDocumentPageNumbers(true);
                } else {
                    this.context.setReserveDocumentPageNumbers(false);
                }
            }
        }
    }

    @Override
    public String getOutputFormat() {
        if (this.emitter != null) {
            return this.emitter.getOutputFormat();
        }
        return null;
    }

    @Override
    public void start(IReportContent report) throws BirtException {
        if (this.emitter != null) {
            this.emitter.start(report);
        }
        this.context.setReport(report);
    }

    @Override
    public void end(IReportContent report) throws BirtException {
        if (this.emitter != null) {
            this.resolveTotalPage(this.emitter);
        }
        this.context.setFinished(true);
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.pageNumber, this.context);
        }
        if (this.emitter != null) {
            this.emitter.end(report);
        }
    }

    @Override
    public void startContainer(IContainerContent container) throws BirtException {
        this.checkDisplayNone(container, true);
        this._startContainer(container);
    }

    @Override
    public void endContainer(IContainerContent container) throws BirtException {
        this._endContainer(container);
        this.checkDisplayNone(container, false);
    }

    protected void setContainer(ContainerArea container) throws BirtException {
        container.initialize();
        this.current = container;
    }

    protected void closeContainer() throws BirtException {
        if (this.current != null) {
            this.current.close();
            this.current = this.current.getParent();
        }
    }

    protected void checkDisplayNone(IContent content, boolean isStart) {
        if (isStart) {
            if (!this.context.isDisplayNone() && PropertyUtil.isDisplayNone(content)) {
                this.contentDisplayNone = content;
                this.context.setDisplayNone(true);
            }
        } else if (this.context.isDisplayNone() && PropertyUtil.isDisplayNone(content) && this.contentDisplayNone.getInstanceID() == content.getInstanceID()) {
            this.context.setDisplayNone(false);
            this.contentDisplayNone = null;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void _startContainer(IContent container) throws BirtException {
        block6: {
            block5: {
                isInline = PropertyUtil.isInlineElement(container);
                if (!isInline) ** GOTO lbl15
                if (this.unfinishedContents.isEmpty() || container.getParent() != this.unfinishedContents.peek()) break block5;
                parent = this.unfinishedContents.poll();
                this._startContainer(parent);
                break block6;
            }
            if (this.current != null && this.current.isInlineStacking()) break block6;
            this.setContainer(this.af.createLineArea(this.current, this.context));
            break block6;
lbl-1000:
            // 1 sources

            {
                if (this.current.getContent() != null) {
                    this.unfinishedContents.add(this.current.getContent());
                }
                this.closeContainer();
lbl15:
                // 2 sources

                ** while (this.current != null && this.current.isInlineStacking())
            }
        }
        area = (ContainerArea)this.af.createArea(this.current, this.context, container);
        this.setContainer(area);
    }

    protected boolean checkUnfinishedContent(IContent content) {
        if (!this.unfinishedContents.isEmpty() && this.unfinishedContents.contains(content)) {
            this.unfinishedContents.remove(content);
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void _endContainer(IContent container) throws BirtException {
        block5: {
            if (this.checkUnfinishedContent(container)) {
                return;
            }
            isInline = PropertyUtil.isInlineElement(container);
            if (!isInline) ** GOTO lbl10
            if (this.current == null) break block5;
            this.current.isInlineStacking();
            break block5;
lbl-1000:
            // 1 sources

            {
                this.closeContainer();
lbl10:
                // 2 sources

                ** while (this.current != null && this.current.isInlineStacking())
            }
        }
        this.closeContainer();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void endList(IListContent list) throws BirtException {
        if (!this.checkUnfinishedContent(list)) ** GOTO lbl4
        return;
lbl-1000:
        // 1 sources

        {
            this.closeContainer();
lbl4:
            // 2 sources

            ** while (this.current != null && !(this.current instanceof ListArea))
        }
lbl5:
        // 1 sources

        this.closeContainer();
        this.checkDisplayNone(list, false);
    }

    protected void _endCell(ICellContent cell) throws BirtException {
        while (!(this.current instanceof CellArea)) {
            this.current.close();
            this.current = this.current.getParent();
        }
        this.current.close();
        this.current = this.current.getParent();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void startContent(IContent content) throws BirtException {
        block7: {
            block6: {
                isInline = PropertyUtil.isInlineElement(content);
                if (!isInline) ** GOTO lbl15
                if (this.unfinishedContents.isEmpty() || content.getParent() != this.unfinishedContents.peek()) break block6;
                parent = this.unfinishedContents.poll();
                this._startContainer(parent);
                break block7;
            }
            if (this.current != null && this.current.isInlineStacking()) break block7;
            this.setContainer(this.af.createLineArea(this.current, this.context));
            break block7;
lbl-1000:
            // 1 sources

            {
                if (this.current.getContent() != null) {
                    this.unfinishedContents.add(this.current.getContent());
                }
                this.closeContainer();
lbl15:
                // 2 sources

                ** while (this.current != null && this.current.isInlineStacking())
            }
        }
        this.checkDisplayNone(content, true);
        layout = this.af.createLayout(this.current, this.context, content);
        if (layout != null) {
            layout.layout();
        }
        this.checkDisplayNone(content, false);
    }

    @Override
    public void endContent(IContent content) throws BirtException {
        this.checkUnfinishedContent(content);
    }

    @Override
    public void startListBand(IListBandContent listBand) throws BirtException {
        int bandType = listBand.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(true);
        }
    }

    @Override
    public void startListGroup(IListGroupContent listGroup) throws BirtException {
        super.startListGroup(listGroup);
    }

    @Override
    public void endListBand(IListBandContent listBand) throws BirtException {
        int bandType = listBand.getBandType();
        if (bandType == 1 || bandType == 3) {
            ContainerArea container = this.current;
            while (container != null && !(container instanceof ListArea) && !(container instanceof ListGroupArea)) {
                container = container.getParent();
            }
            if (container instanceof RepeatableArea) {
                ((RepeatableArea)container).setInHeaderBand(false);
            }
        }
    }

    protected void startTableContainer(IContainerContent container) throws BirtException {
        this.setContainer((ContainerArea)this.af.createArea(this.current, this.context, container));
    }

    protected void endTableContainer(IContainerContent container) throws BirtException {
        this.closeContainer();
    }

    @Override
    public void startRow(IRowContent row) throws BirtException {
        this.checkDisplayNone(row, true);
        this.startTableContainer(row);
    }

    @Override
    public void endRow(IRowContent row) throws BirtException {
        this.endTableContainer(row);
        this.checkDisplayNone(row, false);
    }

    @Override
    public void startTableBand(ITableBandContent band) throws BirtException {
        int bandType = band.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(true);
        }
    }

    @Override
    public void startTableGroup(ITableGroupContent group) throws BirtException {
        this.checkDisplayNone(group, true);
        this.startTableContainer(group);
    }

    @Override
    public void endTableBand(ITableBandContent band) throws BirtException {
        int bandType = band.getBandType();
        if ((bandType == 1 || bandType == 3) && this.current instanceof RepeatableArea) {
            ((RepeatableArea)this.current).setInHeaderBand(false);
        }
    }

    @Override
    public void endTableGroup(ITableGroupContent group) throws BirtException {
        this.endTableContainer(group);
        this.checkDisplayNone(group, false);
    }

    @Override
    public void startCell(ICellContent cell) throws BirtException {
        this.checkDisplayNone(cell, true);
        this.startTableContainer(cell);
    }

    @Override
    public void endCell(ICellContent cell) throws BirtException {
        this._endCell(cell);
        this.checkDisplayNone(cell, false);
    }

    protected void visitContent(IContent content, IContentEmitter emitter) throws BirtException {
        ContentEmitterUtil.startContent(content, emitter);
        Collection<IContent> children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
        ContentEmitterUtil.endContent(content, emitter);
    }

    protected void visitChildren(IContent content, IContentEmitter emitter) throws BirtException {
        Collection<IContent> children = content.getChildren();
        if (children != null && !children.isEmpty()) {
            for (IContent child : children) {
                this.visitContent(child, emitter);
            }
        }
    }

    @Override
    public void startForeign(IForeignContent foreign) throws BirtException {
        this.checkDisplayNone(foreign, true);
        if (this.context.isFixedLayout() && this.context.getEngineTaskType() == 1 && "text/html".equals(foreign.getRawType())) {
            HTML2Content.html2Content(foreign);
            this.processHTML(foreign);
        } else {
            this._startContainer(foreign);
            if ("text/html".equals(foreign.getRawType())) {
                HTML2Content.html2Content(foreign);
                Collection<IContent> children = foreign.getChildren();
                if (children != null && !children.isEmpty()) {
                    Iterator<IContent> iter = children.iterator();
                    IContent child = iter.next();
                    this.visitContent(child, this);
                }
                foreign.getChildren().clear();
            }
            this._endContainer(foreign);
        }
        this.checkDisplayNone(foreign, false);
    }

    /*
     * Unable to fully structure code
     */
    private void processHTML(IForeignContent foreign) throws BirtException {
        block6: {
            block5: {
                isInline = PropertyUtil.isInlineElement(foreign);
                if (!isInline) ** GOTO lbl15
                if (this.unfinishedContents.isEmpty() || foreign.getParent() != this.unfinishedContents.peek()) break block5;
                parent = this.unfinishedContents.poll();
                this._startContainer(parent);
                break block6;
            }
            if (this.current != null && this.current.isInlineStacking()) break block6;
            this.setContainer(this.af.createLineArea(this.current, this.context));
            break block6;
lbl-1000:
            // 1 sources

            {
                if (this.current.getContent() != null) {
                    this.unfinishedContents.add(this.current.getContent());
                }
                this.closeContainer();
lbl15:
                // 2 sources

                ** while (this.current != null && this.current.isInlineStacking())
            }
        }
        rle = new ForeignHTMLRegionLayout(this.current, this.context, foreign);
        rle.layout();
    }

    protected void resolveTotalPage(IContentEmitter emitter) throws BirtException {
        IContent con = this.context.getUnresolvedContent();
        if (!(con instanceof IAutoTextContent)) {
            return;
        }
        IAutoTextContent totalPageContent = (IAutoTextContent)con;
        if (totalPageContent != null) {
            int spacing;
            String align;
            boolean isRightAligned;
            DataFormatValue format = totalPageContent.getComputedStyle().getDataFormat();
            NumberFormatter nf = null;
            if (format == null) {
                nf = new NumberFormatter();
            } else {
                String pattern = format.getNumberPattern();
                String locale = format.getNumberLocale();
                nf = locale == null ? new NumberFormatter(pattern) : new NumberFormatter(pattern, new ULocale(locale));
            }
            totalPageContent.setText(nf.format(this.context.pageCount));
            AbstractArea totalPageArea = null;
            ChunkGenerator cg = new ChunkGenerator(this.context.getFontManager(), totalPageContent, true, true);
            if (cg.hasMore()) {
                Chunk c = cg.getNext();
                Dimension d = new Dimension((int)(c.getFontInfo().getWordWidth(c.getText()) * 1000.0f), (int)(c.getFontInfo().getWordHeight() * 1000.0f));
                totalPageArea = this.createTextArea(totalPageContent, c.getFontInfo(), false);
                totalPageArea.setWidth(Math.min(this.context.getMaxWidth(), d.getWidth()));
                totalPageArea.setHeight(Math.min(this.context.getMaxHeight(), d.getHeight()));
            }
            if (((isRightAligned = BidiAlignmentResolver.isRightAligned((IContent)totalPageContent, align = totalPageContent.getComputedStyle().getTextAlign(), false)) || "center".equalsIgnoreCase(align)) && (spacing = this.context.getTotalPageTemplateWidth() - totalPageArea.getWidth()) > 0) {
                if (isRightAligned) {
                    totalPageArea.setPosition(spacing + totalPageArea.getX(), totalPageArea.getY());
                } else if ("center".equalsIgnoreCase(align)) {
                    totalPageArea.setPosition(spacing / 2 + totalPageArea.getX(), totalPageArea.getY());
                }
            }
            totalPageContent.setExtension(1, totalPageArea);
            emitter.startAutoText(totalPageContent);
        }
    }

    protected TextArea createTextArea(IAutoTextContent content, FontInfo fontInfo, boolean blankLine) {
        TextStyle textStyle = TextAreaLayout.buildTextStyle(content, fontInfo);
        String text = content.getText();
        TextArea area = new TextArea(text, textStyle);
        area.setTextLength(text.length());
        area.setAction(content.getHyperlinkAction());
        return area;
    }

    boolean showPageFooter(SimpleMasterPageDesign masterPage, IPageContent page) {
        boolean showFooter = true;
        if (!masterPage.isShowFooterOnLast() && page.getPageNumber() == this.context.totalPage) {
            showFooter = false;
        }
        return showFooter;
    }

    @Override
    public void outputPage(IPageContent page) throws BirtException {
        Object obj;
        MasterPageDesign mp = (MasterPageDesign)page.getGenerateBy();
        if (mp instanceof SimpleMasterPageDesign && (obj = page.getExtension(1)) instanceof PageArea) {
            PageArea pageArea = (PageArea)obj;
            if (this.isFirst && !((SimpleMasterPageDesign)mp).isShowHeaderOnFirst()) {
                pageArea.removeHeader();
                this.isFirst = false;
            }
            if (!this.showPageFooter((SimpleMasterPageDesign)mp, page)) {
                pageArea.removeFooter();
            }
            if (((SimpleMasterPageDesign)mp).isFloatingFooter()) {
                ContainerArea footer = (ContainerArea)((Object)page.getFooter());
                IContainerArea body = pageArea.getBody();
                IContainerArea header = pageArea.getHeader();
                if (footer != null) {
                    footer.setPosition(footer.getX(), (header == null ? 0 : header.getHeight()) + (body == null ? 0 : body.getHeight()));
                }
            }
        }
        if (this.emitter != null && !this.context.exceedPageLimit()) {
            this.emitter.startPage(page);
            this.emitter.endPage(page);
        }
        ++this.context.pageCount;
        if (this.pageHandler != null) {
            this.pageHandler.onPage(this.context.pageNumber, this.context);
        }
    }

    @Override
    public ILayoutPageHandler getPageHandler() {
        return this.pageHandler;
    }

    @Override
    public void setPageHandler(ILayoutPageHandler pageHandler) {
        this.pageHandler = pageHandler;
    }
}

