/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.StyleException;
import org.eclipse.birt.report.model.api.util.StyleUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class StyleReferenceValidator
extends AbstractElementValidator {
    public static final String NAME = "StyleReferenceValidator";
    private static final StyleReferenceValidator instance = new StyleReferenceValidator();

    public static StyleReferenceValidator getInstance() {
        return instance;
    }

    @Override
    public List<SemanticException> validate(Module module, DesignElement element) {
        if (!(element instanceof StyledElement)) {
            return Collections.emptyList();
        }
        return this.doValidate(module, (StyledElement)element);
    }

    private List<SemanticException> doValidate(Module module, StyledElement toValidate) {
        ArrayList<SemanticException> list = new ArrayList<SemanticException>();
        String styleName = toValidate.getStyleName();
        StyleElement style = toValidate.getStyle();
        if (styleName != null && style == null) {
            DesignElement resolvedElement = module.resolveElement((DesignElement)toValidate, styleName, (PropertyDefn)toValidate.getPropertyDefn("style"), null);
            if (resolvedElement == null) {
                if (!StyleUtil.hasExternalCSSURI(module)) {
                    list.add(new StyleException((DesignElement)toValidate, styleName, "Error.StyleException.NOT_FOUND"));
                }
            } else {
                toValidate.setStyle((StyleElement)resolvedElement);
            }
        }
        return list;
    }
}

