/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.tests.example.matrix;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.report.designer.tests.example.matrix.ChoiceDefn;
import org.eclipse.birt.report.designer.tests.example.matrix.ExtendedElementCommand;
import org.eclipse.birt.report.designer.tests.example.matrix.ExtensionPropertyDefn;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IElementCommand;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.extension.ReportItem;

public class ExtendedElement
extends ReportItem {
    public static final String TEST1_PROP = "test1";
    public static final String TEST2_PROP = "test2";
    public static final String TEST3_PROP = "test3";
    public static final String TEST5_PROP = "test5";
    public static final String TEST6_PROP = "test6";
    public static final String TEST7_PROP = "test7";
    public static final String TYPE_RPOP = "type";
    public static final String RADIUS_RPOP = "radius";
    public static final String WIDTH_RPOP = "pieWidth";
    public static final String HEIGHT_RPOP = "pieHeight";
    public static final String X_SCALE_RPOP = "xScale";
    public static final String Y_SCALE_RPOP = "yScale";
    public static final String COMPANY_RPOP = "company";
    public static final String LINE_STYLE_PROP = "lineStyle";
    private static final String TYPE_PIE = "pie";
    private static final String TYPE_BAR = "bar";
    private static final String CHOICE_LINE_STYLE_THIN = "thin";
    private static final String CHOICE_LINE_STYLE_NORMAL = "normal";
    private static final String CHOICE_LINE_STYLE_THICK = "thick";
    protected IReportItemFactory cachedDefn = null;
    protected DesignElementHandle designHandle = null;
    public static String CHECK_PROPERTY_TAG = null;
    private ExtensionPropertyDefn[] piePropertyList = null;
    private ExtensionPropertyDefn[] barPropertyList = null;
    private String test1;
    private int test2;
    private String type = "bar";
    private int radius = 0;
    private int width = 0;
    private int height = 0;
    private int xScale = 0;
    private int yScale = 0;
    private String company = null;
    private String lineStyle = "normal";
    private String test5;
    private String test6;
    private String test7;
    private boolean refreshNeeded = false;

    public ExtendedElement(IReportItemFactory extDefn, DesignElementHandle designHandle) {
        this.cachedDefn = extDefn;
        assert (designHandle != null);
        this.designHandle = designHandle;
        this.piePropertyList = new ExtensionPropertyDefn[4];
        this.piePropertyList[0] = new ExtensionPropertyDefn();
        this.piePropertyList[0].setName(RADIUS_RPOP);
        this.piePropertyList[0].setType(2);
        this.piePropertyList[0].setDisplayNameID("TestingBall.test3.radius");
        this.piePropertyList[1] = new ExtensionPropertyDefn();
        this.piePropertyList[1].setName(WIDTH_RPOP);
        this.piePropertyList[1].setType(2);
        this.piePropertyList[1].setDisplayNameID("TestingBall.test3.width");
        this.piePropertyList[2] = new ExtensionPropertyDefn();
        this.piePropertyList[2].setName(HEIGHT_RPOP);
        this.piePropertyList[2].setType(2);
        this.piePropertyList[2].setDisplayNameID("TestingBall.test3.height");
        this.piePropertyList[3] = new ExtensionPropertyDefn();
        this.piePropertyList[3].setName(TYPE_RPOP);
        this.piePropertyList[3].setType(0);
        this.piePropertyList[3].setDisplayNameID("TestingBall.test3.type");
        this.barPropertyList = new ExtensionPropertyDefn[5];
        this.barPropertyList[0] = new ExtensionPropertyDefn();
        this.barPropertyList[0].setName(X_SCALE_RPOP);
        this.barPropertyList[0].setType(2);
        this.barPropertyList[0].setDisplayNameID("TestingBall.test3.xScale");
        this.barPropertyList[1] = new ExtensionPropertyDefn();
        this.barPropertyList[1].setName(Y_SCALE_RPOP);
        this.barPropertyList[1].setType(2);
        this.barPropertyList[1].setDisplayNameID("TestingBall.test3.yScale");
        this.barPropertyList[2] = new ExtensionPropertyDefn();
        this.barPropertyList[2].setName(TYPE_RPOP);
        this.barPropertyList[2].setType(0);
        this.barPropertyList[2].setDisplayNameID("TestingBall.test3.type");
        this.barPropertyList[3] = new ExtensionPropertyDefn();
        this.barPropertyList[3].setName(COMPANY_RPOP);
        this.barPropertyList[3].setType(0);
        this.barPropertyList[3].setDisplayNameID("TestingBall.test3.company");
        this.barPropertyList[4] = new ExtensionPropertyDefn();
        this.barPropertyList[4].setName(LINE_STYLE_PROP);
        this.barPropertyList[4].setType(5);
        this.barPropertyList[4].setDisplayNameID("TestingBall.test3.lineStyle");
        ArrayList<ChoiceDefn> choices = new ArrayList<ChoiceDefn>();
        ChoiceDefn choice = new ChoiceDefn();
        choice.setName(CHOICE_LINE_STYLE_THIN);
        choice.setValue(Integer.valueOf("1"));
        choice.setDisplayNameID("Choice.lineStyle.thin");
        choices.add(choice);
        choice = new ChoiceDefn();
        choice.setName(CHOICE_LINE_STYLE_NORMAL);
        choice.setValue(Integer.valueOf("2"));
        choice.setDisplayNameID("Choice.lineStyle.normal");
        choices.add(choice);
        choice = new ChoiceDefn();
        choice.setName(CHOICE_LINE_STYLE_THICK);
        choice.setValue(Integer.valueOf("3"));
        choice.setDisplayNameID("Choice.lineStyle.thick");
        choices.add(choice);
        this.barPropertyList[4].setChoices(choices);
    }

    public ByteArrayOutputStream serialize(String propName) {
        if (TEST3_PROP.equalsIgnoreCase(propName)) {
            ByteArrayOutputStream stream;
            block6: {
                stream = new ByteArrayOutputStream();
                StringBuilder sb = new StringBuilder();
                if (TYPE_PIE.equalsIgnoreCase(this.type)) {
                    sb.append("type=pie");
                    sb.append(",");
                    sb.append("radius=" + this.radius);
                    sb.append(",");
                    sb.append("pieWidth=" + this.width);
                    sb.append(",");
                    sb.append("pieHeight=" + this.height);
                } else {
                    sb.append("type=bar");
                    sb.append(",");
                    sb.append("xScale=" + this.xScale);
                    sb.append(",");
                    sb.append("yScale=" + this.yScale);
                    sb.append(",");
                    if (this.company != null) {
                        sb.append("company=" + this.company);
                        sb.append(",");
                    }
                    sb.append("lineStyle=" + this.lineStyle);
                }
                try {
                    stream.write(sb.toString().getBytes());
                }
                catch (IOException e1) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            return stream;
        }
        return null;
    }

    public void deserialize(String propName, ByteArrayInputStream data) throws ExtendedElementException {
        if (TEST3_PROP.equalsIgnoreCase(propName)) {
            int b;
            assert (data != null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            while ((b = data.read()) > -1) {
                out.write(b);
            }
            String allValue = out.toString();
            if (allValue == null || allValue.length() == 0) {
                this.refreshNeeded = true;
                return;
            }
            String[] values = allValue.split(",");
            int i = 0;
            while (i < values.length) {
                String string = values[i];
                String name = string.substring(0, string.indexOf(61));
                String value = string.substring(string.indexOf(61) + 1);
                if (TYPE_RPOP.equalsIgnoreCase(name)) {
                    this.type = value;
                } else if (RADIUS_RPOP.equalsIgnoreCase(name)) {
                    this.radius = Integer.parseInt(value);
                } else if (WIDTH_RPOP.equalsIgnoreCase(name)) {
                    this.width = Integer.parseInt(value);
                } else if (HEIGHT_RPOP.equalsIgnoreCase(name)) {
                    this.height = Integer.parseInt(value);
                } else if (X_SCALE_RPOP.equalsIgnoreCase(name)) {
                    this.xScale = Integer.parseInt(value);
                } else if (Y_SCALE_RPOP.equalsIgnoreCase(name)) {
                    this.yScale = Integer.parseInt(value);
                } else if (COMPANY_RPOP.equalsIgnoreCase(name)) {
                    this.company = value;
                } else if (LINE_STYLE_PROP.equalsIgnoreCase(name)) {
                    this.lineStyle = value;
                }
                ++i;
            }
            this.refreshNeeded = true;
        }
    }

    public Object getProperty(String propName) {
        if (TEST1_PROP.equalsIgnoreCase(propName)) {
            return this.test1;
        }
        if (TEST2_PROP.equalsIgnoreCase(propName)) {
            return new Integer(this.test2);
        }
        if (TEST3_PROP.equalsIgnoreCase(propName)) {
            ByteArrayOutputStream stream = this.serialize(propName);
            return stream.toString();
        }
        if (TEST5_PROP.equalsIgnoreCase(propName)) {
            return this.test5;
        }
        if (TEST6_PROP.equalsIgnoreCase(propName)) {
            return this.test6;
        }
        if (TEST7_PROP.equalsIgnoreCase(propName)) {
            return this.test7;
        }
        if (TYPE_RPOP.equalsIgnoreCase(propName)) {
            return this.type;
        }
        if (RADIUS_RPOP.equalsIgnoreCase(propName)) {
            return new Integer(this.radius);
        }
        if (WIDTH_RPOP.equalsIgnoreCase(propName)) {
            return new Integer(this.width);
        }
        if (HEIGHT_RPOP.equalsIgnoreCase(propName)) {
            return new Integer(this.height);
        }
        if (X_SCALE_RPOP.equalsIgnoreCase(propName)) {
            return new Integer(this.xScale);
        }
        if (Y_SCALE_RPOP.equalsIgnoreCase(propName)) {
            return new Integer(this.yScale);
        }
        if (COMPANY_RPOP.equalsIgnoreCase(propName)) {
            return this.company;
        }
        if (LINE_STYLE_PROP.equalsIgnoreCase(propName)) {
            return this.lineStyle;
        }
        return null;
    }

    public void checkProperty(String propName, Object value) throws ExtendedElementException {
        CHECK_PROPERTY_TAG = propName;
        LINE_STYLE_PROP.equalsIgnoreCase(propName);
    }

    public void setProperty(String propName, Object value) {
        this.execute(this.getElementCommand(propName, value));
    }

    public void doSetProperty(String propName, Object value) {
        if (value == null) {
            return;
        }
        if (TEST1_PROP.equalsIgnoreCase(propName)) {
            this.test1 = value.toString();
        } else if (TEST2_PROP.equalsIgnoreCase(propName)) {
            this.test2 = (Integer)value;
        } else if (TEST3_PROP.equalsIgnoreCase(propName)) {
            try {
                ByteArrayInputStream stream = new ByteArrayInputStream(value.toString().getBytes());
                this.deserialize(propName, stream);
                this.refreshNeeded = true;
            }
            catch (ExtendedElementException e) {
                e.printStackTrace();
                assert (false);
            }
        } else if (TEST5_PROP.equalsIgnoreCase(propName)) {
            this.test5 = value.toString();
        } else if (TEST6_PROP.equalsIgnoreCase(propName)) {
            this.test6 = value.toString();
        } else if (TEST7_PROP.equalsIgnoreCase(propName)) {
            this.test7 = value.toString();
        } else if (TYPE_RPOP.equalsIgnoreCase(propName)) {
            this.type = value.toString();
            this.refreshNeeded = true;
        } else if (RADIUS_RPOP.equalsIgnoreCase(propName)) {
            this.radius = (Integer)value;
        } else if (WIDTH_RPOP.equalsIgnoreCase(propName)) {
            this.width = (Integer)value;
        } else if (HEIGHT_RPOP.equalsIgnoreCase(propName)) {
            this.height = (Integer)value;
        } else if (X_SCALE_RPOP.equalsIgnoreCase(propName)) {
            this.xScale = (Integer)value;
        } else if (Y_SCALE_RPOP.equalsIgnoreCase(propName)) {
            this.yScale = (Integer)value;
        } else if (COMPANY_RPOP.equalsIgnoreCase(propName)) {
            this.company = value.toString();
        } else if (LINE_STYLE_PROP.equalsIgnoreCase(propName)) {
            this.lineStyle = value.toString();
        }
    }

    public IReportItem copy() {
        return null;
    }

    public IElementCommand getElementCommand(String propName, Object value) {
        return new ExtendedElementCommand(this.designHandle, this, propName, value);
    }

    private void execute(IElementCommand command) {
    }

    public IPropertyDefinition[] getPropertyDefinitions() {
        if (TYPE_PIE.equalsIgnoreCase(this.type)) {
            return this.piePropertyList;
        }
        return this.barPropertyList;
    }

    public boolean refreshPropertyDefinition() {
        if (this.refreshNeeded) {
            this.refreshNeeded = false;
            return true;
        }
        return false;
    }

    public IPropertyDefinition[] getMethods() {
        return null;
    }

    public IPropertyDefinition getScriptPropertyDefinition() {
        return null;
    }

    public List validate() {
        return null;
    }
}

