/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.perf;

import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.perf.APIPerfTestUtil;
import org.eclipse.birt.data.engine.perf.QueryInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="ignore performance test")
public class APIPerfTest2 {
    private APIPerfTestUtil perfTest = APIPerfTestUtil.newInstance();
    public static final String JDBC_DATA_SOURCE_TYPE = "org.eclipse.birt.report.data.oda.jdbc";
    public static final String JDBC_DATA_SET_TYPE = "org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet";

    @Before
    public void apiPerfSetUp() {
        System.setProperty("BIRT_HOME", "./test");
    }

    @Test
    public void testQueryWithJDBC() {
        QueryInfo queryInfo = new QueryInfo(){
            private String url = "jdbc:mysql://spmdb/test";
            private String driverClass = "com.mysql.jdbc.Driver";
            private String user = "root";
            private String password = "root";
            private String queryText = "select * from l_customer";
            private OdaDataSourceDesign odaDataSource;
            private OdaDataSetDesign odaDataSet;
            private QueryDefinition queryDefinition;
            private IBaseExpression[] expressionArray;
            private String[] exprNames;

            @Override
            public IBaseDataSourceDesign getDataSource() throws Exception {
                if (this.odaDataSource != null) {
                    return this.odaDataSource;
                }
                this.odaDataSource = new OdaDataSourceDesign("Test Data Source");
                this.odaDataSource.setExtensionID(APIPerfTest2.JDBC_DATA_SOURCE_TYPE);
                this.odaDataSource.addPublicProperty("odaURL", this.url);
                this.odaDataSource.addPublicProperty("odaDriverClass", this.driverClass);
                this.odaDataSource.addPublicProperty("odaUser", this.user);
                this.odaDataSource.addPublicProperty("odaPassword", this.password);
                return this.odaDataSource;
            }

            @Override
            public IBaseDataSetDesign getDataSet() throws Exception {
                if (this.odaDataSet != null) {
                    return this.odaDataSet;
                }
                this.odaDataSet = new OdaDataSetDesign("Test Data Set");
                this.odaDataSet.setDataSource(this.getDataSource().getName());
                this.odaDataSet.setExtensionID(APIPerfTest2.JDBC_DATA_SET_TYPE);
                this.odaDataSet.setQueryText(this.getQueryText());
                return this.odaDataSet;
            }

            @Override
            public QueryDefinition getQueryDefn() throws Exception {
                if (this.queryDefinition != null) {
                    return this.queryDefinition;
                }
                this.queryDefinition = new QueryDefinition();
                this.queryDefinition.setDataSetName(this.getDataSet().getName());
                this.expressionArray = new IBaseExpression[3];
                this.exprNames = new String[3];
                ScriptExpression expr = new ScriptExpression("dataSetRow.C_CUSTKEY");
                this.expressionArray[0] = expr;
                this.exprNames[0] = "C_CUSTKEY";
                expr = new ScriptExpression("dataSetRow.C_NAME");
                this.expressionArray[1] = expr;
                this.exprNames[1] = "C_NAME";
                expr = new ScriptExpression("dataSetRow.C_ACCTBAL");
                this.expressionArray[2] = expr;
                this.exprNames[2] = "C_ACCTBAL";
                int i = 0;
                while (i < this.expressionArray.length) {
                    this.queryDefinition.addResultSetExpression(this.exprNames[i], this.expressionArray[i]);
                    ++i;
                }
                this.furthurProcessQueryDefn(this.queryDefinition);
                return this.queryDefinition;
            }

            @Override
            public String[] getExprNames() {
                return this.exprNames;
            }

            private String getQueryText() {
                int maxRows = -1;
                if (maxRows > 0) {
                    return this.queryText + " where l_customer.C_CUSTKEY < " + maxRows;
                }
                return this.queryText;
            }

            private void furthurProcessQueryDefn(QueryDefinition queryDefn2) {
                boolean filter = true;
                boolean sorter = false;
                if (filter) {
                    int maxKey = 2;
                    FilterDefinition exprFilter = new FilterDefinition((IBaseExpression)new ScriptExpression("dataSetRow.C_CUSTKEY<" + maxKey));
                    queryDefn2.getFilters().add(exprFilter);
                }
                if (sorter) {
                    SortDefinition sd = new SortDefinition();
                    sd.setExpression("dataSetRow.C_ACCTBAL");
                    sd.setSortDirection(1);
                    queryDefn2.addSort(sd);
                }
            }
        };
        try {
            this.perfTest.setQueryInfo(queryInfo);
            boolean isTimeTest = true;
            boolean isSpaceTest = false;
            if (isTimeTest) {
                System.out.println("time bench mark of query");
                boolean isTimeAveValue = true;
                this.perfTest.runTimeBenchMark(isTimeAveValue);
            }
            if (isSpaceTest) {
                System.out.println("space bench mark of query");
                boolean isSpaceAveValue = true;
                this.perfTest.runSpaceBenchMark(isSpaceAveValue);
            }
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testQueryWithScript() {
        QueryInfo queryInfo = new QueryInfo(){
            private ScriptDataSourceDesign odaDataSource;
            private ScriptDataSetDesign odaDataSet;
            private QueryDefinition queryDefinition;
            private IBaseExpression[] expressionArray;
            private String[] exprNames;

            @Override
            public IBaseDataSourceDesign getDataSource() throws Exception {
                if (this.odaDataSource != null) {
                    return this.odaDataSource;
                }
                this.odaDataSource = new ScriptDataSourceDesign("JUST as place folder");
                return this.odaDataSource;
            }

            @Override
            public IBaseDataSetDesign getDataSet() throws Exception {
                if (this.odaDataSet != null) {
                    return this.odaDataSet;
                }
                this.odaDataSet = new ScriptDataSetDesign("ScriptedDataSet");
                this.odaDataSet.setDataSource(this.getDataSource().getName());
                this.odaDataSet.setOpenScript("count=300000;");
                this.odaDataSet.setFetchScript("if (count==0) {return false; } else { row.NUM=count; row.SQUARE=count*count; row.STR=\"row#\" + count; --count; return true; }");
                String[] scriptColumnNames = new String[]{"NUM", "SQUARE", "STR"};
                int[] scriptColumnTypes = new int[]{2, 3, 5};
                int i = 0;
                while (i < scriptColumnNames.length) {
                    ColumnDefinition colInfo = new ColumnDefinition(scriptColumnNames[i]);
                    colInfo.setDataType(scriptColumnTypes[i]);
                    this.odaDataSet.getResultSetHints().add(colInfo);
                    ++i;
                }
                return this.odaDataSet;
            }

            @Override
            public QueryDefinition getQueryDefn() throws Exception {
                if (this.queryDefinition != null) {
                    return this.queryDefinition;
                }
                this.queryDefinition = new QueryDefinition();
                this.queryDefinition.setDataSetName(this.getDataSet().getName());
                this.expressionArray = new IBaseExpression[3];
                this.exprNames = new String[3];
                ScriptExpression expr = new ScriptExpression("dataSetRow.NUM");
                this.expressionArray[0] = expr;
                this.exprNames[0] = "NUM";
                expr = new ScriptExpression("dataSetRow.SQUARE");
                this.expressionArray[1] = expr;
                this.exprNames[1] = "SQUARE";
                expr = new ScriptExpression("dataSetRow.STR");
                this.expressionArray[2] = expr;
                this.exprNames[2] = "STR";
                int i = 0;
                while (i < this.expressionArray.length) {
                    this.queryDefinition.addResultSetExpression(this.exprNames[i], this.expressionArray[i]);
                    ++i;
                }
                return this.queryDefinition;
            }

            @Override
            public String[] getExprNames() {
                return this.exprNames;
            }
        };
        try {
            this.perfTest.setQueryInfo(queryInfo);
            boolean isTimeTest = true;
            boolean isSpaceTest = false;
            if (isTimeTest) {
                System.out.println("time bench mark of query");
                boolean isTimeAveValue = true;
                this.perfTest.runTimeBenchMark(isTimeAveValue);
            }
            if (isSpaceTest) {
                System.out.println("space bench mark of query");
                boolean isSpaceAveValue = true;
                this.perfTest.runSpaceBenchMark(isSpaceAveValue);
            }
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

