/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.util;

import junit.framework.TestCase;
import org.eclipse.birt.chart.internal.model.ContinuedFraction;
import org.eclipse.birt.chart.internal.model.Fraction;
import org.eclipse.birt.chart.internal.model.FractionApproximator;

public class FractionTest
extends TestCase {
    public void testConstructorPrecise() {
        Fraction f = FractionApproximator.getExactFraction((double)0.02);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)50L);
        f = FractionApproximator.getExactFraction((double)0.333333333333);
        FractionTest.assertEquals((long)f.getNumerator(), (long)33333333L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100000000L);
        f = FractionApproximator.getExactFraction((double)-0.333333333333);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-33333333L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100000000L);
        f = FractionApproximator.getExactFraction((double)-0.33);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-33L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
    }

    public void testConstructorFixedNumerator() {
        Fraction f = FractionApproximator.getFractionWithNumerator((double)0.02, (long)2L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)2L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
        f = FractionApproximator.getFractionWithNumerator((double)2.0, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)2L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)1L);
        f = FractionApproximator.getFractionWithNumerator((double)3.5, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)7L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)2L);
        f = FractionApproximator.getFractionWithNumerator((double)3.5, (long)10L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)10L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)3L);
        f = FractionApproximator.getFractionWithNumerator((double)0.064, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)16L);
        f = FractionApproximator.getFractionWithNumerator((double)-0.064, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)-16L);
        f = FractionApproximator.getFractionWithNumerator((double)-0.064, (long)-1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)-1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)16L);
        f = FractionApproximator.getFractionWithNumerator((double)0.0, (long)1L);
        FractionTest.assertEquals((long)f.getNumerator(), (long)0L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)1L);
    }

    public void testConstructorMaxDigits() {
        Fraction f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)6L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)2);
        FractionTest.assertEquals((long)f.getNumerator(), (long)8L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)47L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.17, (int)3);
        FractionTest.assertEquals((long)f.getNumerator(), (long)17L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)100L);
        f = FractionApproximator.getFractionWithMaxDigits((double)0.33, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)3L);
        f = FractionApproximator.getFractionWithMaxDigits((double)-0.33, (int)1);
        FractionTest.assertEquals((long)f.getNumerator(), (long)1L);
        FractionTest.assertEquals((long)f.getDenominator(), (long)-3L);
    }

    public void testExactFration() {
        this.helpTestExactFraction(0.0, "0", "0");
        this.helpTestExactFraction(1.0, "1", "1");
        this.helpTestExactFraction(2.0, "2", "2");
        this.helpTestExactFraction(0.1, "0,10", "1/10");
        this.helpTestExactFraction(0.2, "0,5", "1/5");
        this.helpTestExactFraction(0.3, "0,3,3", "3/10");
        this.helpTestExactFraction(0.4, "0,2,2", "2/5");
        this.helpTestExactFraction(0.5, "0,2", "1/2");
        this.helpTestExactFraction(0.6, "0,1,1,2", "3/5");
        this.helpTestExactFraction(0.7, "0,1,2,3", "7/10");
        this.helpTestExactFraction(0.8, "0,1,4", "4/5");
        this.helpTestExactFraction(0.9, "0,1,9", "9/10");
        this.helpTestExactFraction(0.25, "0,4", "1/4");
        this.helpTestExactFraction(0.75, "0,1,3", "3/4");
        this.helpTestExactFraction(0.30000000000000004, "0,3,3", "3/10");
        this.helpTestExactFraction(0.7999999999999999, "0,1,4", "4/5");
        this.helpTestExactFraction(1.1, "1,10", "11/10");
        this.helpTestExactFraction(1.21, "1,4,1,3,5", "121/100");
        this.helpTestExactFraction(5.81, "5,1,4,3,1,4", "581/100");
        this.helpTestExactFraction(-1.1, "-1,-10", "-11/10");
        this.helpTestExactFraction(-121.0, "-121", "-121");
    }

    private void helpTestExactFraction(double decimal, String fractionListStr, String fractionStr) {
        ContinuedFraction cf = new ContinuedFraction(decimal);
        FractionTest.assertEquals((String)fractionListStr, (String)cf.toString());
        FractionTest.assertEquals((String)fractionStr, (String)cf.getExactFraction().toString());
    }

    public void testMaxDigitsFraction() {
        this.helpTestMaxDigitsFraction(0.0, "0", "0", 3);
        this.helpTestMaxDigitsFraction(1.0, "1", "1", 3);
        this.helpTestMaxDigitsFraction(2.0, "2", "2", 3);
        this.helpTestMaxDigitsFraction(0.333, "0,3,333", "1/3", 3);
        this.helpTestMaxDigitsFraction(0.353, "0,2,1,4,1,58", "6/17", 2);
        this.helpTestMaxDigitsFraction(0.353, "0,2,1,4,1,58", "6/17", 3);
        this.helpTestMaxDigitsFraction(0.353, "0,2,1,4,1,58", "353/1000", 4);
    }

    private void helpTestMaxDigitsFraction(double decimal, String fractionListStr, String fractionStr, int maxDigitsForDenominator) {
        ContinuedFraction cf = new ContinuedFraction(decimal);
        FractionTest.assertEquals((String)fractionListStr, (String)cf.toString());
        FractionTest.assertEquals((String)fractionStr, (String)cf.getFractionWithMaxDigits(maxDigitsForDenominator).toString());
    }

    public void testFixedNumberatorFraction() {
        this.helpTestFixedNumeratorFraction(0.0, "0", 1L);
        this.helpTestFixedNumeratorFraction(1.0, "1", 1L);
        this.helpTestFixedNumeratorFraction(2.0, "2", 1L);
        this.helpTestFixedNumeratorFraction(0.333, "1/3", 1L);
        this.helpTestFixedNumeratorFraction(0.333, "3/9", 3L);
        this.helpTestFixedNumeratorFraction(0.353, "1/3", 1L);
        this.helpTestFixedNumeratorFraction(0.353, "3/8", 3L);
    }

    private void helpTestFixedNumeratorFraction(double decimal, String fractionStr, long numerator) {
        FractionTest.assertEquals((String)fractionStr, (String)FractionApproximator.getFractionWithNumerator((double)decimal, (long)numerator).toString());
    }

    public void testToString() {
        Fraction f = FractionApproximator.getFractionWithNumerator((double)0.02, (long)2L);
        FractionTest.assertEquals((String)f.toString(":"), (String)"2:100");
        FractionTest.assertEquals((String)f.toString(), (String)"2/100");
        f = new Fraction(5L, 1L);
        FractionTest.assertEquals((String)f.toString(), (String)"5");
        f = new Fraction(-2L, 3L);
        FractionTest.assertEquals((String)f.toString(), (String)"-2/3");
        f = new Fraction(2L, -3L);
        FractionTest.assertEquals((String)f.toString(), (String)"-2/3");
        f = new Fraction(-2L, -3L);
        FractionTest.assertEquals((String)f.toString(), (String)"2/3");
    }

    public void testInvert() {
        Fraction f1 = new Fraction(1L, 3L);
        Fraction f2 = new Fraction(3L, 1L);
        f1.invert();
        FractionTest.assertEquals((long)f1.getDenominator(), (long)f2.getDenominator());
        FractionTest.assertEquals((long)f2.getNumerator(), (long)f1.getNumerator());
    }
}

