/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.ICascadingParameterGroup;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IParameterGroupDefn;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class IGetParameterDefinitionTaskTest
extends EngineCase {
    private String name = "IGetParameterDefinitionTaskTest.rptdesign";
    private String input = this.genInputFile(this.name);
    private IGetParameterDefinitionTask task = null;

    public IGetParameterDefinitionTaskTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IGetParameterDefinitionTaskTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT(this.name, this.name);
        IReportRunnable reportRunnable = this.engine.openReportDesign(this.input);
        this.task = this.engine.createGetParameterDefinitionTask(reportRunnable);
        this.task.setLocale(ULocale.ENGLISH);
        IGetParameterDefinitionTaskTest.assertTrue((this.task.getErrors().size() == 0 ? 1 : 0) != 0);
    }

    @Override
    protected void tearDown() throws Exception {
        this.task.close();
        super.tearDown();
        this.removeResource();
    }

    public void testGetParameterDefns() throws Exception {
        boolean includeParameterGroups = true;
        ArrayList params = (ArrayList)this.task.getParameterDefns(includeParameterGroups);
        IGetParameterDefinitionTaskTest.assertEquals((int)8, (int)params.size());
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(0) instanceof IScalarParameterDefn));
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(1) instanceof IScalarParameterDefn));
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(2) instanceof IScalarParameterDefn));
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(3) instanceof IParameterGroupDefn));
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(4) instanceof ICascadingParameterGroup));
        IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(5) instanceof ICascadingParameterGroup));
        includeParameterGroups = false;
        params = (ArrayList)this.task.getParameterDefns(includeParameterGroups);
        IGetParameterDefinitionTaskTest.assertEquals((int)14, (int)params.size());
        int i = 0;
        while (i < params.size()) {
            IGetParameterDefinitionTaskTest.assertTrue((boolean)(params.get(i) instanceof IScalarParameterDefn));
            ++i;
        }
        IGetParameterDefinitionTaskTest.assertEquals((String)"p1_string", (String)((IScalarParameterDefn)params.get(0)).getName());
        IGetParameterDefinitionTaskTest.assertEquals((int)0, (int)((IScalarParameterDefn)params.get(0)).getControlType());
        IGetParameterDefinitionTaskTest.assertEquals((String)"abc", (String)((IScalarParameterDefn)params.get(0)).getDefaultValue());
        IGetParameterDefinitionTaskTest.assertEquals((int)2, (int)((IScalarParameterDefn)params.get(1)).getSelectionListType());
        IGetParameterDefinitionTaskTest.assertEquals((int)1, (int)((IScalarParameterDefn)params.get(1)).getControlType());
        IGetParameterDefinitionTaskTest.assertEquals((int)1, (int)((IScalarParameterDefn)params.get(2)).getSelectionListType());
        IGetParameterDefinitionTaskTest.assertEquals((String)"p42_float", (String)((IScalarParameterDefn)params.get(4)).getName());
        IGetParameterDefinitionTaskTest.assertEquals((int)2, (int)((IScalarParameterDefn)params.get(4)).getDataType());
        IGetParameterDefinitionTaskTest.assertEquals((String)"p51", (String)((IScalarParameterDefn)params.get(5)).getName());
        IGetParameterDefinitionTaskTest.assertEquals((String)"p61_country", (String)((IScalarParameterDefn)params.get(7)).getName());
        IGetParameterDefinitionTaskTest.assertEquals((int)2, (int)((IScalarParameterDefn)params.get(10)).getSelectionListType());
    }

    public void testGetParameterDefn() throws Exception {
        IParameterDefnBase paramDefn = this.task.getParameterDefn("p1_string");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        IGetParameterDefinitionTaskTest.assertEquals((int)0, (int)paramDefn.getParameterType());
        IGetParameterDefinitionTaskTest.assertEquals((String)"scalar", (String)paramDefn.getTypeName());
        IGetParameterDefinitionTaskTest.assertEquals((long)6L, (long)paramDefn.getHandle().getID());
        paramDefn.getHandle().setDisplayName("STRINGParameter");
        IGetParameterDefinitionTaskTest.assertEquals((String)"STRINGParameter", (String)paramDefn.getHandle().getDisplayName());
        paramDefn = this.task.getParameterDefn("p2_static_dt");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        IGetParameterDefinitionTaskTest.assertEquals((int)0, (int)paramDefn.getParameterType());
        IGetParameterDefinitionTaskTest.assertEquals((String)"p2_static_dt", (String)paramDefn.getName());
        paramDefn = this.task.getParameterDefn("p3_dynamic_int");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        IGetParameterDefinitionTaskTest.assertEquals((int)0, (int)paramDefn.getParameterType());
        paramDefn = this.task.getParameterDefn("p4_group");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        IGetParameterDefinitionTaskTest.assertEquals((int)4, (int)paramDefn.getParameterType());
        IGetParameterDefinitionTaskTest.assertEquals((long)9L, (long)paramDefn.getHandle().getID());
        paramDefn = this.task.getParameterDefn("p41_decimal");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        paramDefn = this.task.getParameterDefn("p5_CascadingGroup_single");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        IGetParameterDefinitionTaskTest.assertEquals((int)5, (int)paramDefn.getParameterType());
        paramDefn = this.task.getParameterDefn("p51");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        paramDefn = this.task.getParameterDefn("p6_CascadingGroup_multiple");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        paramDefn = this.task.getParameterDefn("p62_customernumber");
        IGetParameterDefinitionTaskTest.assertNotNull((Object)paramDefn);
        paramDefn = this.task.getParameterDefn("invalid");
        IGetParameterDefinitionTaskTest.assertNull((Object)paramDefn);
        paramDefn = this.task.getParameterDefn(null);
        IGetParameterDefinitionTaskTest.assertNull((Object)paramDefn);
    }

    public void testSetValue() throws Exception {
        this.task.setValue("p1_string", (Object)"aaa");
        Date d = new Date();
        this.task.setValue("p2_static_dt", (Object)d);
    }

    public void testGetDefaultValues() throws Exception {
        HashMap values = this.task.getDefaultValues();
        IGetParameterDefinitionTaskTest.assertNotNull((Object)values);
        IGetParameterDefinitionTaskTest.assertEquals((int)14, (int)values.size());
        IGetParameterDefinitionTaskTest.assertEquals((Object)"abc", values.get("p1_string"));
        IGetParameterDefinitionTaskTest.assertEquals((String)"10251", (String)values.get("p3_dynamic_int").toString());
        IGetParameterDefinitionTaskTest.assertEquals((String)"2.35", (String)values.get("p41_decimal").toString());
        IGetParameterDefinitionTaskTest.assertEquals((String)"87.16", (String)values.get("p42_float").toString());
        this.setLocale(Locale.CHINA);
        IGetParameterDefinitionTaskTest.assertEquals(null, values.get("p51"));
        IGetParameterDefinitionTaskTest.assertEquals(null, values.get("p52"));
        IGetParameterDefinitionTaskTest.assertNull(values.get("p61_country"));
        IGetParameterDefinitionTaskTest.assertNull(values.get("p61_customernumber"));
        IGetParameterDefinitionTaskTest.assertNull(values.get("p61_orderno"));
    }

    public void testGetDefaultValue() throws Exception {
        IGetParameterDefinitionTaskTest.assertEquals((Object)"abc", (Object)this.task.getDefaultValue("p1_string"));
        IGetParameterDefinitionTaskTest.assertEquals((String)"10251", (String)this.task.getDefaultValue("p3_dynamic_int").toString());
        IGetParameterDefinitionTaskTest.assertEquals((String)"2.35", (String)this.task.getDefaultValue("p41_decimal").toString());
        IGetParameterDefinitionTaskTest.assertEquals((String)"87.16", (String)this.task.getDefaultValue("p42_float").toString());
    }

    public void testGetSelectionList() throws Exception {
        ArrayList selist = (ArrayList)this.task.getSelectionList("p2_static_dt");
        IParameterSelectionChoice se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertTrue((String)se.getValue().toString(), (boolean)se.getValue().toString().startsWith("Tue May 11 00:00:00"));
        se = (IParameterSelectionChoice)selist.get(1);
        IGetParameterDefinitionTaskTest.assertTrue((String)se.getValue().toString(), (boolean)se.getValue().toString().startsWith("Tue May 18 00:00:00"));
        selist = (ArrayList)this.task.getSelectionList("p3_dynamic_int");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10250", (String)se.getValue().toString());
        int listnumb = selist.size();
        IGetParameterDefinitionTaskTest.assertEquals((int)21, (int)listnumb);
        selist = (ArrayList)this.task.getSelectionList("p51");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"Shipped", (String)se.getValue().toString());
        this.task.setValue("p51", (Object)"Cancelled");
        selist = (ArrayList)this.task.getSelectionList("p52");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10253", (String)se.getValue().toString());
        this.task.setValue("p51", (Object)"Shipped");
        selist = (ArrayList)this.task.getSelectionList("p52");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10250", (String)se.getValue().toString());
        selist = (ArrayList)this.task.getSelectionList("p61_country");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"USA", (String)se.getValue().toString());
        this.task.setValue("p61_country", (Object)"UK");
        selist = (ArrayList)this.task.getSelectionList("p62_customernumber");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"187", (String)se.getValue().toString());
        Integer icustno = new Integer("240");
        this.task.setValue("p62_customernumber", (Object)icustno);
        selist = (ArrayList)this.task.getSelectionList("p63_orderno");
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10232", (String)se.getValue().toString());
        Integer iorderno = new Integer("10333");
        this.task.setValue("p63_orderno", (Object)iorderno);
    }

    public void testGetSelectionListForCascadingGroup() throws Exception {
        this.task.evaluateQuery("p5_CascadingGroup_single");
        ArrayList selist = (ArrayList)this.task.getSelectionListForCascadingGroup("p5_CascadingGroup_single", new Object[]{"Cancelled"});
        IParameterSelectionChoice se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10253", (String)se.getValue().toString());
        selist = (ArrayList)this.task.getSelectionListForCascadingGroup("p6_CascadingGroup_multiple", new Object[]{"UK"});
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"187", (String)se.getValue().toString());
        Integer icustnum = new Integer("187");
        selist = (ArrayList)this.task.getSelectionListForCascadingGroup("p6_CascadingGroup_multiple", new Object[]{"UK", icustnum});
        se = (IParameterSelectionChoice)selist.get(0);
        IGetParameterDefinitionTaskTest.assertEquals((String)"10110", (String)se.getValue().toString());
    }

    public void testGetSelectionListForCascadingMultiple() throws EngineException {
        String cpg1 = "NewCascadingParameterGroup";
        String[][] values1 = new String[][]{{"USA"}};
        Collection col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values1);
        IGetParameterDefinitionTaskTest.assertEquals((int)3, (int)col.size());
        values1 = new String[][]{{"France", "USA"}};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values1);
        IGetParameterDefinitionTaskTest.assertEquals((int)4, (int)col.size());
        values1 = new String[][]{{"France", "Germany", "Singapore", "USA"}};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values1);
        IGetParameterDefinitionTaskTest.assertEquals((int)6, (int)col.size());
        String[][] values2 = new String[][]{{"USA"}, {"CA", "NV"}};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values2);
        IGetParameterDefinitionTaskTest.assertEquals((int)3, (int)col.size());
        String[][] stringArrayArray = new String[2][];
        stringArrayArray[0] = new String[]{"France", "USA"};
        String[] stringArray = new String[3];
        stringArray[0] = "CA";
        stringArray[1] = "NV";
        stringArrayArray[1] = stringArray;
        values2 = stringArrayArray;
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values2);
        IGetParameterDefinitionTaskTest.assertEquals((int)5, (int)col.size());
        String[][] stringArrayArray2 = new String[2][];
        stringArrayArray2[0] = new String[]{"France", "Germany", "USA"};
        String[] stringArray2 = new String[3];
        stringArray2[0] = "CA";
        stringArray2[1] = "NV";
        stringArrayArray2[1] = stringArray2;
        values2 = stringArrayArray2;
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values2);
        IGetParameterDefinitionTaskTest.assertEquals((int)6, (int)col.size());
        String[][] values3 = new String[][]{{"France", "USA"}, {"CA", "NV"}};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values3);
        IGetParameterDefinitionTaskTest.assertEquals((int)3, (int)col.size());
        values3 = new String[][]{{"France", "USA"}, new String[1]};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values3);
        IGetParameterDefinitionTaskTest.assertEquals((int)2, (int)col.size());
        values3 = new String[][]{{"France", "Germany", "USA"}, new String[1]};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values3);
        IGetParameterDefinitionTaskTest.assertEquals((int)3, (int)col.size());
        values3 = new String[][]{{"USA"}, new String[1]};
        col = this.task.getSelectionListForCascadingGroup(cpg1, (Object[])values3);
        IGetParameterDefinitionTaskTest.assertEquals((int)0, (int)col.size());
    }

    public void testEvaluateQuery() throws Exception {
    }
}

