/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.TemplateDataSetHandle;
import org.eclipse.birt.report.model.api.TemplateElementHandle;
import org.eclipse.birt.report.model.api.TemplateParameterDefinitionHandle;
import org.eclipse.birt.report.model.api.TemplateReportItemHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.TemplateTransformEvent;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.util.BaseTestCase;
import org.eclipse.birt.report.model.util.XMLParserException;

public class TemplateElementParserTest
extends BaseTestCase {
    private final String parserFileName = "TemplateElementParserTest.xml";
    private final String errorFileName = "TemplateElementParserTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        TemplateParameterDefinitionHandle templateLabelParam = this.design.findTemplateParameterDefinition("templateLabelParam").handle((Module)this.design);
        TemplateElementParserTest.assertNotNull((Object)templateLabelParam);
        TemplateParameterDefinitionHandle templateDataSetParam = this.design.findTemplateParameterDefinition("templateDataSetParam").handle((Module)this.design);
        TemplateElementParserTest.assertNotNull((Object)templateDataSetParam);
        NameSpace ns = this.design.getNameHelper().getNameSpace("template");
        TemplateElementParserTest.assertEquals((Object)templateLabelParam.getElement(), (Object)ns.getElement("templateLabelParam"));
        TemplateElementParserTest.assertEquals((Object)templateDataSetParam.getElement(), (Object)ns.getElement("templateDataSetParam"));
        TemplateElementParserTest.assertEquals((String)"templateLabelParam", (String)templateLabelParam.getName());
        TemplateElementParserTest.assertEquals((String)"Label", (String)templateLabelParam.getAllowedType());
        TemplateElementParserTest.assertEquals((String)"click here to create label", (String)templateLabelParam.getDescription());
        TemplateElementParserTest.assertEquals((String)"description key", (String)templateLabelParam.getDescriptionKey());
        LabelHandle defaultLabel = (LabelHandle)templateLabelParam.getDefaultElement();
        TemplateElementParserTest.assertNotNull((Object)defaultLabel);
        TemplateElementParserTest.assertEquals((String)"base", (String)defaultLabel.getName());
        TemplateElementParserTest.assertEquals((String)"6mm", (String)defaultLabel.getX().getStringValue());
        TemplateElementParserTest.assertEquals((String)"0.5mm", (String)defaultLabel.getY().getStringValue());
        TemplateElementParserTest.assertEquals((String)"0.25mm", (String)defaultLabel.getHeight().getStringValue());
        TemplateElementParserTest.assertEquals((String)"1mm", (String)defaultLabel.getWidth().getStringValue());
        TemplateElementParserTest.assertEquals((String)"templateDataSetParam", (String)templateDataSetParam.getName());
        TemplateElementParserTest.assertEquals((String)"DataSet", (String)templateDataSetParam.getAllowedType());
        TemplateElementParserTest.assertEquals((String)"click here to create data set", (String)templateDataSetParam.getDescription());
        TemplateElementParserTest.assertEquals((String)"description key", (String)templateDataSetParam.getDescriptionKey());
        ScriptDataSetHandle defaultDataSet = (ScriptDataSetHandle)templateDataSetParam.getDefaultElement();
        TemplateElementParserTest.assertNotNull((Object)defaultDataSet);
        TemplateElementParserTest.assertEquals((String)"firstDataSet", (String)defaultDataSet.getName());
        TemplateElementParserTest.assertEquals((String)"myDataSource", (String)defaultDataSet.getDataSource().getName());
        TemplateElementParserTest.assertEquals((String)"open script", (String)defaultDataSet.getOpen());
        TemplateElementParserTest.assertEquals((String)"close script", (String)defaultDataSet.getClose());
        TemplateElementParserTest.assertFalse((defaultLabel == this.designHandle.findElement(defaultLabel.getName()) ? 1 : 0) != 0);
        TemplateElementParserTest.assertNotNull((Object)this.designHandle.findElement(defaultLabel.getName()));
        TemplateElementParserTest.assertFalse((defaultDataSet == this.designHandle.findDataSet(defaultDataSet.getName()) ? 1 : 0) != 0);
        TemplateElementParserTest.assertNotNull((Object)this.designHandle.findDataSet(defaultDataSet.getName()));
        TemplateDataSetHandle templateDataSet = this.designHandle.findTemplateDataSet("templateDataSet");
        TemplateElementParserTest.assertNotNull((Object)templateDataSet);
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)this.designHandle.findElement("templateLabel");
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        TemplateElementParserTest.assertEquals((Object)templateDataSet.getElement(), (Object)this.design.getNameHelper().getNameSpace("dataset").getElement("templateDataSet"));
        TemplateElementParserTest.assertEquals((Object)templateLabel.getElement(), (Object)this.design.getNameHelper().getNameSpace("element").getElement("templateLabel"));
        TemplateElementParserTest.assertEquals((String)"templateDataSet", (String)templateDataSet.getName());
        ElementRefValue refTemplateParam = (ElementRefValue)templateDataSet.getElement().getProperty((Module)this.design, "refTemplateParameter");
        TemplateElementParserTest.assertNotNull((Object)refTemplateParam);
        TemplateElementParserTest.assertEquals((Object)templateDataSetParam.getElement(), (Object)refTemplateParam.getElement());
        TemplateElementParserTest.assertEquals((Object)templateDataSetParam.getName(), (Object)templateDataSet.getProperty("refTemplateParameter"));
        TemplateElementParserTest.assertEquals((String)"DataSet", (String)templateDataSet.getAllowedType());
        TemplateElementParserTest.assertEquals((String)"click here to create data set", (String)templateDataSet.getDescription());
        TemplateElementParserTest.assertEquals((String)"description key", (String)templateDataSet.getDescriptionKey());
        TemplateElementParserTest.assertEquals((Object)defaultDataSet, (Object)templateDataSet.getDefaultElement());
        TemplateElementParserTest.assertEquals((String)"templateLabel", (String)templateLabel.getName());
        TemplateElementParserTest.assertTrue((boolean)templateLabel.visibilityRulesIterator().hasNext());
        TemplateElementParserTest.assertEquals((String)"all", (String)((StructureHandle)templateLabel.visibilityRulesIterator().next()).getMember("format").getStringValue());
        TemplateElementParserTest.assertEquals((String)"1+1=3", (String)((StructureHandle)templateLabel.visibilityRulesIterator().next()).getMember("valueExpr").getStringValue());
        TemplateElementParserTest.assertEquals((String)"display name key", (String)templateLabel.getDisplayNameKey());
        TemplateElementParserTest.assertEquals((String)"display name", (String)templateLabel.getDisplayName());
        List userProps = templateLabel.getUserProperties();
        TemplateElementParserTest.assertEquals((int)2, (int)userProps.size());
        UserPropertyDefn userPropDefn = (UserPropertyDefn)userProps.get(0);
        TemplateElementParserTest.assertEquals((String)"myProp1", (String)userPropDefn.getName());
        TemplateElementParserTest.assertEquals((int)0, (int)userPropDefn.getTypeCode());
        TemplateElementParserTest.assertEquals((Object)"world", (Object)templateLabel.getProperty("myProp1"));
        userPropDefn = (UserPropertyDefn)userProps.get(1);
        TemplateElementParserTest.assertEquals((String)"myProp2", (String)userPropDefn.getName());
        TemplateElementParserTest.assertEquals((int)5, (int)userPropDefn.getTypeCode());
        TemplateElementParserTest.assertEquals((Object)"always", (Object)templateLabel.getProperty("myProp2"));
        refTemplateParam = (ElementRefValue)templateLabel.getElement().getProperty((Module)this.design, "refTemplateParameter");
        TemplateElementParserTest.assertNotNull((Object)refTemplateParam);
        TemplateElementParserTest.assertEquals((Object)templateLabelParam.getElement(), (Object)refTemplateParam.getElement());
        TemplateElementParserTest.assertEquals((Object)templateLabelParam.getName(), (Object)templateLabel.getProperty("refTemplateParameter"));
        TemplateElementParserTest.assertEquals((String)"Label", (String)templateLabel.getAllowedType());
        TemplateElementParserTest.assertEquals((String)"click here to create label", (String)templateLabel.getDescription());
        TemplateElementParserTest.assertEquals((String)"description key", (String)templateLabel.getDescriptionKey());
        TemplateElementParserTest.assertEquals((Object)defaultLabel, (Object)templateLabel.getDefaultElement());
        TemplateParameterDefinition templateParam = (TemplateParameterDefinition)templateDataSetParam.getElement();
        TemplateElementParserTest.assertEquals((int)1, (int)templateParam.getClientList().size());
        TemplateElementParserTest.assertEquals((Object)templateDataSet.getElement(), (Object)((BackRef)templateParam.getClientList().get(0)).getElement());
        templateParam = (TemplateParameterDefinition)templateLabelParam.getElement();
        TemplateElementParserTest.assertEquals((int)1, (int)templateParam.getClientList().size());
        TemplateElementParserTest.assertEquals((Object)templateLabel.getElement(), (Object)((BackRef)templateParam.getClientList().get(0)).getElement());
    }

    public void testWriter() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        TemplateParameterDefinitionHandle templateLabelParam = this.design.findTemplateParameterDefinition("templateLabelParam").handle((Module)this.design);
        TemplateElementParserTest.assertNotNull((Object)templateLabelParam);
        templateLabelParam.setName("new templateLabelParam");
        templateLabelParam.setDescription("click here to create new label");
        templateLabelParam.setDescriptionKey("new description key");
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)this.designHandle.findElement("templateLabel");
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        templateLabel.setName("new templateLabel");
        templateLabel.setProperty("refTemplateParameter", (Object)"new templateLabelParam");
        this.save();
        TemplateElementParserTest.assertTrue((boolean)this.compareFile("TemplateElementParserTest_golden.xml"));
    }

    public void testErrors() throws Exception {
        try {
            this.openDesign("TemplateElementParserTest_1.xml");
            TemplateElementParserTest.fail();
        }
        catch (DesignFileException e) {
            TemplateElementParserTest.assertEquals((String)"Error.DesignFileException.SYNTAX_ERROR", (String)e.getErrorCode());
            TemplateElementParserTest.assertEquals((int)2, (int)e.getExceptionList().size());
            TemplateElementParserTest.assertTrue((boolean)(e.getExceptionList().get(0) instanceof XMLParserException));
            XMLParserException exception = (XMLParserException)e.getExceptionList().get(0);
            TemplateElementParserTest.assertTrue((boolean)(exception.getException() instanceof DesignParserException));
            DesignParserException cause = (DesignParserException)exception.getException();
            TemplateElementParserTest.assertEquals((String)"Error.DesignParserException.MISSING_TEMPLATE_PARAMETER_DEFAULT", (String)cause.getErrorCode());
            TemplateElementParserTest.assertTrue((boolean)(e.getExceptionList().get(1) instanceof XMLParserException));
            exception = (XMLParserException)e.getExceptionList().get(1);
            TemplateElementParserTest.assertTrue((boolean)(exception.getException() instanceof DesignParserException));
            cause = (DesignParserException)exception.getException();
            TemplateElementParserTest.assertEquals((String)"Error.DesignParserException.INCONSISTENT_TEMPLATE_ELEMENT_TYPE", (String)cause.getErrorCode());
        }
    }

    public void testCreateTemplate() throws Exception {
        TemplateDataSetHandle templateDataSet;
        this.openDesign("TemplateElementParserTest.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        ActivityStack stack = this.design.getActivityStack();
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("base");
        TemplateElementParserTest.assertNotNull((Object)labelHandle);
        String name = "label";
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)labelHandle.createTemplateElement(name);
        this.save();
        this.compareFile("TemplateElementParserTest_golden_1.xml");
        TemplateParameterDefinition templateParam = this.design.findTemplateParameterDefinition("NewTemplateParameterDefinition");
        TemplateElementParserTest.assertNotNull((Object)templateParam);
        TemplateElementParserTest.assertEquals((Object)templateLabel, (Object)this.designHandle.findElement(name));
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        labelHandle = (LabelHandle)this.designHandle.findElement("base");
        TemplateElementParserTest.assertNull((Object)labelHandle);
        stack.undo();
        templateLabel = (TemplateReportItemHandle)this.designHandle.findElement(name);
        TemplateElementParserTest.assertNull((Object)templateLabel);
        labelHandle = (LabelHandle)this.designHandle.findElement("base");
        TemplateElementParserTest.assertNotNull((Object)labelHandle);
        stack.redo();
        templateLabel = (TemplateReportItemHandle)this.designHandle.findElement(name);
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        labelHandle = (LabelHandle)this.designHandle.findElement("base");
        TemplateElementParserTest.assertNull((Object)labelHandle);
        GridHandle gridHandle = this.designHandle.getElementFactory().newGridItem("grid", 1, 1);
        TemplateElementParserTest.assertNotNull((Object)gridHandle);
        CellHandle cellHandle = gridHandle.getCell(1, 1);
        TemplateElementParserTest.assertNotNull((Object)cellHandle);
        labelHandle = this.designHandle.getElementFactory().newLabel("cellLabel");
        TemplateElementParserTest.assertNotNull((Object)labelHandle);
        cellHandle.getContent().add((DesignElementHandle)labelHandle);
        this.designHandle.getBody().add((DesignElementHandle)gridHandle);
        MyListener listener = new MyListener();
        cellHandle.addListener((Listener)listener);
        TemplateElementParserTest.assertEquals((Object)cellHandle, (Object)labelHandle.getContainer());
        templateLabel = (TemplateReportItemHandle)labelHandle.createTemplateElement(labelHandle.getName());
        TemplateElementParserTest.assertEquals((Object)templateLabel, (Object)this.designHandle.findElement(labelHandle.getName()));
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        TemplateElementParserTest.assertEquals((int)17, (int)listener.event.getEventType());
        TemplateElementParserTest.assertEquals((Object)cellHandle, (Object)listener.focus);
        TemplateTransformEvent ttEvent = (TemplateTransformEvent)listener.event;
        TemplateElementParserTest.assertEquals((Object)labelHandle.getElement(), (Object)ttEvent.getFrom());
        TemplateElementParserTest.assertEquals((Object)templateLabel.getElement(), (Object)ttEvent.getTo());
        TemplateElementParserTest.assertEquals((int)0, (int)ttEvent.getSlot());
        TemplateElementParserTest.assertEquals((Object)cellHandle.getElement(), (Object)ttEvent.getTarget());
        name = "templateDataSet";
        ScriptDataSetHandle dataSetHandle = this.designHandle.getElementFactory().newScriptDataSet("dataSet");
        try {
            templateDataSet = (TemplateDataSetHandle)dataSetHandle.createTemplateElement(name);
            TemplateElementParserTest.fail();
        }
        catch (SemanticException e) {
            TemplateElementParserTest.assertEquals((String)"Error.TemplateException.CREATE_TEMPLATE_ELEMENT_FORBIDDEN", (String)e.getErrorCode());
        }
        this.designHandle.getDataSets().add((DesignElementHandle)dataSetHandle);
        TemplateElementParserTest.assertNotNull((Object)this.designHandle.findTemplateDataSet(name));
        templateDataSet = (TemplateDataSetHandle)dataSetHandle.createTemplateElement(name);
        TemplateElementParserTest.assertNotNull((Object)templateDataSet);
        TemplateElementParserTest.assertEquals((Object)templateDataSet.getElement(), (Object)this.designHandle.findTemplateDataSet("templateDataSet1"));
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        this.designHandle.getStyles().add((DesignElementHandle)style);
        try {
            style.createTemplateElement("page");
            TemplateElementParserTest.fail();
        }
        catch (SemanticException e) {
            TemplateElementParserTest.assertEquals((String)"Error.TemplateException.INVALID_TEMPLATE_ELEMENT_TYPE", (String)e.getErrorCode());
        }
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.libraryHandle = session.createLibrary();
        labelHandle = this.libraryHandle.getElementFactory().newLabel("label");
        this.libraryHandle.getComponents().add((DesignElementHandle)labelHandle);
        try {
            labelHandle.createTemplateElement(null);
            TemplateElementParserTest.fail();
        }
        catch (SemanticException e) {
            TemplateElementParserTest.assertEquals((String)"Error.TemplateException.TEMPLATE_ELEMENT_NOT_SUPPORTED", (String)e.getErrorCode());
        }
    }

    public void testParserWithNoName() throws Exception {
        this.openDesign("TemplateElementParserTest_4.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
    }

    public void testTransformTemplate() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        TemplateDataSetHandle templateDataSet = this.designHandle.findTemplateDataSet("templateDataSet");
        TemplateElementParserTest.assertNotNull((Object)templateDataSet);
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)this.designHandle.findElement("templateLabel");
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        ScriptDataSetHandle dataSet = this.designHandle.getElementFactory().newScriptDataSet("dataSet");
        ActivityStack stack = this.design.getActivityStack();
        templateDataSet.transformToDataSet((DataSetHandle)dataSet);
        TemplateElementParserTest.assertEquals((Object)dataSet.getElement(), (Object)this.designHandle.findDataSet(dataSet.getName()));
        TemplateElementParserTest.assertNull((Object)this.designHandle.findTemplateDataSet(templateDataSet.getName()));
        TemplateElementParserTest.assertNull((Object)templateDataSet.getContainer());
        TemplateElementParserTest.assertEquals((String)"templateDataSetParam", (String)dataSet.getElement().getTemplateParameterElement((Module)this.design).getName());
        stack.undo();
        TemplateElementParserTest.assertNull((Object)this.designHandle.findDataSet(dataSet.getName()));
        TemplateElementParserTest.assertEquals((Object)templateDataSet, (Object)this.designHandle.findTemplateDataSet(templateDataSet.getName()));
        TemplateElementParserTest.assertEquals((Object)this.designHandle, (Object)templateDataSet.getContainer());
        try {
            templateDataSet.setProperty("refTemplateParameter", null);
            templateDataSet.transformToDataSet((DataSetHandle)dataSet);
            TemplateElementParserTest.fail();
        }
        catch (SemanticException e) {
            TemplateElementParserTest.assertEquals((String)"Error.TemplateException.TRANSFORM_TO_DATA_SET_FORBIDDEN", (String)e.getErrorCode());
        }
        MyListener listener = new MyListener();
        templateLabel.addListener((Listener)listener);
        templateLabel.transformToReportItem((ReportItemHandle)label);
        TemplateElementParserTest.assertNull((Object)listener.event);
        TemplateElementParserTest.assertNull((Object)templateLabel.getContainer());
        TemplateElementParserTest.assertEquals((Object)label.getElement(), (Object)this.designHandle.findElement(label.getName()));
        TemplateElementParserTest.assertNull((Object)this.designHandle.findElement(templateLabel.getName()));
        TemplateElementParserTest.assertNull((Object)templateLabel.getContainer());
        TemplateElementParserTest.assertEquals((String)"templateLabelParam", (String)label.getElement().getTemplateParameterElement((Module)this.design).getName());
    }

    public void testRevertToTemplate() throws Exception {
        this.openDesign("TemplateElementParserTest_3.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        LabelHandle label = (LabelHandle)this.designHandle.findElement("label");
        TemplateElementParserTest.assertNotNull((Object)label);
        TemplateElementParserTest.assertEquals((String)"templateLabelParam", (String)label.getElement().getTemplateParameterElement((Module)this.design).getName());
        ScriptDataSetHandle dataSet = (ScriptDataSetHandle)this.designHandle.findDataSet("dataSet");
        TemplateElementParserTest.assertNotNull((Object)dataSet);
        TemplateElementParserTest.assertEquals((String)"templateDataSetParam", (String)dataSet.getElement().getTemplateParameterElement((Module)this.design).getName());
        TemplateElementHandle templateHandle = label.revertToTemplate("templateLabel");
        TemplateElementParserTest.assertNotNull((Object)templateHandle);
        TemplateElementParserTest.assertTrue((boolean)(templateHandle instanceof TemplateReportItemHandle));
        TemplateElementParserTest.assertEquals((String)"templateLabelParam", (String)templateHandle.getElement().getTemplateParameterElement((Module)this.design).getName());
        templateHandle = dataSet.revertToTemplate("templateDatSet");
        TemplateElementParserTest.assertNotNull((Object)templateHandle);
        TemplateElementParserTest.assertTrue((boolean)(templateHandle instanceof TemplateDataSetHandle));
        TemplateElementParserTest.assertEquals((String)"templateDataSetParam", (String)templateHandle.getElement().getTemplateParameterElement((Module)this.design).getName());
    }

    public void testComplexCreateTemplate() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        GridHandle gridHandle = this.designHandle.getElementFactory().newGridItem("grid", 3, 1);
        CellHandle cellHandle = gridHandle.getCell(1, 1);
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label");
        cellHandle.addElement((DesignElementHandle)labelHandle, 0);
        this.designHandle.addElement((DesignElementHandle)gridHandle, 6);
        TemplateReportItemHandle templateLabel = (TemplateReportItemHandle)labelHandle.createTemplateElement("templateLabel3");
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        TemplateReportItemHandle templateGrid = (TemplateReportItemHandle)gridHandle.createTemplateElement("templateGrid");
        TemplateElementParserTest.assertNotNull((Object)templateGrid);
    }

    public void testDestroyTemplateParameterDefinition() throws Exception {
        this.designHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null).createDesign();
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("label");
        TemplateElementParserTest.assertNotNull((Object)labelHandle);
        ContainerSlot templateParams = this.designHandle.getElement().getSlot(8);
        TemplateElementParserTest.assertEquals((int)0, (int)templateParams.getCount());
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        TemplateElementHandle templateLabel = labelHandle.createTemplateElement("templateLabel");
        TemplateElementParserTest.assertNotNull((Object)templateLabel);
        TemplateElementParserTest.assertEquals((Object)this.designHandle, (Object)templateLabel.getRoot());
        TemplateElementParserTest.assertEquals((int)1, (int)templateParams.getCount());
        templateLabel.drop();
        this.designHandle.checkReport();
        TemplateElementParserTest.assertEquals((int)0, (int)templateParams.getCount());
    }

    public void testCheckAdd() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        TemplateElementParserTest.assertNotNull((Object)this.designHandle);
        LabelHandle label = this.designHandle.getElementFactory().newLabel(null);
        label.setProperty("refTemplateParameter", (Object)"templateLabelParam");
        this.designHandle.getBody().add((DesignElementHandle)label);
        TemplateElementParserTest.assertEquals((Object)this.designHandle, (Object)label.getContainer());
        TemplateElementParserTest.assertEquals((Object)"templateLabelParam", (Object)label.getProperty("refTemplateParameter"));
        TableHandle table = this.designHandle.getElementFactory().newTableItem(null);
        table.setProperty("refTemplateParameter", (Object)"templateLabelParam");
        this.designHandle.getBody().add((DesignElementHandle)table);
        TemplateElementParserTest.assertEquals((Object)this.designHandle, (Object)table.getContainer());
        TemplateElementParserTest.assertNull((Object)table.getProperty("refTemplateParameter"));
        label = this.designHandle.getElementFactory().newLabel(null);
        label.setProperty("refTemplateParameter", (Object)"NonexisttemplateLabelParam");
        this.designHandle.getBody().add((DesignElementHandle)label);
        TemplateElementParserTest.assertEquals((Object)this.designHandle, (Object)label.getContainer());
        TemplateElementParserTest.assertNull((Object)label.getProperty("refTemplateParameter"));
    }

    public void testCanTransformToTemplateForReportItem() throws Exception {
        this.openDesign("TemplateElementParserTest.xml");
        SimpleMasterPageHandle masterPage = (SimpleMasterPageHandle)this.designHandle.getMasterPages().get(0);
        AutoTextHandle autoText = this.designHandle.getElementFactory().newAutoText("test");
        masterPage.getPageHeader().dropAndClear(0);
        masterPage.getPageHeader().add((DesignElementHandle)autoText);
        TemplateElementParserTest.assertFalse((boolean)autoText.canTransformToTemplate());
    }

    class MyListener
    implements Listener {
        NotificationEvent event = null;
        DesignElementHandle focus = null;

        MyListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.event = ev;
            this.focus = focus;
        }
    }
}

