/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class MasterPageParseTest
extends BaseTestCase {
    private String fileName = "MasterPageParseTest.xml";
    private String simpleMasterPageFile = "SimpleMasterPageTest.xml";
    private String goldenFileName = "MasterPageParseTest_golden.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParser() throws Exception {
        this.openDesign(this.fileName);
        List errors = this.design.getErrorList();
        MasterPageParseTest.assertTrue((boolean)errors.isEmpty());
        GraphicMasterPageHandle page = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        MasterPageParseTest.assertNotNull((Object)page);
        MasterPageParseTest.assertEquals((String)"us-letter", (String)page.getPageType());
        MasterPageParseTest.assertEquals((String)"portrait", (String)page.getOrientation());
        MasterPageParseTest.assertEquals((int)2, (int)page.getColumnCount());
        MasterPageParseTest.assertEquals((String)"2mm", (String)page.getColumnSpacing().getStringValue());
        MasterPageParseTest.assertEquals((String)"yellow", (String)page.getPrivateStyle().getBackgroundColor().getStringValue());
        MasterPageParseTest.assertEquals((String)"red", (String)page.getPrivateStyle().getColor().getStringValue());
        MasterPageParseTest.assertEquals((String)"12mm", (String)page.getPrivateStyle().getFontSize().getStringValue());
        MasterPageParseTest.assertEquals((String)"1in", (String)page.getTopMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"2in", (String)page.getBottomMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"1in", (String)page.getLeftMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"2in", (String)page.getRightMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"script of onPageStart", (String)page.getOnPageStart());
        MasterPageParseTest.assertEquals((String)"script of onPageEnd", (String)page.getOnPageEnd());
        SimpleMasterPageHandle simplePage = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Simple MasterPage");
        MasterPageParseTest.assertEquals((String)"0.25in", (String)simplePage.getTopMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"0.25in", (String)simplePage.getBottomMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"0.25in", (String)simplePage.getLeftMargin().getStringValue());
        MasterPageParseTest.assertEquals((String)"0.25in", (String)simplePage.getRightMargin().getStringValue());
    }

    public void testWriter() throws Exception {
        this.openDesign(this.fileName);
        GraphicMasterPageHandle page = (GraphicMasterPageHandle)this.designHandle.findMasterPage("My Page");
        page.setColumnCount(5);
        MasterPageParseTest.assertEquals((int)5, (int)page.getColumnCount());
        MasterPageParseTest.assertEquals((String)"2mm", (String)page.getColumnSpacing().getStringValue());
        page.setOrientation("landscape");
        page.setPageType("us-legal");
        page.setOnPageStart("new script of onPageStart");
        page.setOnPageEnd("new script of onPageEnd");
        this.save();
        MasterPageParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSimpleMasterPage() throws Exception {
        this.openDesign(this.simpleMasterPageFile);
        SimpleMasterPageHandle simplePage = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Simple Page");
        simplePage.setOrientation("landscape");
        MasterPageParseTest.assertEquals((String)"landscape", (String)simplePage.getOrientation());
        simplePage.setName("New Simple Page");
        MasterPageParseTest.assertEquals((String)"New Simple Page", (String)simplePage.getName());
        MasterPageParseTest.assertEquals((String)"2.4cm", (String)simplePage.getHeaderHeight().getValue().toString());
        MasterPageParseTest.assertEquals((String)"1.2cm", (String)simplePage.getFooterHeight().getValue().toString());
        this.save();
        MasterPageParseTest.assertTrue((boolean)this.compareFile("TestSimpleMasterPage_golden.xml"));
    }

    public void testMasterPageContainment() throws Exception {
        block7: {
            TableHandle table;
            GridHandle grid;
            SimpleMasterPageHandle simplePage;
            block6: {
                this.openDesign(this.simpleMasterPageFile);
                simplePage = (SimpleMasterPageHandle)this.designHandle.findMasterPage("Simple Page");
                simplePage.getPageHeader().drop(0);
                try {
                    grid = this.designHandle.getElementFactory().newGridItem("grid", 1, 1);
                    table = this.designHandle.getElementFactory().newTableItem("table");
                    grid.getCell(1, 1).getContent().add((DesignElementHandle)table);
                    simplePage.getPageHeader().add((DesignElementHandle)grid);
                    MasterPageParseTest.fail();
                }
                catch (ContentException e) {
                    MasterPageParseTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
                }
                catch (NameException e) {
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError();
                }
            }
            try {
                grid = this.designHandle.getElementFactory().newGridItem("grid", 1, 1);
                table = this.designHandle.getElementFactory().newTableItem("table");
                simplePage.getPageHeader().add((DesignElementHandle)grid);
                grid.getCell(1, 1).getContent().add((DesignElementHandle)table);
                MasterPageParseTest.fail();
            }
            catch (ContentException e) {
                MasterPageParseTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)e.getErrorCode());
            }
            catch (NameException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
    }

    public void testSemanticError() throws Exception {
        String checkFileName1 = "MasterPageParseTest_1.xml";
        String checkFileName2 = "MasterPageParseTest_2.xml";
        String checkFileName3 = "MasterPageParseTest_3.xml";
        String checkFileName4 = "MasterPageParseTest_4.xml";
        String checkFileName5 = "MasterPageParseTest_5.xml";
        String checkFileName6 = "MasterPageParseTest_6.xml";
        this.openDesign(checkFileName1);
        List errors = this.design.getErrorList();
        int i = 0;
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(i++);
        MasterPageParseTest.assertEquals((String)"Second Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.INVALID_PAGE_SIZE", (String)error.getErrorCode());
        this.openDesign(checkFileName2);
        errors = this.design.getErrorList();
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        error = (ErrorDetail)errors.get(0);
        MasterPageParseTest.assertEquals((String)"Third Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.INVALID_PAGE_MARGINS", (String)error.getErrorCode());
        this.openDesign(checkFileName3);
        errors = this.design.getErrorList();
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        error = (ErrorDetail)errors.get(0);
        MasterPageParseTest.assertEquals((String)"Forth Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.INVALID_PAGE_MARGINS", (String)error.getErrorCode());
        this.openDesign(checkFileName4);
        errors = this.design.getErrorList();
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        error = (ErrorDetail)errors.get(0);
        MasterPageParseTest.assertEquals((String)"Fifth Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.INVALID_MULTI_COLUMN", (String)error.getErrorCode());
        this.openDesign(checkFileName5);
        errors = this.design.getErrorList();
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        error = (ErrorDetail)errors.get(0);
        MasterPageParseTest.assertEquals((String)"Sixth Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.MISSING_PAGE_SIZE", (String)error.getErrorCode());
        this.openDesign(checkFileName6);
        errors = this.design.getErrorList();
        MasterPageParseTest.assertEquals((int)1, (int)errors.size());
        error = (ErrorDetail)errors.get(0);
        MasterPageParseTest.assertEquals((String)"My Page", (String)error.getElement().getName());
        MasterPageParseTest.assertEquals((String)"Error.SemanticError.INVALID_MASTER_PAGE_CONTEXT_CONTAINMENT", (String)error.getErrorCode());
    }
}

