/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryWithCubeTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testLoadCube() throws Exception {
        this.openDesign("LibraryWithCubeTest.xml");
        CubeHandle cubeHandle = (CubeHandle)this.designHandle.getCubes().get(0);
        LibraryWithCubeTest.assertNotNull((Object)cubeHandle.getMeasure("QUANTITY_PRICE"));
        LibraryWithCubeTest.assertNotNull((Object)cubeHandle.getMeasure("QUANTITY"));
    }

    public void writeExtendedCube() throws Exception {
        this.openLibrary("LibraryWithCubeTest_Lib.xml");
        CubeHandle cubeHandle = (CubeHandle)this.libraryHandle.getAllCubes().get(0);
        this.openDesign("BlankLibraryWithCubeTest.xml");
        CubeHandle newCubeHandle = (CubeHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)cubeHandle, "extenedCube");
        this.designHandle.getCubes().add((DesignElementHandle)newCubeHandle);
        this.save();
        LibraryWithCubeTest.assertTrue((boolean)this.compareFile("LibraryWithCubeTest.xml"));
    }

    public void resolveLibraryOLAP() throws Exception {
        this.openDesign("LibraryWithCubeTest1.xml");
        ExtendedItemHandle tmpElement = (ExtendedItemHandle)this.designHandle.findElement("NewDimension View11");
        ElementRefValue refValue = (ElementRefValue)tmpElement.getElement().getProperty((Module)this.design, "dimension");
        LibraryWithCubeTest.assertTrue((boolean)refValue.isResolved());
        LibraryWithCubeTest.assertNotNull((Object)refValue.getLibraryNamespace());
        tmpElement = (ExtendedItemHandle)this.designHandle.findElement("NewLevel View11");
        refValue = (ElementRefValue)tmpElement.getElement().getProperty((Module)this.design, "dimension");
        LibraryWithCubeTest.assertTrue((boolean)refValue.isResolved());
        LibraryWithCubeTest.assertNotNull((Object)refValue.getLibraryNamespace());
    }
}

