/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.EmbeddedImageHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryStructureTest
extends BaseTestCase {
    public void testLibReference() throws Exception {
        this.openDesign("LibraryStructureTest.xml");
        LibraryStructureTest.assertNotNull((Object)this.designHandle);
        List images = this.designHandle.getListProperty("images");
        LibraryStructureTest.assertEquals((int)2, (int)images.size());
        EmbeddedImage image = this.designHandle.findImage("design image2");
        LibraryStructureTest.assertNotNull((Object)image);
        StructRefValue libReference = (StructRefValue)image.getProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)libReference);
        LibraryStructureTest.assertTrue((boolean)libReference.isResolved());
        LibraryHandle includeLib = this.designHandle.getLibrary("Lib1");
        LibraryStructureTest.assertNotNull((Object)includeLib);
        EmbeddedImage includeImage = includeLib.findImage("image3");
        LibraryStructureTest.assertNotNull((Object)includeImage);
        LibraryStructureTest.assertEquals((Object)includeImage, (Object)libReference.getTargetStructure());
        LibraryStructureTest.assertNull((Object)image.getLocalProperty((Module)this.design, "data"));
        LibraryStructureTest.assertTrue((image.getProperty((Module)this.design, "data") == includeImage.getProperty(includeLib.getModule(), "data") ? 1 : 0) != 0);
        LibraryStructureTest.assertTrue((boolean)Arrays.equals(image.getData((Module)this.design), includeImage.getData(includeLib.getModule())));
        this.save();
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image1");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        LibraryStructureTest.assertEquals((String)"design image1", (String)imageHandle.getEmbeddedImage().getQualifiedName());
        imageHandle = (ImageHandle)this.designHandle.findElement("Image2");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        LibraryStructureTest.assertEquals((String)"design image2", (String)imageHandle.getEmbeddedImage().getQualifiedName());
    }

    public void testResolveForStructure() throws Exception {
        this.openDesign("LibraryStructureTest_1.xml");
        LibraryStructureTest.assertNotNull((Object)this.designHandle);
        EmbeddedImage image = this.designHandle.findImage("design image4");
        LibraryStructureTest.assertNotNull((Object)image);
        StructRefValue libReference = (StructRefValue)image.getProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)libReference);
        LibraryStructureTest.assertFalse((boolean)libReference.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)libReference.getQualifiedReference());
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("Image2");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        StructRefValue imageName = (StructRefValue)imageHandle.getElement().getProperty((Module)this.design, "imageName");
        LibraryStructureTest.assertNotNull((Object)imageName);
        LibraryStructureTest.assertFalse((boolean)imageName.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)imageName.getName());
        LibraryStructureTest.assertNull((Object)imageHandle.getEmbeddedImage());
        this.designHandle.includeLibrary("Library_2.xml", "Lib2");
        LibraryHandle includeLib = this.designHandle.getLibrary("Lib2");
        LibraryStructureTest.assertNotNull((Object)includeLib);
        LibraryStructureTest.assertEquals((int)2, (int)this.designHandle.getLibraries().size());
        libReference = (StructRefValue)image.getProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)libReference);
        LibraryStructureTest.assertTrue((boolean)libReference.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)libReference.getQualifiedReference());
        imageHandle = (ImageHandle)this.designHandle.findElement("Image2");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        imageName = (StructRefValue)imageHandle.getElement().getProperty((Module)this.design, "imageName");
        LibraryStructureTest.assertNotNull((Object)imageName);
        LibraryStructureTest.assertTrue((boolean)imageName.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)imageName.getQualifiedReference());
        LibraryStructureTest.assertEquals((String)"image3", (String)imageName.getName());
        LibraryStructureTest.assertEquals((String)"Lib2", (String)imageName.getLibraryNamespace());
        LibraryStructureTest.assertNotNull((Object)imageHandle.getEmbeddedImage());
        this.designHandle.dropLibrary(includeLib);
        libReference = (StructRefValue)image.getProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)libReference);
        LibraryStructureTest.assertFalse((boolean)libReference.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)libReference.getQualifiedReference());
        imageHandle = (ImageHandle)this.designHandle.findElement("Image2");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        imageName = (StructRefValue)imageHandle.getElement().getProperty((Module)this.design, "imageName");
        LibraryStructureTest.assertNotNull((Object)imageName);
        LibraryStructureTest.assertFalse((boolean)imageName.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)imageName.getName());
        LibraryStructureTest.assertNull((Object)imageHandle.getEmbeddedImage());
        this.designHandle.getCommandStack().undo();
        imageName = (StructRefValue)imageHandle.getElement().getProperty((Module)this.design, "imageName");
        LibraryStructureTest.assertNotNull((Object)imageName);
        LibraryStructureTest.assertTrue((boolean)imageName.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib2.image3", (String)imageName.getQualifiedReference());
        LibraryStructureTest.assertEquals((String)"image3", (String)imageName.getName());
        LibraryStructureTest.assertEquals((String)"Lib2", (String)imageName.getLibraryNamespace());
    }

    public void testVisibilityForStructure() throws Exception {
        this.openDesign("LibraryStructureTest_2.xml");
        LibraryStructureTest.assertNotNull((Object)this.designHandle);
        LibraryHandle visibleLib = this.designHandle.getLibrary("CompositeLib");
        LibraryStructureTest.assertNotNull((Object)visibleLib);
        EmbeddedImage image = this.designHandle.findImage("design image3");
        LibraryStructureTest.assertNotNull((Object)image);
        StructRefValue libReference = (StructRefValue)image.getProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)libReference);
        LibraryStructureTest.assertTrue((boolean)libReference.isResolved());
        LibraryStructureTest.assertEquals((String)"Lib1.image3", (String)libReference.getQualifiedReference());
        LibraryHandle invisibleLib = visibleLib.getLibrary("Lib1");
        LibraryStructureTest.assertNotNull((Object)invisibleLib);
        EmbeddedImage invisibleImage = invisibleLib.findImage("image3");
        LibraryStructureTest.assertNotNull((Object)invisibleImage);
    }

    public void testEmbeddedImageInImageItem() throws Exception {
        this.openDesign("LibraryStructureTest_3.xml");
        LibraryStructureTest.assertNotNull((Object)this.designHandle);
        this.libraryHandle = this.designHandle.getLibrary("Lib1");
        LibraryStructureTest.assertNotNull((Object)this.libraryHandle);
        PropertyHandle images = this.libraryHandle.getPropertyHandle("images");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("image");
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        LibraryStructureTest.assertEquals((String)"Lib1.image1", (String)imageHandle.getImageName());
        LibraryStructureTest.assertEquals((Object)"Lib1.image1", (Object)imageHandle.getProperty("imageName"));
        LibraryStructureTest.assertEquals((Object)images.getAt(0).getStructure(), (Object)imageHandle.getEmbeddedImage().getStructure());
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("grid");
        LibraryStructureTest.assertNotNull((Object)gridHandle);
        imageHandle = (ImageHandle)gridHandle.getCell(1, 1).getContent().get(0);
        LibraryStructureTest.assertNotNull((Object)imageHandle);
        LibraryStructureTest.assertEquals((Object)images.getAt(1).getStructure(), (Object)imageHandle.getEmbeddedImage().getStructure());
        LibraryStructureTest.assertEquals((String)"Lib1.image2", (String)imageHandle.getImageName());
        LibraryStructureTest.assertEquals((Object)"Lib1.image2", (Object)imageHandle.getProperty("imageName"));
    }

    public void testMultiExtendedElements() throws Exception {
        this.openDesign("LibraryStructureTest_4.xml");
        ImageHandle imageHandle = (ImageHandle)this.designHandle.findElement("image1");
        LibraryStructureTest.assertEquals((String)"Lib1.image1", (String)imageHandle.getImageName());
        LibraryStructureTest.assertEquals((Object)"Lib1.image1", (Object)imageHandle.getProperty("imageName"));
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("grid1");
        LibraryStructureTest.assertNotNull((Object)gridHandle);
        imageHandle = (ImageHandle)gridHandle.getCell(1, 1).getContent().get(0);
        LibraryStructureTest.assertEquals((Object)"Lib1.image2", (Object)imageHandle.getProperty("imageName"));
        LibraryStructureTest.assertEquals((String)"Lib1.image2", (String)imageHandle.getImageName());
        EmbeddedImage emImage = this.designHandle.findImage("Lib1.image1");
        LibraryStructureTest.assertNotNull((Object)emImage);
        emImage = this.designHandle.findImage("Lib1.image2");
        LibraryStructureTest.assertNotNull((Object)emImage);
    }

    public void testLibraryIncludeLibrary() {
        try {
            this.openLibrary("LibraryIncludingTwoLibraries.xml");
        }
        catch (DesignFileException e) {
            LibraryStructureTest.fail();
        }
        LibraryStructureTest.assertNotNull((Object)this.libraryHandle);
    }

    public void testCreateImageFrom() throws Exception {
        this.openLibrary("Library_1.xml");
        Iterator iter1 = this.libraryHandle.imagesIterator();
        EmbeddedImageHandle baseImage = (EmbeddedImageHandle)iter1.next();
        this.openDesign("DesignWithoutLibrary.xml");
        try {
            StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)baseImage, (String)"image1", (ModuleHandle)this.designHandle);
            LibraryStructureTest.fail();
        }
        catch (SemanticException e) {
            LibraryStructureTest.assertEquals((String)"Error.LibraryException.LIBRARY_NOT_FOUND", (String)e.getErrorCode());
        }
        this.designHandle.includeLibrary("Library_1.xml", "Lib1");
        EmbeddedImage newImage = StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)baseImage, (String)"image1", (ModuleHandle)this.designHandle);
        LibraryStructureTest.assertEquals((String)"image1", (String)newImage.getName());
        LibraryStructureTest.assertNotNull((Object)newImage.getData((Module)this.design));
        LibraryStructureTest.assertNull((Object)newImage.getLocalProperty((Module)this.design, "data"));
        StructRefValue refValue = (StructRefValue)newImage.getLocalProperty((Module)this.design, "libReference");
        LibraryStructureTest.assertNotNull((Object)refValue);
        LibraryStructureTest.assertEquals((String)"Lib1.image1", (String)refValue.getQualifiedReference());
        this.designHandle.addImage(newImage);
        iter1 = this.designHandle.imagesIterator();
        baseImage = (EmbeddedImageHandle)iter1.next();
        LibraryStructureTest.assertNull((Object)StructureFactory.newEmbeddedImageFrom((EmbeddedImageHandle)baseImage, (String)"image3", (ModuleHandle)this.designHandle));
        this.save();
        LibraryStructureTest.assertTrue((boolean)this.compareFile("LibraryStructure_golden.xml"));
    }
}

