/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import com.ibm.icu.util.ULocale;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.eclipse.birt.report.model.api.IncludedCssStyleSheetHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.CssException;
import org.eclipse.birt.report.model.api.css.CssStyleSheetHandle;
import org.eclipse.birt.report.model.api.elements.structures.ConfigVariable;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.css.CssStyle;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryParseTest
extends BaseTestCase {
    private String fileName = "LibraryParseTest.xml";
    private String goldenFileName = "LibraryParseTest_golden.xml";
    private String semanticCheckFileName = "LibraryParseTest_1.xml";

    public void testAddCssStyleSheetOperation() throws Exception {
        this.openDesign("LibraryParserWithCss_Add.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        LabelHandle labelHandle2 = (LabelHandle)this.designHandle.findElement("label2");
        LibraryParseTest.assertEquals((String)"new.css", (String)((CssStyle)labelHandle.getStyle().getElement()).getCssStyleSheet().getFileName());
        LibraryParseTest.assertEquals((String)"new.css", (String)((CssStyle)labelHandle2.getStyle().getElement()).getCssStyleSheet().getFileName());
        CssStyleSheetHandle sheetHandle = this.designHandle.openCssStyleSheet("reslove.css");
        this.designHandle.addCss(sheetHandle);
        LibraryParseTest.assertEquals((String)"reslove.css", (String)((CssStyle)labelHandle.getStyle().getElement()).getCssStyleSheet().getFileName());
        LibraryParseTest.assertEquals((String)"reslove.css", (String)((CssStyle)labelHandle2.getStyle().getElement()).getCssStyleSheet().getFileName());
    }

    public void testDropCssStyleSheetOperation() throws Exception {
        this.openDesign("LibraryParserWithCss_Drop.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        LabelHandle labelHandle2 = (LabelHandle)this.designHandle.findElement("label2");
        LibraryParseTest.assertTrue((boolean)(((CssStyle)labelHandle.getStyle().getElement()).getContainer() instanceof Theme));
        LibraryParseTest.assertTrue((boolean)(((CssStyle)labelHandle2.getStyle().getElement()).getContainer() instanceof ReportDesign));
        CssStyleSheetHandle sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.dropCss(sheetHandle);
        LibraryParseTest.assertTrue((boolean)(((CssStyle)labelHandle.getStyle().getElement()).getContainer() instanceof Theme));
        LibraryParseTest.assertTrue((boolean)(((CssStyle)labelHandle2.getStyle().getElement()).getContainer() instanceof Theme));
    }

    public void testReloadAndCheckSemanticError() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/LibraryParserWithCss_Reload.xml");
        fileNames.add("input/base.css");
        fileNames.add("input/new2.css");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        String baseFilePath = (String)filePaths.get(1);
        String newFilePath = (String)filePaths.get(2);
        this.openDesign(designFilePath, false);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label3");
        LibraryParseTest.assertNull((Object)labelHandle.getStyle());
        LibraryParseTest.assertEquals((int)1, (int)labelHandle.getSemanticErrors().size());
        this.copyContentToFile(newFilePath, baseFilePath);
        CssStyleSheetHandle sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.reloadCss(sheetHandle);
        LibraryParseTest.assertNotNull((Object)labelHandle.getStyle());
        LibraryParseTest.assertEquals((String)"CaptionFigColumn2", (String)labelHandle.getStyle().getName());
        LibraryParseTest.assertEquals((int)0, (int)labelHandle.getSemanticErrors().size());
    }

    public void testReloadCssStyleSheetOperation() throws Exception {
        ArrayList<String> fileNames = new ArrayList<String>();
        fileNames.add("input/LibraryParserWithCss_Reload.xml");
        fileNames.add("input/base.css");
        fileNames.add("input/new.css");
        List filePaths = this.dumpDesignAndLibrariesToFile(fileNames);
        String designFilePath = (String)filePaths.get(0);
        String baseFilePath = (String)filePaths.get(1);
        String newFilePath = (String)filePaths.get(2);
        this.openDesign(designFilePath, false);
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        LabelHandle labelHandle2 = (LabelHandle)this.designHandle.findElement("label2");
        LibraryParseTest.assertNotNull((Object)labelHandle.getStyle());
        LibraryParseTest.assertEquals((String)"italic", (String)labelHandle2.getStyle().getFontStyle());
        this.copyContentToFile(newFilePath, baseFilePath);
        CssStyleSheetHandle sheetHandle = (CssStyleSheetHandle)this.designHandle.getAllCssStyleSheets().get(0);
        this.designHandle.reloadCss(sheetHandle);
        SharedStyleHandle styleHandle = labelHandle.getStyle();
        LibraryParseTest.assertNull((Object)styleHandle);
        SharedStyleHandle styleHandle2 = labelHandle2.getStyle();
        LibraryParseTest.assertNotNull((Object)styleHandle2);
        LibraryParseTest.assertEquals((String)"oblique", (String)styleHandle2.getFontStyle());
        File file = new File(baseFilePath);
        file.delete();
        try {
            this.designHandle.reloadCss(sheetHandle);
            LibraryParseTest.fail();
        }
        catch (CssException e) {
            LibraryParseTest.assertEquals((String)"Error.CSSException.CSS_NOT_FOUND", (String)e.getErrorCode());
        }
    }

    public void testResolveStyle() throws Exception {
        this.openDesign("LibraryParserWithCss_Reslove.xml");
        LabelHandle labelHandle = (LabelHandle)this.designHandle.findElement("label");
        LabelHandle labelHandle2 = (LabelHandle)this.designHandle.findElement("label2");
        LabelHandle labelHandle3 = (LabelHandle)this.designHandle.findElement("label3");
        LabelHandle labelHandle4 = (LabelHandle)this.designHandle.findElement("label4");
        LibraryHandle libHandle = this.designHandle.getLibrary("LibParserWithCss_Lib");
        ThemeHandle themeHandle = libHandle.findTheme("theme1");
        List csses = themeHandle.getAllCssStyleSheets();
        CssStyleSheetHandle sheetHandle = (CssStyleSheetHandle)csses.get(0);
        LibraryParseTest.assertFalse((boolean)themeHandle.canAddCssStyleSheet(sheetHandle));
        LibraryParseTest.assertFalse((boolean)themeHandle.canAddCssStyleSheet("base.css"));
        LibraryParseTest.assertFalse((boolean)themeHandle.canDropCssStyleSheet(sheetHandle));
        LibraryParseTest.assertEquals((String)"center", (String)labelHandle.getStyle().getTextAlign());
        LibraryParseTest.assertEquals((String)"right", (String)labelHandle2.getStyle().getTextAlign());
        LibraryParseTest.assertNull((Object)labelHandle3.getStyle().getTextAlign());
        LibraryParseTest.assertNull((Object)labelHandle4.getStyle().getTextAlign());
        LibraryParseTest.assertTrue((boolean)(((Style)labelHandle3.getStyle().getElement()).getContainer() instanceof Theme));
        LibraryParseTest.assertTrue((boolean)(((Style)labelHandle4.getStyle().getElement()).getContainer() instanceof Theme));
        LibraryParseTest.assertFalse((boolean)(labelHandle3.getStyle().getElement() instanceof CssStyle));
        LibraryParseTest.assertTrue((boolean)(labelHandle4.getStyle().getElement() instanceof CssStyle));
    }

    private void copyContentToFile(String source, String dest) throws Exception {
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] fileData = new byte[5120];
        int readCount = -1;
        while ((readCount = fis.read(fileData)) != -1) {
            fos.write(fileData, 0, readCount);
        }
        fos.close();
        fis.close();
    }

    private List dumpDesignAndLibrariesToFile(List fileNames) throws Exception {
        ArrayList<String> filePaths = new ArrayList<String>();
        int i = 0;
        while (i < fileNames.size()) {
            String resourceName = (String)fileNames.get(i);
            filePaths.add(this.copyContentToFile(resourceName));
            ++i;
        }
        return filePaths;
    }

    public void testParser() throws Exception {
        this.openLibrary(this.fileName, ULocale.ENGLISH);
        LibraryParseTest.assertEquals((String)"W.C. Fields", (String)this.libraryHandle.getStringProperty("author"));
        LibraryParseTest.assertEquals((String)"http://company.com/reportHelp.html", (String)this.libraryHandle.getStringProperty("helpGuide"));
        LibraryParseTest.assertEquals((String)"Whiz-Bang Plus", (String)this.libraryHandle.getStringProperty("createdBy"));
        LibraryParseTest.assertEquals((String)"TITLE_ID", (String)this.libraryHandle.getStringProperty("titleID"));
        LibraryParseTest.assertEquals((String)"Sample Report", (String)this.libraryHandle.getStringProperty("title"));
        LibraryParseTest.assertEquals((String)"First sample report.", (String)this.libraryHandle.getStringProperty("comments"));
        LibraryParseTest.assertEquals((String)"DESCRIP_ID", (String)this.libraryHandle.getStringProperty("descriptionID"));
        LibraryParseTest.assertEquals((String)"This is a first sample report.", (String)this.libraryHandle.getStringProperty("description"));
        PropertyHandle colorPalette = this.libraryHandle.getPropertyHandle("colorPalette");
        ArrayList colors = colorPalette.getListValue();
        LibraryParseTest.assertEquals((int)2, (int)colors.size());
        CustomColor color = (CustomColor)colors.get(0);
        LibraryParseTest.assertEquals((String)"cus red", (String)color.getName());
        LibraryParseTest.assertEquals((int)111, (int)color.getRGB());
        LibraryParseTest.assertEquals((String)"cus red key", (String)color.getDisplayNameID());
        LibraryParseTest.assertEquals((String)"cus red display", (String)color.getDisplayName());
        color = (CustomColor)colors.get(1);
        LibraryParseTest.assertEquals((String)"cus blue", (String)color.getName());
        LibraryParseTest.assertEquals((int)222, (int)color.getRGB());
        LibraryParseTest.assertEquals((String)"cus blue key", (String)color.getDisplayNameID());
        PropertyHandle configVarHandle = this.libraryHandle.getPropertyHandle("configVars");
        ArrayList configVars = configVarHandle.getListValue();
        LibraryParseTest.assertEquals((int)4, (int)configVars.size());
        ConfigVariable var = (ConfigVariable)configVars.get(0);
        LibraryParseTest.assertEquals((String)"var1", (String)var.getName());
        LibraryParseTest.assertEquals((String)"mumble.jpg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(1);
        LibraryParseTest.assertEquals((String)"var2", (String)var.getName());
        LibraryParseTest.assertEquals((String)"abcdefg", (String)var.getValue());
        var = (ConfigVariable)configVars.get(2);
        LibraryParseTest.assertEquals((String)"var3", (String)var.getName());
        LibraryParseTest.assertEquals((String)"", (String)var.getValue());
        var = (ConfigVariable)configVars.get(3);
        LibraryParseTest.assertEquals((String)"var4", (String)var.getName());
        LibraryParseTest.assertEquals(null, (String)var.getValue());
        PropertyHandle imageHandle = this.libraryHandle.getPropertyHandle("images");
        ArrayList images = imageHandle.getListValue();
        LibraryParseTest.assertEquals((int)3, (int)images.size());
        EmbeddedImage image = (EmbeddedImage)images.get(0);
        LibraryParseTest.assertEquals((String)"image1", (String)image.getName());
        LibraryParseTest.assertEquals((String)"image/bmp", (String)image.getType(this.libraryHandle.getModule()));
        LibraryParseTest.assertEquals((String)"imagetesAAA", (String)new String(Base64.getEncoder().encode(image.getData(this.libraryHandle.getModule()))).substring(0, 11));
        image = (EmbeddedImage)images.get(1);
        LibraryParseTest.assertEquals((String)"image2", (String)image.getName());
        LibraryParseTest.assertEquals((String)"image/gif", (String)image.getType(this.libraryHandle.getModule()));
        LibraryParseTest.assertEquals((String)"/9j/4AAQSkZJRgA", (String)new String(Base64.getEncoder().encode(image.getData(this.libraryHandle.getModule()))).substring(0, 15));
        image = (EmbeddedImage)images.get(2);
        LibraryParseTest.assertEquals((String)"image3", (String)image.getName());
        LibraryParseTest.assertEquals((String)"image/bmp", (String)image.getType(this.libraryHandle.getModule()));
        LibraryParseTest.assertEquals((String)"AAAA", (String)new String(Base64.getEncoder().encode(image.getData(this.libraryHandle.getModule()))));
        SlotHandle themes = this.libraryHandle.getThemes();
        LibraryParseTest.assertEquals((int)2, (int)themes.getCount());
        ThemeHandle theme = (ThemeHandle)themes.get(0);
        LibraryParseTest.assertEquals((int)1, (int)theme.getStyles().getCount());
        theme = (ThemeHandle)themes.get(1);
        LibraryParseTest.assertEquals((int)2, (int)theme.getStyles().getCount());
        theme = this.libraryHandle.findTheme("theme1");
        IncludedCssStyleSheetHandle css = (IncludedCssStyleSheetHandle)theme.includeCssesIterator().next();
        LibraryParseTest.assertEquals((String)"base.css", (String)css.getFileName());
        List styles = theme.getAllStyles();
        LibraryParseTest.assertEquals((int)10, (int)styles.size());
    }

    public void testWriter() throws Exception {
        this.openLibrary(this.fileName, ULocale.ENGLISH);
        this.libraryHandle.setProperty("author", (Object)"Report Author");
        this.libraryHandle.setProperty("helpGuide", (Object)"Help guide");
        this.libraryHandle.setProperty("createdBy", (Object)"Report Creator");
        this.libraryHandle.setProperty("base", (Object)"c:\\base");
        this.libraryHandle.setProperty("units", (Object)"cm");
        this.libraryHandle.setProperty("includeResource", (Object)"new include resource");
        this.libraryHandle.setProperty("titleID", (Object)"New title id");
        this.libraryHandle.setProperty("title", (Object)"New title");
        this.libraryHandle.setProperty("comments", (Object)"New comments");
        this.libraryHandle.setProperty("descriptionID", (Object)"New description id");
        this.libraryHandle.setProperty("description", (Object)"New description");
        this.saveLibrary();
        LibraryParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testConfigVars() throws Exception {
        this.openLibrary(this.fileName, ULocale.ENGLISH);
        ConfigVariable configVar = new ConfigVariable();
        configVar.setName("VarToAdd");
        configVar.setValue("ValueToAdd");
        ConfigVariable newConfigVar = new ConfigVariable();
        newConfigVar.setName("VarToReplace");
        newConfigVar.setValue("ValueToReplace");
    }

    public void testSemanticError() throws Exception {
        this.openLibrary(this.semanticCheckFileName);
    }
}

