/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.rtf.RTFEditorKit;
import org.eclipse.birt.report.designer.internal.ui.util.RTFDocumentHandler;

public class RTFParser {
    public static void parse(String rtfString, RTFDocumentHandler handler) throws IOException, BadLocationException {
        RTFEditorKit rtfeditorkit = new RTFEditorKit();
        DefaultStyledDocument document = new DefaultStyledDocument();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(rtfString.getBytes());
        rtfeditorkit.read(bytearrayinputstream, (Document)document, 0);
        Element element = document.getDefaultRootElement();
        RTFParser.parseElement(document, element, handler, true);
    }

    private static void parseElement(DefaultStyledDocument document, Element parent, RTFDocumentHandler handler, boolean lostLast) {
        int i = 0;
        while (i < parent.getElementCount()) {
            if (lostLast && i == parent.getElementCount() - 1 && parent.getElementCount() != 1) break;
            Element element = parent.getElement(i);
            AttributeSet attributeset = element.getAttributes();
            handler.startElement(element.getName(), attributeset);
            if (element.getName().equalsIgnoreCase("content")) {
                try {
                    int start = element.getStartOffset();
                    int end = element.getEndOffset();
                    String s = document.getText(start, end - start);
                    handler.content(s);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
            RTFParser.parseElement(document, element, handler, false);
            handler.endElement(element.getName());
            ++i;
        }
    }
}

