/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles;

import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.TableUtil;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.CornerHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.RowDragHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.RowHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.TableHFHandle;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionDimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.handles.MoveHandleLocator;

public class TableRowHandle
extends TableHFHandle {
    public TableRowHandle(TableEditPart owner) {
        super(owner, (Locator)new TableRowHandleLocator(owner));
    }

    @Override
    protected void initChildrenHandle() {
        TableEditPart part = this.getTableEditPart();
        List<?> list = part.getRows();
        CornerHandle conner = new CornerHandle(part);
        conner.setLocation(new Point(0, 0));
        conner.setSize(40, 19);
        this.add((IFigure)conner);
        int size = list.size();
        int height = 19;
        int i = 0;
        while (i < size) {
            Object row = list.get(i);
            RowHandle handle = new RowHandle(part, this.getRowNumber(row));
            handle.setPreferredSize(this.getBounds().width, this.getRowHeight(row));
            handle.setBounds(new Rectangle(this.getBounds().x, height, this.getBounds().width, this.getRowHeight(row)));
            height += this.getRowHeight(row);
            this.add((IFigure)handle);
            if (i == size - 1) {
                height -= 2;
            }
            RowDragHandle dragHandle = new RowDragHandle(part, this.getRowNumber(row), i == size - 1 ? this.getRowNumber(row) : this.getRowNumber(row) + 1);
            dragHandle.setBounds(new Rectangle(this.getBounds().x, height, this.getBounds().width, 2));
            this.add((IFigure)dragHandle);
            ++i;
        }
    }

    private static class TableRowHandleLocator
    extends MoveHandleLocator {
        private TableEditPart owner;

        public TableRowHandleLocator(TableEditPart part) {
            super(part.getFigure());
            this.setOwner(part);
        }

        public void relocate(IFigure target) {
            Rectangle bounds = this.getReference().getBounds();
            Insets referenceInsets = this.getReference().getInsets();
            bounds = new PrecisionRectangle(new Rectangle(bounds.x + referenceInsets.left - 40, bounds.y + referenceInsets.top - 19, 40, bounds.height + 19 - 1 - (referenceInsets.top + referenceInsets.bottom)));
            this.getReference().translateToAbsolute((Translatable)bounds);
            target.translateToRelative((Translatable)bounds);
            target.setBounds(bounds);
            this.relocateChildren(target, this.getReference());
        }

        private void relocateChildren(IFigure parent, IFigure reference) {
            List children = parent.getChildren();
            int size = children.size();
            int height = 0;
            Dimension pDim = parent.getSize();
            int width = pDim.width;
            int x = parent.getBounds().x;
            int i = 0;
            while (i < size) {
                IFigure f = (IFigure)children.get(i);
                Rectangle bounds = f.getBounds().getCopy();
                bounds = new PrecisionRectangle(bounds);
                PrecisionDimension dim = new PrecisionDimension(bounds.getSize());
                if (f instanceof CornerHandle) {
                    dim = new PrecisionDimension(40.0, 19.0);
                } else if (f instanceof RowDragHandle) {
                    dim = new PrecisionDimension((double)bounds.width, 2.0);
                } else if (f instanceof RowHandle) {
                    Object row = this.getOwner().getRow(((RowHandle)f).getRowNumber());
                    dim = new PrecisionDimension((double)bounds.width, (double)TableUtil.caleVisualHeight(this.getOwner(), row));
                }
                reference.translateToAbsolute((Translatable)dim);
                f.translateToRelative((Translatable)dim);
                if (i == 0) {
                    height = bounds.y;
                }
                bounds.width = width;
                bounds.height = dim.height;
                bounds.y = height;
                bounds.x = x;
                if (!(f instanceof RowDragHandle)) {
                    height += dim.height;
                }
                if (i == size - 1 && f instanceof RowDragHandle) {
                    bounds.y -= dim.height;
                }
                f.setBounds(bounds);
                ++i;
            }
        }

        public TableEditPart getOwner() {
            return this.owner;
        }

        public void setOwner(TableEditPart owner) {
            this.owner = owner;
        }
    }
}

