/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute.impl;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.AttributePackage;
import org.eclipse.birt.chart.model.attribute.StringFormatSpecifier;
import org.eclipse.birt.chart.model.attribute.impl.FormatSpecifierImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class StringFormatSpecifierImpl
extends FormatSpecifierImpl
implements StringFormatSpecifier {
    protected static final String PATTERN_EDEFAULT = null;
    protected String pattern = PATTERN_EDEFAULT;
    private char chcase;
    private int nand;
    private int natt;
    private boolean dir;
    private boolean trim;

    protected StringFormatSpecifierImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return AttributePackage.Literals.STRING_FORMAT_SPECIFIER;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public void setPattern(String newPattern) {
        String oldPattern = this.pattern;
        this.pattern = newPattern;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldPattern, (Object)this.pattern));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getPattern();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setPattern((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setPattern(PATTERN_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return PATTERN_EDEFAULT == null ? this.pattern != null : !PATTERN_EDEFAULT.equals(this.pattern);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (pattern: ");
        result.append(this.pattern);
        result.append(')');
        return result.toString();
    }

    protected void set(StringFormatSpecifier src) {
        super.set(src);
        this.pattern = src.getPattern();
    }

    @Override
    public StringFormatSpecifier copyInstance() {
        StringFormatSpecifierImpl dest = new StringFormatSpecifierImpl();
        dest.set(this);
        return dest;
    }

    public static StringFormatSpecifier create() {
        StringFormatSpecifier sfs = AttributeFactory.eINSTANCE.createStringFormatSpecifier();
        return sfs;
    }

    public static StringFormatSpecifier create(String pattern) {
        StringFormatSpecifier sfs = StringFormatSpecifierImpl.create();
        sfs.setPattern(pattern);
        return sfs;
    }

    @Override
    public String format(String dValue, ULocale lo) {
        this.applyPattern(this.pattern);
        if (this.trim && dValue != null) {
            dValue = dValue.trim();
        }
        if (this.pattern.equals("Unformatted")) {
            return dValue;
        }
        int len = dValue.length();
        int col = this.natt + this.nand;
        int ext = 0;
        StringBuilder orig = new StringBuilder(dValue);
        StringBuilder fstr = new StringBuilder(this.pattern);
        StringBuilder ret = new StringBuilder("");
        int i = 0;
        int pos = 0;
        char fc = ' ';
        String sc = null;
        if (!this.dir) {
            if (len > col) {
                ret.append(this.handleCase(orig.substring(0, len - col), this.chcase, lo));
                pos = len - col;
                len = col;
            }
            ext = col - len;
        }
        int len2 = this.pattern.length();
        i = 0;
        while (i < len2) {
            fc = fstr.charAt(i);
            switch (fc) {
                case '&': 
                case '@': {
                    if (ext > 0 || len == 0) {
                        if (fc == '@') {
                            ret.append(' ');
                        }
                        --ext;
                        break;
                    }
                    sc = orig.substring(pos, pos + 1);
                    ret.append(this.handleCase(sc, this.chcase, lo));
                    ++pos;
                    --len;
                    break;
                }
                case '!': 
                case '<': 
                case '>': 
                case '^': {
                    break;
                }
                default: {
                    ret.append(fc);
                }
            }
            ++i;
        }
        while (--len >= 0) {
            sc = orig.substring(pos, pos + 1);
            ret.append(this.handleCase(sc, this.chcase, lo));
            ++pos;
        }
        return ret.toString();
    }

    private void init() {
        this.chcase = (char)32;
        this.nand = 0;
        this.natt = 0;
        this.dir = false;
        this.trim = true;
    }

    public void applyPattern(String format) {
        this.init();
        if (format == null) {
            return;
        }
        int c = 32;
        StringBuilder scan = new StringBuilder(format);
        int len = scan.length();
        int i = 0;
        while (i < len) {
            c = scan.charAt(i);
            switch (c) {
                case 64: {
                    ++this.natt;
                    break;
                }
                case 38: {
                    ++this.nand;
                    break;
                }
                case 60: 
                case 62: {
                    this.chcase = (char)c;
                    break;
                }
                case 33: {
                    this.dir = true;
                    break;
                }
                case 94: {
                    this.trim = false;
                }
            }
            ++i;
        }
        if ("Zip Code + 4".equalsIgnoreCase(format)) {
            this.applyPattern("@@@@@-@@@@");
            return;
        }
        if ("Phone Number".equalsIgnoreCase(format)) {
            this.applyPattern("(@@@)@@@-@@@@");
            return;
        }
        if ("Social Security Number".equalsIgnoreCase(format)) {
            this.applyPattern("@@@-@@-@@@@");
            return;
        }
        this.pattern = format;
    }

    private String handleCase(String val, char option, ULocale locale) {
        if (option == '<') {
            return UCharacter.toLowerCase((ULocale)locale, (String)val);
        }
        if (option == '>') {
            return UCharacter.toUpperCase((ULocale)locale, (String)val);
        }
        return val;
    }
}

