/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.views.attributes.widget;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IFastConsumerProcessor;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.event.IModelEventProcessor;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.util.ModelEventInfo;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.page.WidgetUtil;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.AbstractFormHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.FilterHandleProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.provider.IFormProvider;
import org.eclipse.birt.report.designer.internal.ui.views.attributes.widget.PropertyDescriptor;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class FormPropertyDescriptor
extends PropertyDescriptor
implements IFastConsumerProcessor {
    public static final int SIMPLE_FUNCTION = 1;
    public static final int NORMAL_FUNCTION = 2;
    public static final int FULL_FUNCTION = 3;
    public static final int FULL_FUNCTION_HORIZONTAL = 4;
    public static final int NO_UP_DOWN = 5;
    private int style;
    private int index = 0;
    protected boolean bAddWithDialog = false;
    protected Button btnUp;
    protected Button btnDown;
    protected Button btnAdd;
    protected Button btnDel;
    protected Button btnEdit;
    protected Table table;
    protected TableViewer tableViewer;
    private int selectIndex;
    private Composite formPanel;
    int btnWidth = 60;
    private List eventList = new LinkedList();

    public void setButtonGroupIndex(int index) {
        this.index = index;
    }

    public FormPropertyDescriptor(boolean formStyle) {
        this.setFormStyle(formStyle);
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setButtonWithDialog(boolean withDialog) {
        this.bAddWithDialog = withDialog;
    }

    protected TableViewer getTableViewer() {
        return this.tableViewer;
    }

    private void enableUI(boolean enabled) {
        if (this.tableViewer != null) {
            this.table.setEnabled(enabled);
            if (this.btnUp != null) {
                this.btnUp.setEnabled(enabled);
            }
            if (this.btnDown != null) {
                this.btnDown.setEnabled(enabled);
            }
            this.btnAdd.setEnabled(enabled);
            this.btnDel.setEnabled(enabled);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(enabled);
            }
            if (enabled) {
                this.updateArraw();
            }
        }
    }

    private void editableUI(boolean editable) {
        if (this.tableViewer != null) {
            if (this.style != 1 && this.style != 5) {
                this.btnUp.setEnabled(editable);
                this.btnDown.setEnabled(editable);
            }
            this.btnAdd.setEnabled(editable);
            this.btnDel.setEnabled(editable);
            if (this.style == 3 || this.style == 4) {
                this.btnEdit.setEnabled(editable);
            }
            if (editable) {
                this.updateArraw();
            }
        }
    }

    @Override
    public void setInput(Object input) {
        this.input = input;
        this.getDescriptorProvider().setInput(input);
    }

    @Override
    public void load() {
        if (this.getDescriptorProvider() instanceof IFormProvider) {
            boolean enable = ((AbstractFormHandleProvider)this.getDescriptorProvider()).isEnable();
            boolean editable = ((IFormProvider)this.getDescriptorProvider()).isEditable();
            if (!enable) {
                this.enableUI(false);
                return;
            }
            this.tableViewer.setInput(this.input);
            this.enableUI(true);
            this.editableUI(editable);
            this.updateBindingParameters();
        }
    }

    @Override
    public Control getControl() {
        return this.formPanel;
    }

    @Override
    public Control createControl(Composite parent) {
        assert (this.getDescriptorProvider() != null);
        assert (this.getDescriptorProvider() instanceof IFormProvider);
        this.formPanel = FormWidgetFactory.getInstance().createComposite(parent);
        this.table = this.isFormStyle() ? FormWidgetFactory.getInstance().createTable(this.formPanel, 66308) : new Table(this.formPanel, 68356);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        String[] columnNames = ((IFormProvider)this.getDescriptorProvider()).getColumnNames();
        int i = 0;
        while (i < columnNames.length) {
            TableColumn column = new TableColumn(this.table, 16384);
            column.setText(columnNames[i]);
            column.setWidth(((IFormProvider)this.getDescriptorProvider()).getColumnWidths()[i]);
            ++i;
        }
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                FormPropertyDescriptor.this.handleTableKeyPressEvent(e);
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormPropertyDescriptor.this.handleTableSelectEvent();
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                FormPropertyDescriptor.this.handleTableMouseDoubleClickEvent();
            }
        });
        this.createTableViewer();
        this.btnDel = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.formPanel, "", 8) : new Button(this.formPanel, 2048);
        if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.PropertiesFile"))) {
            this.btnDel.setText(Messages.getString((String)"FormPage.Button.DeleteFile"));
        } else if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.JarFile"))) {
            this.btnDel.setText(Messages.getString((String)"FormPage.Button.DeleteFile.Alt1"));
        } else if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.JsFile"))) {
            this.btnDel.setText(Messages.getString((String)"FormPage.Button.DeleteFile.Alt2"));
        } else {
            this.btnDel.setText(Messages.getString((String)"FormPage.Button.Delete"));
        }
        this.btnDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormPropertyDescriptor.this.handleDelSelectEvent();
            }
        });
        this.btnAdd = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.formPanel, "", 8) : new Button(this.formPanel, 2048);
        if (this.bAddWithDialog) {
            if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.PropertiesFile"))) {
                this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog.PROP"));
            } else if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.JsFile"))) {
                this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog.JS"));
            } else if (this.descriptorProvider.getDisplayName().equals(Messages.getString((String)"ReportPageGenerator.List.Resources.JarFile"))) {
                this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog.JAR"));
            } else {
                this.btnAdd.setText(Messages.getString((String)"FormPage.Button.AddWithDialog"));
            }
        } else {
            this.btnAdd.setText(Messages.getString((String)"FormPage.Button.Add"));
        }
        this.btnAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FormPropertyDescriptor.this.handleAddSelectEvent();
            }
        });
        if (this.style == 3 || this.style == 4 || this.style == 5) {
            this.btnEdit = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.formPanel, "", 8) : new Button(this.formPanel, 2048);
            if (this.bAddWithDialog) {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.EditWithDialog"));
            } else {
                this.btnEdit.setText(Messages.getString((String)"FormPage.Button.Edit"));
            }
            this.btnEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormPropertyDescriptor.this.handleEditSelectEvent();
                }
            });
        }
        if (this.style != 1 && this.style != 5) {
            this.btnUp = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.formPanel, "", 8) : new Button(this.formPanel, 2048);
            if (this.index == 0) {
                this.btnUp.setText(Messages.getString((String)"FormPage.Button.Up"));
            } else if (1 == this.index) {
                this.btnUp.setText(Messages.getString((String)"FormPage.Button.Up.Alt1"));
            } else if (2 == this.index) {
                this.btnUp.setText(Messages.getString((String)"FormPage.Button.Up.Alt2"));
            }
            this.btnUp.setToolTipText(Messages.getString((String)"FormPage.toolTipText.Up"));
            this.btnUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormPropertyDescriptor.this.handleUpSelectEvent();
                }
            });
            this.btnDown = this.isFormStyle() ? FormWidgetFactory.getInstance().createButton(this.formPanel, "", 8) : new Button(this.formPanel, 2048);
            if (this.index == 0) {
                this.btnDown.setText(Messages.getString((String)"FormPage.Button.Down"));
            } else if (1 == this.index) {
                this.btnDown.setText(Messages.getString((String)"FormPage.Button.Down.Alt1"));
            } else if (2 == this.index) {
                this.btnDown.setText(Messages.getString((String)"FormPage.Button.Down.Alt2"));
            }
            this.btnDown.setToolTipText(Messages.getString((String)"FormPage.toolTipText.Down"));
            this.btnDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FormPropertyDescriptor.this.handleDownSelectEvent();
                }
            });
        }
        switch (this.style) {
            case 1: {
                this.simpleLayout();
                break;
            }
            case 2: {
                this.normallLayout();
                break;
            }
            case 3: {
                this.fullLayout();
                break;
            }
            case 4: {
                this.fullLayoutHorizontal();
                break;
            }
            case 5: {
                this.noUpDownLayout();
                break;
            }
        }
        return this.formPanel;
    }

    private void edit() {
        int pos = this.table.getSelectionIndex();
        if (pos == -1) {
            this.table.setFocus();
            return;
        }
        if (!((AbstractFormHandleProvider)this.getDescriptorProvider()).edit(pos) || this.table.isDisposed()) {
            return;
        }
        this.table.setSelection(pos);
    }

    protected void updateArraw() {
        IFormProvider provider;
        if (!((IFormProvider)this.getDescriptorProvider()).isEditable() || this.style == 1) {
            return;
        }
        int selectIndex = this.table.getSelectionIndex();
        int min = 0;
        int max = this.table.getItemCount() - 1;
        if (this.style != 5) {
            if (selectIndex <= 0) {
                this.btnUp.setEnabled(false);
            } else {
                this.btnUp.setEnabled(true);
            }
            if (selectIndex >= max || selectIndex == -1) {
                this.btnDown.setEnabled(false);
                if (selectIndex > max) {
                    this.btnUp.setEnabled(false);
                }
            } else {
                this.btnDown.setEnabled(true);
            }
        }
        if (min <= selectIndex && selectIndex <= max) {
            this.btnDel.setEnabled(true);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(true);
            }
        } else {
            this.btnDel.setEnabled(false);
            if (this.btnEdit != null) {
                this.btnEdit.setEnabled(false);
            }
        }
        if (this.getDescriptorProvider() instanceof IFormProvider && (provider = (IFormProvider)this.getDescriptorProvider()).isEnable()) {
            if (this.btnAdd.isEnabled()) {
                this.btnAdd.setEnabled(provider.isAddEnable(this.tableViewer.getSelection()));
            }
            if (this.btnEdit.isEnabled()) {
                this.btnEdit.setEnabled(provider.isEditEnable(this.tableViewer.getSelection()));
            }
            if (this.btnDel.isEnabled()) {
                this.btnDel.setEnabled(provider.isDeleteEnable(this.tableViewer.getSelection()));
            }
            if (this.style != 5) {
                if (this.btnUp.isEnabled()) {
                    this.btnUp.setEnabled(provider.isUpEnable(this.tableViewer.getSelection()));
                }
                if (this.btnDown.isEnabled()) {
                    this.btnDown.setEnabled(provider.isDownEnable(this.tableViewer.getSelection()));
                }
            }
        }
        if (this.getDescriptorProvider() instanceof FilterHandleProvider) {
            this.btnUp.setVisible(false);
            this.btnDown.setVisible(false);
        }
    }

    private void updateBindingParameters() {
        if (this.getDescriptorProvider() instanceof FilterHandleProvider) {
            ((FilterHandleProvider)this.getDescriptorProvider()).updateBindingParameters();
        }
    }

    private void moveItem(int oldPos, int newPos) {
        try {
            ((IFormProvider)this.getDescriptorProvider()).doMoveItem(oldPos, newPos);
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.formPanel.getShell(), (Exception)e);
        }
    }

    private void createTableViewer() {
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(((IFormProvider)this.getDescriptorProvider()).getColumnNames());
        CellEditor[] editors = ((IFormProvider)this.getDescriptorProvider()).getEditors(this.table);
        if (editors != null && editors.length > 0) {
            this.tableViewer.setCellEditors(((IFormProvider)this.getDescriptorProvider()).getEditors(this.table));
            this.tableViewer.setCellModifier((ICellModifier)new FormCellModifier());
        } else {
            this.tableViewer.setCellModifier((ICellModifier)new FormCellModifier(this){

                @Override
                public boolean canModify(Object element, String property) {
                    return false;
                }
            });
        }
        this.tableViewer.setContentProvider((IContentProvider)((AbstractFormHandleProvider)this.getDescriptorProvider()).getFormContentProvider((IModelEventProcessor)this, this.getDescriptorProvider()));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new FormLabelProvider());
    }

    protected void simpleLayout() {
        FormLayout layout = new FormLayout();
        layout.marginWidth = 8;
        layout.marginBottom = 8;
        layout.marginTop = 0;
        layout.spacing = 8;
        this.formPanel.setLayout((Layout)layout);
        int[] width = ((IFormProvider)this.getDescriptorProvider()).getColumnWidths();
        int dataWidth = 0;
        int i = 0;
        while (i < width.length) {
            dataWidth += width[i];
            ++i;
        }
        FormData data = new FormData();
        data.left = new FormAttachment(0, (dataWidth + 15 - layout.spacing) / 2 - Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x));
        data.width = Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.btnAdd, 0, 131072);
        data.width = Math.max(this.btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(0, dataWidth + 15);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void normallLayout() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 8;
        layout.marginTop = 0;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.formPanel.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = Math.max(this.btnWidth, this.btnDown.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDown.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDown, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnUp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnUp.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnUp, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDel, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnUp, 0, 1024);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void fullLayoutHorizontal() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 8;
        layout.marginTop = 0;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.formPanel.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = Math.max(this.btnWidth, this.btnDown.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDown.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDown, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnUp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnUp.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnUp, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment((Control)this.btnDel, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnUp, 0, 1024);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment(100);
        this.table.setLayoutData((Object)data);
    }

    protected void noUpDownLayout() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 8;
        layout.marginTop = 1;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.formPanel.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(90);
        data.top = new FormAttachment(0, 0);
        data.width = Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 128);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.btnAdd, 0, 16384);
        this.table.setLayoutData((Object)data);
    }

    protected void fullLayout() {
        FormLayout layout = new FormLayout();
        layout.marginBottom = 8;
        layout.marginTop = 1;
        layout.marginWidth = 8;
        layout.spacing = 8;
        this.formPanel.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(90);
        data.top = new FormAttachment(0, 0);
        data.width = Math.max(this.btnWidth, this.btnAdd.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnAdd.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 1024);
        data.left = new FormAttachment((Control)this.btnAdd, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnEdit.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnEdit.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnEdit, 0, 1024);
        data.left = new FormAttachment((Control)this.btnEdit, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnDel.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnDel, 0, 1024);
        data.left = new FormAttachment((Control)this.btnDel, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnUp.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnUp.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnUp, 0, 1024);
        data.left = new FormAttachment((Control)this.btnUp, 0, 16384);
        data.width = Math.max(this.btnWidth, this.btnDown.computeSize((int)-1, (int)-1, (boolean)true).x);
        this.btnDown.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)this.btnAdd, 0, 128);
        data.bottom = new FormAttachment(100);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.btnAdd, 0, 16384);
        this.table.setLayoutData((Object)data);
    }

    public void setHidden(boolean isHidden) {
        WidgetUtil.setExcludeGridData((Control)this.formPanel, (boolean)isHidden);
    }

    public void setVisible(boolean isVisible) {
        this.formPanel.setVisible(isVisible);
    }

    protected void handleAddSelectEvent() {
        int pos = this.table.getSelectionIndex();
        try {
            ((AbstractFormHandleProvider)this.getDescriptorProvider()).add(pos);
        }
        catch (Exception e) {
            WidgetUtil.processError((Shell)this.btnAdd.getShell(), (Exception)e);
            return;
        }
        if (this.table.isDisposed()) {
            return;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(this.table.getItemCount() - 1);
        }
        this.updateArraw();
    }

    protected void handleDelSelectEvent() {
        int pos;
        if (this.tableViewer.isCellEditorActive()) {
            this.tableViewer.cancelEditing();
        }
        if ((pos = this.table.getSelectionIndex()) == -1) {
            this.table.setFocus();
            return;
        }
        this.selectIndex = pos;
        int itemCount = this.table.getItemCount();
        if (this.selectIndex == itemCount - 1) {
            --this.selectIndex;
        }
        try {
            ((IFormProvider)this.getDescriptorProvider()).doDeleteItem(pos);
        }
        catch (Exception e1) {
            WidgetUtil.processError((Shell)this.btnDel.getShell(), (Exception)e1);
        }
        this.updateArraw();
    }

    protected void handleTableMouseDoubleClickEvent() {
        if (!((IFormProvider)this.getDescriptorProvider()).isEditable()) {
            return;
        }
        if (this.style == 3 || this.style == 4 || this.style == 5) {
            this.edit();
        }
    }

    protected void handleTableSelectEvent() {
        this.selectIndex = this.table.getSelectionIndex();
        this.updateArraw();
    }

    protected void handleTableKeyPressEvent(KeyEvent e) {
        if (!((IFormProvider)this.getDescriptorProvider()).isEditable()) {
            return;
        }
        if (e.keyCode == 127) {
            int itemCount = this.table.getItemCount();
            int pos = this.table.getSelectionIndex();
            if (pos < 0) {
                return;
            }
            if (this.selectIndex == itemCount - 1) {
                --this.selectIndex;
            }
            try {
                ((IFormProvider)this.getDescriptorProvider()).doDeleteItem(pos);
            }
            catch (Exception e1) {
                WidgetUtil.processError((Shell)this.table.getShell(), (Exception)e1);
            }
        } else if (e.character == '\r' && (this.style == 3 || this.style == 4)) {
            this.edit();
        }
    }

    protected void handleEditSelectEvent() {
        this.edit();
    }

    protected void handleUpSelectEvent() {
        if (this.tableViewer.isCellEditorActive()) {
            this.tableViewer.cancelEditing();
        }
        int oldPos = this.table.getSelectionIndex();
        this.selectIndex = oldPos - 1;
        this.moveItem(oldPos, oldPos - 1);
        this.updateArraw();
    }

    protected void handleDownSelectEvent() {
        if (this.tableViewer.isCellEditorActive()) {
            this.tableViewer.cancelEditing();
        }
        int oldPos = this.table.getSelectionIndex();
        this.selectIndex = oldPos + 1;
        this.moveItem(oldPos, oldPos + 1);
        this.updateArraw();
    }

    @Override
    public void save(Object obj) throws SemanticException {
    }

    public void addElementEvent(DesignElementHandle focus, NotificationEvent ev) {
        ModelEventInfo event = new ModelEventInfo(focus, ev);
        this.eventList.add(event);
    }

    public void clear() {
        this.eventList.clear();
    }

    public boolean isOverdued() {
        return this.getControl() == null || this.getControl().isDisposed();
    }

    public void postElementEvent() {
        while (this.eventList.size() > 0) {
            if (((IFormProvider)this.getDescriptorProvider()).needRefreshed(((ModelEventInfo)this.eventList.get(0)).getEvent()) && this.getControl() != null && !this.getControl().isDisposed()) {
                this.tableViewer.refresh();
                this.table.select(this.selectIndex);
                this.updateArraw();
                this.updateBindingParameters();
            }
            this.eventList.remove(0);
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    private class FormCellModifier
    implements ICellModifier {
        private FormCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            return ((IFormProvider)FormPropertyDescriptor.this.getDescriptorProvider()).canModify(element, property);
        }

        public Object getValue(Object element, String property) {
            return ((IFormProvider)FormPropertyDescriptor.this.getDescriptorProvider()).getValue(element, property);
        }

        public void modify(Object element, String property, Object value) {
            TableItem item = (TableItem)element;
            try {
                ((AbstractFormHandleProvider)FormPropertyDescriptor.this.getDescriptorProvider()).transModify(item.getData(), property, value);
            }
            catch (Exception e) {
                WidgetUtil.processError((Shell)FormPropertyDescriptor.this.table.getShell(), (Exception)e);
            }
        }
    }

    private class FormLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private FormLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return ((IFormProvider)FormPropertyDescriptor.this.getDescriptorProvider()).getImage(element, columnIndex);
        }

        public String getColumnText(Object element, int columnIndex) {
            return ((IFormProvider)FormPropertyDescriptor.this.getDescriptorProvider()).getColumnText(element, columnIndex);
        }
    }
}

