/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.util.Bytes;

public class DataType {
    public static final int UNKNOWN_TYPE = -1;
    public static final int BOOLEAN_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int DOUBLE_TYPE = 3;
    public static final int STRING_TYPE = 5;
    public static final int DATE_TYPE = 6;
    public static final int BIGDECIMAL_TYPE = 4;
    public static final int BLOB_TYPE = 7;
    public static final int BYTES_TYPE = 102;
    public static final int SQL_DATE_TYPE = 9;
    public static final int SQL_TIME_TYPE = 10;
    public static final int JAVA_OBJECT_TYPE = 11;
    private static final String[] names = new String[]{"Boolean", "Integer", "Double", "String", "DateTime", "Decimal", "Blob", "Bytes", "Date", "Time", "Java Object"};
    private static final int[] typeCodes = new int[]{1, 2, 3, 5, 6, 4, 7, 102, 9, 10, 11};
    public static final String BOOLEAN_TYPE_NAME = names[0];
    public static final String INTEGER_TYPE_NAME = names[1];
    public static final String DOUBLE_TYPE_NAME = names[2];
    public static final String STRING_TYPE_NAME = names[3];
    public static final String DATE_TYPE_NAME = names[4];
    public static final String BIGDECIMAL_TYPE_NAME = names[5];
    public static final String BLOB_TYPE_NAME = names[6];
    public static final String BYTES_TYPE_NAME = names[7];
    public static final String SQL_DATE_TYPE_NAME = names[8];
    public static final String SQL_TIME_TYPE_NAMW = names[9];
    public static final String JAVA_OBJECT_TYPE_NAMW = names[10];
    private static final Class[] classes = new Class[]{Boolean.class, Integer.class, Double.class, String.class, Date.class, BigDecimal.class, Blob.class, Bytes.class, java.sql.Date.class, Time.class, Object.class};

    public static String getName(int typeCode) {
        if (typeCode < 0 || typeCode >= typeCodes.length) {
            return "Unknown";
        }
        int i = 0;
        while (i < typeCodes.length) {
            if (typeCodes[i] == typeCode) {
                return names[i];
            }
            ++i;
        }
        return null;
    }

    public static Class getClass(int typeCode) {
        if (typeCode < 0 || typeCode >= classes.length) {
            return null;
        }
        int i = 0;
        while (i < typeCodes.length) {
            if (typeCodes[i] == typeCode) {
                return classes[i];
            }
            ++i;
        }
        return null;
    }

    public static int getDataType(Class objClass) {
        if (objClass.equals(Timestamp.class)) {
            return typeCodes[4];
        }
        if (objClass.equals(byte[].class)) {
            return typeCodes[6];
        }
        int i = 0;
        while (i < classes.length) {
            if (classes[i].equals(objClass)) {
                return typeCodes[i];
            }
            ++i;
        }
        return -1;
    }
}

