/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util.copy;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.util.IElementCopy;
import org.eclipse.birt.report.model.api.util.IPasteStatus;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.util.XPathUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.DesignSessionImpl;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.strategy.CopyForPastePolicy;
import org.eclipse.birt.report.model.elements.strategy.DummyCopyPolicy;
import org.eclipse.birt.report.model.util.copy.ContextCopiedElement;
import org.eclipse.birt.report.model.util.copy.PasteStatus;

class ContextCopyPasteBasePolicy {
    ContextCopyPasteBasePolicy() {
    }

    public IElementCopy createCopy(DesignElement source, Module root) {
        DesignElement localized;
        DesignElement destination;
        String location;
        long extendsElementID;
        String libLocation;
        String xpath;
        block10: {
            block9: {
                xpath = XPathUtil.getXPath(source.getHandle(root));
                String extendsName = source.getExtendsName();
                libLocation = null;
                extendsElementID = 0L;
                if (!StringUtil.isBlank(extendsName)) {
                    DesignElement element;
                    String namespace = StringUtil.extractNamespace(extendsName);
                    Library lib = root.getLibraryWithNamespace(namespace);
                    if (lib != null) {
                        libLocation = lib.getLocation();
                    }
                    if ((element = source.getExtendsElement()) != null) {
                        extendsElementID = element.getID();
                    }
                }
                location = null;
                if (root != null && root.getSystemId() != null) {
                    location = root.getLocation();
                }
                destination = null;
                try {
                    destination = (DesignElement)source.doClone(DummyCopyPolicy.getInstance());
                }
                catch (CloneNotSupportedException e) {
                    destination = null;
                    if ($assertionsDisabled) break block9;
                    throw new AssertionError();
                }
            }
            localized = null;
            try {
                localized = (DesignElement)source.doClone(CopyForPastePolicy.getInstance());
            }
            catch (CloneNotSupportedException e) {
                localized = null;
                if ($assertionsDisabled) break block10;
                throw new AssertionError();
            }
        }
        List<PropertyBinding> propertyBindings = null;
        if (root != null) {
            propertyBindings = root.getPropertyBindings(source);
        }
        return new ContextCopiedElement(destination, localized, xpath, location, libLocation, extendsElementID, propertyBindings);
    }

    public IPasteStatus isValidCopy(ContainerContext context, Module module, IElementCopy copy) {
        PasteStatus status = new PasteStatus();
        if (!(copy instanceof ContextCopiedElement)) {
            status.setPaste(false);
            status.setErrors(null);
            return status;
        }
        DesignElement copied = ((ContextCopiedElement)copy).getLocalizedCopy();
        if (copied == null) {
            status.setPaste(false);
            status.setErrors(null);
            return status;
        }
        List<SemanticException> errors = context.checkContainmentContext(module, copied);
        if (!(errors != null && !errors.isEmpty() || module != null && module.isReadOnly())) {
            status.setPaste(true);
            status.setErrors(null);
        } else {
            status.setPaste(false);
            status.setErrors(errors);
        }
        return status;
    }

    private DesignElement findElement(String extendName, Module module) {
        String namespace;
        if (!StringUtil.isBlank(extendName) && (namespace = StringUtil.extractNamespace(extendName)) != null) {
            Library lib = module.getLibraryWithNamespace(namespace);
            String name = StringUtil.extractName(extendName);
            if (lib != null && name != null) {
                return lib.findElement(name);
            }
        }
        return null;
    }

    private void preWorkForElement(ContextCopiedElement copy, Module module) {
        DesignElement element = copy.getCopy();
        String extName = element.getExtendsName();
        DesignElement ext = this.findElement(extName, module);
        if (ext != null && ext.hasUserProperties()) {
            Iterator<String> iter = element.propertyWithLocalValueIterator();
            while (iter.hasNext()) {
                String key = iter.next();
                if (element.getLocalUserPropertyDefn(key) != null || ext.getLocalUserPropertyDefn(key) == null) continue;
                element.addUserPropertyDefn(ext.getLocalUserPropertyDefn(key));
            }
        }
    }

    private void postWorkForElement(ContextCopiedElement copy, Module module) {
        DesignElement element = copy.getCopy();
        String extName = element.getExtendsName();
        DesignElement ext = this.findElement(extName, module);
        if (ext != null && ext.hasUserProperties()) {
            for (UserPropertyDefn propertyDef : ext.getLocalUserProperties()) {
                String name = propertyDef.getName();
                if (element.getLocalUserPropertyDefn(name) == null) continue;
                element.dropUserPropertyDefn(element.getLocalUserPropertyDefn(name));
            }
        }
    }

    public IDesignElement preWorkForPaste(ContainerContext context, IElementCopy content, Module module) {
        ContextCopiedElement copy = null;
        try {
            this.preWorkForElement((ContextCopiedElement)content, module);
            copy = (ContextCopiedElement)((ContextCopiedElement)content).clone();
            this.postWorkForElement((ContextCopiedElement)content, module);
            this.postWorkForElement(copy, module);
        }
        catch (CloneNotSupportedException e) {
            assert (false);
            return null;
        }
        String location = copy.getRootLocation();
        if (location == null) {
            return copy.getLocalizedCopy();
        }
        DesignElement copiedElement = copy.getCopy();
        DesignSessionImpl session = module.getSession();
        Module copiedRoot = session.getOpenedModule(location);
        if (copiedRoot == null) {
            return copy.getLocalizedCopy();
        }
        if (copiedRoot == module) {
            return copy.getUnlocalizedCopy();
        }
        String nameSpace = StringUtil.extractNamespace(copiedElement.getExtendsName());
        if (!StringUtil.isEmpty(nameSpace)) {
            Library lib = module.getLibraryWithNamespace(nameSpace);
            if (lib == null) {
                return copy.getLocalizedCopy();
            }
            long extendsElementID = copy.getExtendsElementID();
            if (extendsElementID == 0L) {
                return copy.getLocalizedCopy();
            }
            String libLocation = copy.getLibLocation();
            if (libLocation == null || !libLocation.equals(lib.getLocation())) {
                return copy.getLocalizedCopy();
            }
            Library copiedLib = copiedRoot.getLibraryWithNamespace(nameSpace);
            if (copiedLib == null) {
                return copy.getLocalizedCopy();
            }
            if (!libLocation.equals(copiedLib.getLocation())) {
                return copy.getLocalizedCopy();
            }
            DesignElement libElement = lib.getElementByID(extendsElementID);
            if (libElement == null) {
                return copy.getLocalizedCopy();
            }
            DesignElement copyLibElement = copiedLib.getElementByID(extendsElementID);
            if (libElement.getDefn() != copyLibElement.getDefn()) {
                return copy.getLocalizedCopy();
            }
        }
        return copy.getCopy();
    }

    public void copyPropertyBindings(IElementCopy copy, DesignElementHandle target) throws SemanticException {
        if (target == null || target.getRoot() == null || target.getRoot().getPropertyDefn("propertyBindings") == null) {
            return;
        }
        for (PropertyBinding propBinding : ((ContextCopiedElement)copy).getPropertyBindings()) {
            target.setPropertyBinding(propBinding.getName(), propBinding.getExpressionProperty("value"));
        }
    }
}

