/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.elements.table.LayoutCell;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroup;
import org.eclipse.birt.report.model.api.elements.table.LayoutGroupBand;
import org.eclipse.birt.report.model.api.elements.table.LayoutRow;
import org.eclipse.birt.report.model.api.elements.table.LayoutSlot;
import org.eclipse.birt.report.model.api.elements.table.LayoutUtil;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableItem;

public class LayoutTable {
    private LayoutSlot[] tableSlots;
    private LayoutGroupBand[] groupSlots;
    protected int nextCellId = 1;
    protected TableItem table;
    private Module module;
    private List overlappedCells = new ArrayList();

    public LayoutTable(TableItem table, Module module) {
        assert (table != null);
        this.table = table;
        this.module = module;
        this.tableSlots = new LayoutSlot[4];
        Arrays.fill(this.tableSlots, null);
        this.groupSlots = new LayoutGroupBand[2];
        Arrays.fill(this.groupSlots, null);
    }

    public TableHandle getTable() {
        return (TableHandle)this.table.getHandle(this.module);
    }

    public int getColumnCount() {
        return this.refreshColumnCount();
    }

    public CellHandle getCell(int slotId, int rowId, int colId) {
        if (slotId > this.tableSlots.length - 1 || rowId < 1 || colId < 1) {
            return null;
        }
        LayoutRow row = this.getSimpleSlot(slotId).getLayoutRow(rowId - 1);
        if (row == null) {
            return null;
        }
        LayoutCell cell = row.getLayoutCell(colId - 1);
        if (cell == null) {
            return null;
        }
        return cell.getCell();
    }

    public CellHandle getCell(int groupLevel, int slotId, int rowId, int colId) {
        if (slotId > this.groupSlots.length - 1 || rowId < 1 || colId < 1 || groupLevel > this.getGroupCount()) {
            return null;
        }
        LayoutSlot slot = this.getComplexSlot(slotId).getLayoutSlotWithGroupLevel(groupLevel);
        if (slot == null) {
            return null;
        }
        LayoutRow row = slot.getLayoutRow(rowId - 1);
        if (row == null) {
            return null;
        }
        LayoutCell cell = row.getLayoutCell(colId - 1);
        if (cell == null) {
            return null;
        }
        return cell.getCell();
    }

    public RowHandle getRow(int rowPosn) {
        LayoutRow layoutRow = this.getLayoutRow(rowPosn);
        if (layoutRow == null) {
            return null;
        }
        RowHandle row = layoutRow.getRow();
        assert (row != null);
        return row;
    }

    public CellHandle getCell(int rowPosn, int colPosn) {
        LayoutRow layoutRow = this.getLayoutRow(rowPosn);
        if (layoutRow == null) {
            return null;
        }
        LayoutCell layoutCell = layoutRow.getLayoutCell(colPosn - 1);
        if (layoutCell == null) {
            return null;
        }
        return layoutCell.getCell();
    }

    private LayoutRow getLayoutRow(int rowPosn) {
        List slots = LayoutUtil.getFlattenedLayoutSlots(this);
        LayoutRow row = null;
        int i = 0;
        int rowNumber = rowPosn;
        while (i < slots.size()) {
            LayoutSlot slot = (LayoutSlot)slots.get(i);
            int rowCount = slot.getRowCount();
            if (rowNumber <= rowCount) {
                row = slot.getLayoutRow(rowNumber - 1);
                break;
            }
            rowNumber -= rowCount;
            ++i;
        }
        return row;
    }

    public int getColumnPos(int slotId, int rowId, Cell cell) {
        assert (slotId == 2 || slotId == 0 || slotId == 3);
        LayoutSlot slot = this.getSimpleSlot(slotId);
        int colPosn = slot.getColumnPos(rowId, cell);
        if (colPosn != 0) {
            return colPosn;
        }
        return this.getOverlappedColumnPos(cell);
    }

    private int getOverlappedColumnPos(Cell cell) {
        int i = 0;
        while (i < this.overlappedCells.size()) {
            OverlappedArea overlappedCell = (OverlappedArea)this.overlappedCells.get(i);
            if (overlappedCell.getCell() == cell) {
                assert (overlappedCell.getRowSpanOffset() == 0);
                assert (overlappedCell.getColSpanOffset() == 0);
                return overlappedCell.colPosn;
            }
            ++i;
        }
        return 0;
    }

    public int getColumnPos(int groupLevel, int slotId, int rowId, Cell cell) {
        LayoutGroupBand groupSlot = this.getComplexSlot(slotId);
        LayoutSlot slot = groupSlot.getLayoutSlotWithGroupLevel(groupLevel);
        int colPosn = slot.getColumnPos(rowId, cell);
        if (colPosn != 0) {
            return colPosn;
        }
        return this.getOverlappedColumnPos(cell);
    }

    public LayoutSlot getLayoutSlot(int slotId) {
        assert (slotId == 2 || slotId == 0 || slotId == 3);
        return this.getSimpleSlot(slotId);
    }

    public LayoutSlot getLayoutSlot(int groupLevel, int slotId) {
        assert (groupLevel > 0);
        if (slotId > this.groupSlots.length) {
            return null;
        }
        return this.getComplexSlot(slotId).getLayoutSlotWithGroupLevel(groupLevel);
    }

    private LayoutSlot getSimpleSlot(int slotId) {
        LayoutSlot slot = this.tableSlots[slotId];
        if (slot == null) {
            this.tableSlots[slotId] = slot = new LayoutSlot(this, this.getColumnCount());
        }
        return slot;
    }

    public LayoutSlot getHeader() {
        return this.getSimpleSlot(0);
    }

    public LayoutSlot getDetail() {
        return this.getSimpleSlot(2);
    }

    public LayoutSlot getFooter() {
        return this.getSimpleSlot(3);
    }

    public LayoutGroup getLayoutGroup(int groupLevel) {
        if (groupLevel < 1 || groupLevel > this.getGroupCount()) {
            return null;
        }
        return new LayoutGroup(this, groupLevel);
    }

    protected int getGroupCount() {
        return this.table.getGroups().size();
    }

    private LayoutGroupBand getComplexSlot(int slotId) {
        LayoutGroupBand slot = this.groupSlots[slotId];
        if (slot == null) {
            this.groupSlots[slotId] = slot = new LayoutGroupBand(this, this.getColumnCount());
        }
        return slot;
    }

    protected LayoutGroupBand getGroupHeaders() {
        return this.getComplexSlot(0);
    }

    protected LayoutGroupBand getGroupFooters() {
        return this.getComplexSlot(1);
    }

    private int refreshColumnCount() {
        int tmpCount;
        int columnCount = 0;
        int i = 0;
        while (i < this.tableSlots.length) {
            if (this.tableSlots[i] != null && (tmpCount = this.tableSlots[i].getColumnCount()) > columnCount) {
                columnCount = tmpCount;
            }
            ++i;
        }
        i = 0;
        while (i < this.groupSlots.length) {
            if (this.groupSlots[i] != null && (tmpCount = this.groupSlots[i].getColumnCount()) > columnCount) {
                columnCount = tmpCount;
            }
            ++i;
        }
        return columnCount;
    }

    public String getLayoutString() {
        StringBuilder sb = new StringBuilder();
        sb.append("table " + this.table.getFullName() + " layout: \r\n");
        sb.append(this.getHeader().getLayoutString());
        sb.append(this.getGroupHeaders().getLayoutString());
        sb.append(this.getDetail().getLayoutString());
        sb.append(this.getGroupFooters().getLayoutString());
        sb.append(this.getFooter().getLayoutString());
        sb.append("\r\n");
        return sb.toString();
    }

    protected int getNextCellId() {
        int id = this.nextCellId++;
        return id;
    }

    protected Module getModule() {
        return this.module;
    }

    protected void addOverlappedCell(Cell cell, LayoutSlot slot, int rowPosn, int colPosn, int rowSpanOffset, int colSpanOffset) {
        this.overlappedCells.add(new OverlappedArea(cell, slot, rowPosn, colPosn, rowSpanOffset, colSpanOffset));
    }

    protected boolean hasOverlappedArea() {
        return !this.overlappedCells.isEmpty();
    }

    protected static class OverlappedArea {
        private Cell cell;
        private int colPosn;
        private int rowPosn;
        private LayoutSlot layoutSlot;
        private int colSpanOffset;
        private int rowSpanOffset;

        private OverlappedArea(Cell cell, LayoutSlot slot, int rowPosn, int columnPosn, int rowSpanOffset, int colSpanOffset) {
            this.cell = cell;
            this.colPosn = columnPosn;
            this.rowPosn = rowPosn;
            this.layoutSlot = slot;
            this.colSpanOffset = colSpanOffset;
            this.rowSpanOffset = rowSpanOffset;
        }

        protected Cell getCell() {
            return this.cell;
        }

        protected int getColPosn() {
            return this.colPosn;
        }

        protected int getRowPosn() {
            return this.rowPosn;
        }

        protected LayoutSlot getSlot() {
            return this.layoutSlot;
        }

        protected int getColSpanOffset() {
            return this.colSpanOffset;
        }

        protected int getRowSpanOffset() {
            return this.rowSpanOffset;
        }
    }
}

