/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.AbstractReportExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.InstanceIDComparator;
import org.eclipse.birt.report.engine.internal.document.v4.ReportletBodyExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class ReportletExecutorV4
extends AbstractReportExecutor {
    private Fragment fragment;
    private IReportItemExecutor bodyExecutor;

    public ReportletExecutorV4(ExecutionContext context, long offset) throws IOException, BirtException {
        super(context);
        this.fragment = this.createFragment(offset);
        this.bodyExecutor = new ReportletBodyExecutor(this.manager, this.fragment, offset);
    }

    @Override
    public void close() {
        try {
            if (this.bodyExecutor != null) {
                try {
                    this.bodyExecutor.close();
                }
                catch (BirtException birtException) {}
            }
        }
        finally {
            this.bodyExecutor = null;
            super.close();
        }
    }

    @Override
    public IReportContent execute() {
        return this.reportContent;
    }

    @Override
    public IReportItemExecutor getNextChild() throws BirtException {
        if (this.bodyExecutor != null) {
            IReportItemExecutor executor = this.bodyExecutor.getNextChild();
            this.bodyExecutor = null;
            return executor;
        }
        return null;
    }

    @Override
    public boolean hasNextChild() {
        return this.bodyExecutor != null;
    }

    protected Fragment createFragment(long offset) throws IOException {
        Object[] leftEdge = this.createIndexes(offset);
        Object[] rightEdge = new Object[leftEdge.length + 1];
        System.arraycopy(leftEdge, 0, rightEdge, 0, leftEdge.length);
        rightEdge[leftEdge.length] = Segment.RIGHT_MOST_EDGE;
        Fragment fragment = new Fragment(new InstanceIDComparator());
        fragment.addSection(leftEdge, rightEdge);
        fragment.build();
        return fragment;
    }

    protected InstanceIndex[] createIndexes(long offset) throws IOException {
        LinkedList<InstanceIndex> parents = new LinkedList<InstanceIndex>();
        IContent content = this.reader.loadContent(offset);
        while (content != null) {
            InstanceID iid = content.getInstanceID();
            DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
            if (docExt != null) {
                long index = docExt.getIndex();
                parents.addFirst(new InstanceIndex(iid, index));
            }
            content = (IContent)content.getParent();
        }
        InstanceIndex[] edges = new InstanceIndex[parents.size()];
        Iterator iter = parents.iterator();
        int length = 0;
        while (iter.hasNext()) {
            InstanceIndex index = (InstanceIndex)iter.next();
            edges[length++] = index;
        }
        return edges;
    }
}

