/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.w3c.tidy.Tidy;

public class HTMLTextParser {
    protected static Logger logger = Logger.getLogger(HTMLTextParser.class.getName());
    protected static HashSet<String> supportedTags = new HashSet();
    protected Tidy tidy = new Tidy();
    protected static Properties props;
    private static Pattern hn;
    private boolean supportAllTags = true;

    static {
        supportedTags.add("a");
        supportedTags.add("b");
        supportedTags.add("br");
        supportedTags.add("center");
        supportedTags.add("code");
        supportedTags.add("dd");
        supportedTags.add("del");
        supportedTags.add("div");
        supportedTags.add("dl");
        supportedTags.add("dt");
        supportedTags.add("font");
        supportedTags.add("em");
        supportedTags.add("hr");
        supportedTags.add("i");
        supportedTags.add("img");
        supportedTags.add("ins");
        supportedTags.add("li");
        supportedTags.add("ol");
        supportedTags.add("pre");
        supportedTags.add("p");
        supportedTags.add("span");
        supportedTags.add("strong");
        supportedTags.add("sub");
        supportedTags.add("sup");
        supportedTags.add("ul");
        supportedTags.add("tt");
        supportedTags.add("u");
        props = new Properties();
        try {
            props.load(HTMLTextParser.class.getResourceAsStream("htmlparser.properties"));
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
        }
        hn = Pattern.compile("h[\\d]");
    }

    public HTMLTextParser() {
        this.tidy.setConfigurationFromProps(props);
        this.supportAllTags = true;
    }

    public Document parseHTML(InputStream in) {
        assert (in != null);
        Document doc = this.tidy.parseDOM(in, null);
        DocumentBuilder docBuilder = DocumentBuilderPool.getDocumentBuilder();
        if (docBuilder == null) {
            return null;
        }
        Document desDoc = docBuilder.newDocument();
        DocumentBuilderPool.releaseDocumentBuilder(docBuilder);
        Element desBody = desDoc.createElement("body");
        desDoc.appendChild(desBody);
        Node html = null;
        Node child = doc.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 8) {
                Comment commentNode = desBody.getOwnerDocument().createComment(child.getNodeValue());
                desBody.appendChild(commentNode);
            } else if (child.getNodeType() == 1 && "html".equals(child.getNodeName())) {
                html = child;
                break;
            }
            child = child.getNextSibling();
        }
        if (html != null) {
            Node body;
            Node head = this.getNodeByName(html, "head");
            if (head != null) {
                Node child2 = head.getFirstChild();
                while (child2 != null) {
                    short nodeType = child2.getNodeType();
                    if (nodeType == 1) {
                        if ("script".equalsIgnoreCase(child2.getNodeName())) {
                            Element ele = desBody.getOwnerDocument().createElement(child2.getNodeName());
                            int i = 0;
                            while (i < child2.getAttributes().getLength()) {
                                Node attr = child2.getAttributes().item(i);
                                ele.setAttribute(attr.getNodeName(), attr.getNodeValue());
                                ++i;
                            }
                            desBody.appendChild(ele);
                            this.copyNode(child2, ele);
                        }
                    } else if (nodeType == 8) {
                        Comment commentNode = desBody.getOwnerDocument().createComment(child2.getNodeValue());
                        desBody.appendChild(commentNode);
                    }
                    child2 = child2.getNextSibling();
                }
            }
            if ((body = this.getNodeByName(html, "body")) != null) {
                this.copyNode(body, desBody);
            }
        }
        return desDoc;
    }

    private Node getNodeByName(Node parent, String childName) {
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1 && childName.equals(child.getNodeName())) {
                return child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private void copyNode(Node srcNode, Node desNode) {
        assert (srcNode != null && desNode != null);
        Node child = srcNode.getFirstChild();
        while (child != null) {
            short nodeType = child.getNodeType();
            if (nodeType == 3 || nodeType == 4) {
                Text txtNode = desNode.getOwnerDocument().createTextNode(child.getNodeValue());
                desNode.appendChild(txtNode);
            } else if (nodeType == 8) {
                Comment commentNode = desNode.getOwnerDocument().createComment(child.getNodeValue());
                desNode.appendChild(commentNode);
            } else if (nodeType == 1) {
                boolean bSupported = true;
                if (!(this.supportAllTags || supportedTags.contains(child.getNodeName()) || hn.matcher(child.getNodeName()).matches())) {
                    bSupported = false;
                }
                if (bSupported) {
                    Element ele = desNode.getOwnerDocument().createElement(child.getNodeName());
                    int i = 0;
                    while (i < child.getAttributes().getLength()) {
                        Node attr = child.getAttributes().item(i);
                        ele.setAttribute(attr.getNodeName(), attr.getNodeValue());
                        ++i;
                    }
                    desNode.appendChild(ele);
                    this.copyNode(child, ele);
                } else {
                    this.copyNode(child, desNode);
                }
            }
            child = child.getNextSibling();
        }
    }

    static class DocumentBuilderPool {
        private static final int MAX_POOL_SIZE = 16;
        private static BlockingQueue<DocumentBuilder> builders = new LinkedBlockingQueue<DocumentBuilder>(16);

        DocumentBuilderPool() {
        }

        public static DocumentBuilder getDocumentBuilder() {
            DocumentBuilder docBuilder = (DocumentBuilder)builders.poll();
            if (docBuilder == null) {
                docBuilder = DocumentBuilderPool.newDocumentBuilder();
            }
            return docBuilder;
        }

        public static void releaseDocumentBuilder(DocumentBuilder docBuilder) {
            docBuilder.reset();
            builders.offer(docBuilder);
        }

        private static DocumentBuilder newDocumentBuilder() {
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                return docBuilder;
            }
            catch (ParserConfigurationException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return null;
            }
        }
    }
}

