/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.css.engine;

import java.awt.SystemColor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.css.engine.value.RGBColorValue;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSConstants;
import org.w3c.dom.css.CSSValue;

public class SystemColorSupport
implements CSSConstants {
    protected static final Map<String, SystemColor> factories = new HashMap<String, SystemColor>();

    static {
        factories.put("ActiveBorder", SystemColor.windowBorder);
        factories.put("ActiveCaption", SystemColor.activeCaption);
        factories.put("AppWorkspace", SystemColor.desktop);
        factories.put("Background", SystemColor.desktop);
        factories.put("ButtonFace", SystemColor.control);
        factories.put("ButtonHighlight", SystemColor.controlLtHighlight);
        factories.put("ButtonShadow", SystemColor.controlDkShadow);
        factories.put("ButtonText", SystemColor.controlText);
        factories.put("CaptionText", SystemColor.activeCaptionText);
        factories.put("GrayText", SystemColor.textInactiveText);
        factories.put("Highlight", SystemColor.textHighlight);
        factories.put("HighlightText", SystemColor.textHighlightText);
        factories.put("InactiveBorder", SystemColor.windowBorder);
        factories.put("InactiveCaption", SystemColor.inactiveCaption);
        factories.put("InactiveCaptionText", SystemColor.inactiveCaptionText);
        factories.put("InfoBackground", SystemColor.info);
        factories.put("InfoText", SystemColor.infoText);
        factories.put("menu", SystemColor.menu);
        factories.put("MenuText", SystemColor.menuText);
        factories.put("Scrollbar", SystemColor.scrollbar);
        factories.put("ThreeDDarkShadow", SystemColor.controlDkShadow);
        factories.put("ThreeDFace", SystemColor.control);
        factories.put("ThreeDHighlight", SystemColor.controlHighlight);
        factories.put("ThreeDLightShadow", SystemColor.controlLtHighlight);
        factories.put("ThreeDShadow", SystemColor.controlShadow);
        factories.put("Window", SystemColor.window);
        factories.put("WindowFrame", SystemColor.windowBorder);
        factories.put("WindowText", SystemColor.windowText);
    }

    public static CSSValue getSystemColor(String ident) {
        ident = ident.toLowerCase();
        SystemColor sc = factories.get(ident);
        return new RGBColorValue(new FloatValue(1, sc.getRed()), new FloatValue(1, sc.getGreen()), new FloatValue(1, sc.getBlue()));
    }

    protected SystemColorSupport() {
    }
}

