/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.elements.IReportItemMethodContext;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IllegalContentInfo;
import org.eclipse.birt.report.model.api.extension.UndefinedPropertyInfo;
import org.eclipse.birt.report.model.api.metadata.IMethodInfo;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.namespace.NameExecutor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.interfaces.IExtendedItemModel;
import org.eclipse.birt.report.model.extension.PeerExtensibilityProvider;
import org.eclipse.birt.report.model.extension.SimplePeerExtensibilityProvider;

public class ExtendedItemHandle
extends ReportItemHandle
implements IExtendedItemModel,
IReportItemMethodContext {
    private static Logger logger = Logger.getLogger(ExtendedItemHandle.class.getName());

    public ExtendedItemHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public String getExtensionName() {
        return this.getStringProperty("extensionName");
    }

    public void loadExtendedElement() throws ExtendedElementException {
        ((ExtendedItem)this.getElement()).initializeReportItem(this.module);
    }

    public IReportItem getReportItem() throws ExtendedElementException {
        IReportItem reportItem = ((ExtendedItem)this.getElement()).getExtendedElement();
        if (reportItem == null) {
            this.loadExtendedElement();
            reportItem = ((ExtendedItem)this.getElement()).getExtendedElement();
        }
        return reportItem;
    }

    public List getExtensionPropertyDefinitionList() {
        if (((ExtendedItem)this.getElement()).getExtDefn() != null) {
            return ((ExtendedItem)this.getElement()).getExtDefn().getLocalProperties();
        }
        return Collections.EMPTY_LIST;
    }

    public List getMethods() {
        return ((ExtendedItem)this.getElement()).getMethods();
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        if (propHandle == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return propHandle.iterator();
    }

    public String getExternalScript() {
        String propName = ((ExtendedItem)this.getElement()).getScriptPropertyName();
        if (propName == null) {
            return null;
        }
        return this.getStringProperty(propName);
    }

    public void setExternalScript(String theScript) throws SemanticException {
        String propName = ((ExtendedItem)this.getElement()).getScriptPropertyName();
        if (propName == null) {
            return;
        }
        this.setStringProperty(propName, theScript);
    }

    public String getAltText() {
        return this.getStringProperty("altText");
    }

    @Override
    public String getAltTextKey() {
        return this.getStringProperty("altTextID");
    }

    public void setAltText(String altText) throws SemanticException {
        this.setStringProperty("altText", altText);
    }

    @Override
    public void setAltTextKey(String altTextKey) throws SemanticException {
        this.setStringProperty("altTextID", altTextKey);
    }

    public List getMethods(String context) {
        if (StringUtil.isBlank(context)) {
            return null;
        }
        IReportItem extension = null;
        try {
            extension = this.getReportItem();
        }
        catch (ExtendedElementException e) {
            return null;
        }
        IMethodInfo[] info = extension.getMethods(context);
        if (info == null || info.length == 0) {
            return null;
        }
        ArrayList<IMethodInfo> returnList = new ArrayList<IMethodInfo>();
        int i = 0;
        while (i < info.length) {
            IMethodInfo tmpInfo = info[i];
            if (tmpInfo == null) {
                logger.log(Level.WARNING, "The method info " + i + " in the methods are null.");
            } else {
                String tmpContext = tmpInfo.getName();
                if (StringUtil.isBlank(tmpContext)) {
                    logger.log(Level.WARNING, "The name of the method info " + i + " is empty or null.");
                } else {
                    returnList.add(tmpInfo);
                }
            }
            ++i;
        }
        return returnList;
    }

    public Map<String, UndefinedPropertyInfo> getUndefinedProperties() {
        PeerExtensibilityProvider provider = ((ExtendedItem)this.getElement()).getExtensibilityProvider();
        HashMap<String, UndefinedPropertyInfo> propMap = new HashMap<String, UndefinedPropertyInfo>(provider.getInvalidPropertyValueMap());
        propMap.putAll(provider.getUndefinedPropertyMap());
        return propMap;
    }

    public Map<String, List<IllegalContentInfo>> getIllegalContents() {
        PeerExtensibilityProvider provider = ((ExtendedItem)this.getElement()).getExtensibilityProvider();
        Map<String, List<SimplePeerExtensibilityProvider.UndefinedChildInfo>> illegalChildren = provider.getIllegalContents();
        if (illegalChildren == null || illegalChildren.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<IllegalContentInfo>> transMap = new HashMap<String, List<IllegalContentInfo>>();
        for (Map.Entry<String, List<SimplePeerExtensibilityProvider.UndefinedChildInfo>> entry : illegalChildren.entrySet()) {
            List<SimplePeerExtensibilityProvider.UndefinedChildInfo> childList = entry.getValue();
            if (childList == null || childList.isEmpty()) continue;
            ArrayList<IllegalContentInfo> transChildren = new ArrayList<IllegalContentInfo>();
            int i = 0;
            while (i < childList.size()) {
                SimplePeerExtensibilityProvider.UndefinedChildInfo infor = childList.get(i);
                transChildren.add(new IllegalContentInfo(infor, this.module));
                ++i;
            }
            transMap.put(entry.getKey(), transChildren);
        }
        return transMap;
    }

    public String getExtensionVersion() {
        return this.getStringProperty("extensionVersion");
    }

    public void setExtensionVersion(String extensionVersion) throws SemanticException {
        this.setStringProperty("extensionVersion", extensionVersion);
    }

    public void makeUniqueName(String namePrefix) throws NameException {
        NameExecutor executor = new NameExecutor(this.module, this.element);
        if (executor.hasNamespace()) {
            executor.makeUniqueName(namePrefix);
        }
    }
}

