/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.debug.internal.script.model;

import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugElement;
import org.eclipse.birt.report.debug.internal.script.model.ScriptDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class ScriptDebugThread
extends ScriptDebugElement
implements IThread {
    private static String NAME = "Thread [main]";
    private IBreakpoint[] fBreakpoints;
    private boolean isStepping;

    public ScriptDebugThread(ScriptDebugTarget target) {
        super(target);
    }

    public String getName() throws DebugException {
        return NAME + this.renderState();
    }

    private String renderState() {
        if (this.isTerminated()) {
            return " (Terminated)";
        }
        if (this.isSuspended()) {
            return " (Suspended)";
        }
        if (this.isStepping()) {
            return " (Stepping)";
        }
        return " (Running)";
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        IStackFrame[] retValue = this.isSuspended() ? ((ScriptDebugTarget)this.getDebugTarget()).getStackFrames() : new IStackFrame[]{};
        return retValue;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.canStep();
    }

    public boolean canStepOver() {
        return this.canStep();
    }

    public boolean canStepReturn() {
        return this.canStep();
    }

    public boolean isStepping() {
        return this.isStepping;
    }

    public void stepInto() throws DebugException {
        ((ScriptDebugTarget)this.getDebugTarget()).stepInto();
    }

    public void stepOver() throws DebugException {
        ((ScriptDebugTarget)this.getDebugTarget()).stepOver();
    }

    public void stepReturn() throws DebugException {
        ((ScriptDebugTarget)this.getDebugTarget()).stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    protected boolean canStep() {
        try {
            return this.isSuspended() && !this.isStepping() && this.getTopStackFrame() != null;
        }
        catch (DebugException e) {
            return false;
        }
    }

    protected void setStepping(boolean stepping) {
        this.isStepping = stepping;
    }

    @Override
    public String getDisplayName() {
        try {
            return this.getName();
        }
        catch (DebugException e) {
            return NAME;
        }
    }
}

